/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.result;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.mariadb.jdbc.internal.packet.dao.ColumnInformation;
import org.mariadb.jdbc.internal.packet.read.ReadPacketFetcher;
import org.mariadb.jdbc.internal.packet.result.RowPacket;
import org.mariadb.jdbc.internal.queryresults.resultset.value.MariaDbValueObject;
import org.mariadb.jdbc.internal.queryresults.resultset.value.ValueObject;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.buffer.Reader;

public class BinaryRowPacket
implements RowPacket {
    private final ColumnInformation[] columnInformation;
    private final Options options;
    private final int columnInformationLength;

    public BinaryRowPacket(ColumnInformation[] columnInformation, Options options, int columnInformationLength) {
        this.columnInformation = columnInformation;
        this.options = options;
        this.columnInformationLength = columnInformationLength;
    }

    public void appendPacketIfNeeded(Reader reader, ReadPacketFetcher packetFetcher) throws IOException {
        long encLength = reader.getSilentLengthEncodedBinary();
        long remaining = reader.getRemainingSize();
        while (encLength > remaining) {
            reader.appendPacket(packetFetcher.getRawPacket());
            encLength = reader.getSilentLengthEncodedBinary();
            remaining = reader.getRemainingSize();
        }
    }

    public void appendPacketIfNeeded(Reader reader, ReadPacketFetcher packetFetcher, long encLength) throws IOException {
        long remaining = reader.getRemainingSize();
        while (encLength > remaining) {
            reader.appendPacket(packetFetcher.getRawPacket(), encLength);
            encLength = reader.getSilentLengthEncodedBinary();
        }
    }

    @Override
    public ValueObject[] getRow(ReadPacketFetcher packetFetcher, ByteBuffer buffer) throws IOException {
        ValueObject[] valueObjects = new ValueObject[this.columnInformationLength];
        Reader reader = new Reader(buffer);
        reader.skipByte();
        int nullCount = (this.columnInformationLength + 9) / 8;
        byte[] nullBitsBuffer = reader.readRawBytes(nullCount);
        block10: for (int i = 0; i < this.columnInformationLength; ++i) {
            if ((nullBitsBuffer[(i + 2) / 8] & 1 << (i + 2) % 8) > 0) {
                valueObjects[i] = new MariaDbValueObject(null, this.columnInformation[i], true, this.options);
                continue;
            }
            switch (this.columnInformation[i].getType()) {
                case VARCHAR: 
                case BIT: 
                case ENUM: 
                case SET: 
                case TINYBLOB: 
                case MEDIUMBLOB: 
                case LONGBLOB: 
                case BLOB: 
                case VARSTRING: 
                case STRING: 
                case GEOMETRY: 
                case OLDDECIMAL: 
                case DECIMAL: {
                    this.appendPacketIfNeeded(reader, packetFetcher);
                    valueObjects[i] = new MariaDbValueObject(reader.getLengthEncodedBytes(), this.columnInformation[i], true, this.options);
                    continue block10;
                }
                case BIGINT: {
                    this.appendPacketIfNeeded(reader, packetFetcher, 8L);
                    valueObjects[i] = new MariaDbValueObject(reader.getLengthEncodedBytesWithLength(8L), this.columnInformation[i], true, this.options);
                    continue block10;
                }
                case INTEGER: 
                case MEDIUMINT: {
                    this.appendPacketIfNeeded(reader, packetFetcher, 4L);
                    valueObjects[i] = new MariaDbValueObject(reader.getLengthEncodedBytesWithLength(4L), this.columnInformation[i], true, this.options);
                    continue block10;
                }
                case SMALLINT: 
                case YEAR: {
                    this.appendPacketIfNeeded(reader, packetFetcher, 2L);
                    valueObjects[i] = new MariaDbValueObject(reader.getLengthEncodedBytesWithLength(2L), this.columnInformation[i], true, this.options);
                    continue block10;
                }
                case TINYINT: {
                    this.appendPacketIfNeeded(reader, packetFetcher, 1L);
                    valueObjects[i] = new MariaDbValueObject(reader.getLengthEncodedBytesWithLength(1L), this.columnInformation[i], true, this.options);
                    continue block10;
                }
                case DOUBLE: {
                    this.appendPacketIfNeeded(reader, packetFetcher, 8L);
                    valueObjects[i] = new MariaDbValueObject(reader.getLengthEncodedBytesWithLength(8L), this.columnInformation[i], true, this.options);
                    continue block10;
                }
                case FLOAT: {
                    this.appendPacketIfNeeded(reader, packetFetcher, 4L);
                    valueObjects[i] = new MariaDbValueObject(reader.getLengthEncodedBytesWithLength(4L), this.columnInformation[i], true, this.options);
                    continue block10;
                }
                case TIME: 
                case DATE: 
                case DATETIME: 
                case TIMESTAMP: {
                    this.appendPacketIfNeeded(reader, packetFetcher);
                    valueObjects[i] = new MariaDbValueObject(reader.getLengthEncodedBytes(), this.columnInformation[i], true, this.options);
                    continue block10;
                }
                default: {
                    this.appendPacketIfNeeded(reader, packetFetcher);
                    valueObjects[i] = new MariaDbValueObject(null, this.columnInformation[i], true, this.options);
                }
            }
        }
        return valueObjects;
    }
}

