/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.query.MariaDbQuery;
import org.mariadb.jdbc.internal.query.Query;
import org.mariadb.jdbc.internal.queryresults.ExecutionResult;
import org.mariadb.jdbc.internal.queryresults.MultiIntExecutionResult;
import org.mariadb.jdbc.internal.queryresults.SingleExecutionResult;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class MariaDbStatement
implements Statement,
Cloneable {
    private static volatile Timer timer;
    protected Protocol protocol;
    protected MariaDbConnection connection;
    protected boolean binaryData = false;
    protected TimerTask timerTask;
    protected boolean isRewriteable = true;
    protected String firstRewrite = null;
    boolean isClosed;
    boolean isTimedout;
    volatile boolean executing;
    Deque<Query> batchQueries;
    Deque<ExecutionResult> cachedExecutionResults;
    private boolean warningsCleared;
    private int queryTimeout;
    private boolean escapeProcessing;
    protected int fetchSize;
    private int maxRows;
    public static final Pattern deleteEndSemicolonPattern;
    protected ExecutionResult executionResult = null;
    protected int resultSetScrollType;

    public MariaDbStatement(MariaDbConnection connection, int resultSetScrollType) {
        this.protocol = connection.getProtocol();
        this.connection = connection;
        this.escapeProcessing = true;
        this.resultSetScrollType = resultSetScrollType;
        this.cachedExecutionResults = new ArrayDeque<ExecutionResult>();
        this.firstRewrite = null;
    }

    public MariaDbStatement clone() throws CloneNotSupportedException {
        MariaDbStatement clone = (MariaDbStatement)super.clone();
        clone.connection = this.connection;
        clone.protocol = this.protocol;
        clone.timerTask = null;
        clone.batchQueries = new ArrayDeque<Query>();
        clone.cachedExecutionResults = new ArrayDeque<ExecutionResult>();
        clone.executionResult = null;
        clone.isClosed = false;
        clone.warningsCleared = true;
        clone.fetchSize = 0;
        clone.maxRows = 0;
        clone.isRewriteable = true;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Timer getTimer() {
        Timer result = timer;
        if (result != null) return result;
        Class<MariaDbStatement> clazz = MariaDbStatement.class;
        synchronized (MariaDbStatement.class) {
            result = timer;
            if (result != null) return result;
            timer = result = new Timer("MariaDB-JDBC-Timer", true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    public static void unloadDriver() {
        if (timer != null) {
            timer.cancel();
        }
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    private void setTimerTask() {
        assert (this.timerTask == null);
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    MariaDbStatement.this.isTimedout = true;
                    MariaDbStatement.this.protocol.cancelCurrentQuery();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        MariaDbStatement.getTimer().schedule(this.timerTask, this.queryTimeout * 1000);
    }

    void executeQueryProlog() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("execute() is called on closed statement");
        }
        if (this.protocol.isExplicitClosed()) {
            throw new SQLException("execute() is called on closed connection");
        }
        if (this.protocol.getProxy() == null) {
            this.checkReconnectWithoutProxy();
        }
        this.protocol.closeIfActiveResult();
        if (this.protocol.hasMoreResults()) {
            try {
                this.protocol.skip();
            }
            catch (QueryException e) {
                ExceptionMapper.throwException(e, this.connection, this);
            }
        }
        this.warningsCleared = false;
        this.connection.reenableWarnings();
        this.cachedExecutionResults.clear();
        try {
            this.protocol.setMaxRows(this.maxRows);
        }
        catch (QueryException qe) {
            ExceptionMapper.throwException(qe, this.connection, this);
        }
        if (this.queryTimeout != 0) {
            this.setTimerTask();
        }
    }

    protected void cacheMoreResults(ExecutionResult execResult, int fetchSize, boolean canHaveCallableResult) {
        if (fetchSize != 0) {
            return;
        }
        if (execResult.hasMoreResultAvailable()) {
            try {
                while (this.protocol.hasMoreResults()) {
                    SingleExecutionResult executionResult = new SingleExecutionResult(this, 0, true, canHaveCallableResult);
                    this.protocol.getMoreResults(executionResult);
                    this.cachedExecutionResults.add(executionResult);
                }
            }
            catch (QueryException queryException) {
                // empty catch block
            }
        }
    }

    protected void executeQueryEpilog(QueryException queryException) throws SQLException {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        if (this.isTimedout) {
            this.isTimedout = false;
            queryException = new QueryException("Query timed out", 1317, "JZ0002", queryException);
        }
        if (queryException == null) {
            return;
        }
        if (queryException.getSqlState() != null && queryException.getSqlState().startsWith("08")) {
            this.close();
        }
        ExceptionMapper.throwException(queryException, this.connection, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean execute(Query query, int fetchSize) throws SQLException {
        this.checkClose();
        this.executing = true;
        QueryException exception = null;
        this.connection.lock.lock();
        try {
            boolean bl;
            this.executeQueryProlog();
            try {
                SingleExecutionResult internalExecutionResult = new SingleExecutionResult(this, fetchSize, true, false);
                this.protocol.executeQuery(query, internalExecutionResult, this.resultSetScrollType, fetchSize);
                this.cacheMoreResults(internalExecutionResult, fetchSize, false);
                this.executionResult = internalExecutionResult;
                bl = this.executionResult.getResult() != null;
            }
            catch (QueryException e) {
                boolean bl2;
                try {
                    exception = e;
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    this.executeQueryEpilog(exception);
                    this.executing = false;
                    throw throwable;
                }
                this.executeQueryEpilog(exception);
                this.executing = false;
                this.connection.lock.unlock();
                return bl2;
            }
            this.executeQueryEpilog(exception);
            this.executing = false;
            return bl;
        }
        finally {
            this.connection.lock.unlock();
        }
    }

    @Override
    public boolean execute(String queryString) throws SQLException {
        return this.execute(this.stringToQuery(queryString), this.fetchSize);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(this.stringToQuery(sql), this.fetchSize);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(this.stringToQuery(sql), this.fetchSize);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(this.stringToQuery(sql), this.fetchSize);
    }

    protected ResultSet executeQuery(Query query) throws SQLException {
        if (this.execute(query, this.fetchSize)) {
            return this.executionResult.getResult();
        }
        return MariaSelectResultSet.EMPTY;
    }

    @Override
    public ResultSet executeQuery(String queryString) throws SQLException {
        return this.executeQuery(this.stringToQuery(queryString));
    }

    protected int executeUpdate(Query query) throws SQLException {
        if (this.execute(query, this.fetchSize)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String queryString) throws SQLException {
        return this.executeUpdate(this.stringToQuery(queryString));
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(this.stringToQuery(sql));
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(this.stringToQuery(sql));
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(this.stringToQuery(sql));
    }

    protected Query stringToQuery(String queryString) throws SQLException {
        queryString = deleteEndSemicolonPattern.matcher(queryString).replaceAll("");
        if (this.escapeProcessing) {
            queryString = Utils.nativeSql(queryString, this.connection.noBackslashEscapes);
        }
        return new MariaDbQuery(queryString);
    }

    @Override
    public void close() throws SQLException {
        boolean hasMoreResult = false;
        if (this.executionResult != null) {
            hasMoreResult = this.executionResult.hasMoreResultAvailable();
            if (this.executionResult.getFetchSize() > 0) {
                this.executionResult.close();
            }
            this.executionResult = null;
        }
        this.cachedExecutionResults.clear();
        if (hasMoreResult) {
            this.connection.lock.lock();
            try {
                this.skipMoreResults();
            }
            finally {
                this.isClosed = true;
                this.connection.lock.unlock();
            }
        } else {
            this.isClosed = true;
        }
        if (this.connection == null || this.connection.pooledConnection == null || this.connection.pooledConnection.statementEventListeners.isEmpty()) {
            return;
        }
        this.connection.pooledConnection.fireStatementClosed(this);
    }

    protected ResultSet retrieveCallableResult() throws SQLException {
        if (this.executionResult != null && this.executionResult.getResult() != null && this.executionResult.getResult().isCallableResult()) {
            MariaSelectResultSet resultSet = this.executionResult.getResult();
            this.getMoreResults();
            return resultSet;
        }
        for (ExecutionResult batchExecutionResult : this.cachedExecutionResults) {
            if (batchExecutionResult.getResult() == null || batchExecutionResult.getResult() == null || !batchExecutionResult.getResult().isCallableResult()) continue;
            MariaSelectResultSet resultSet = batchExecutionResult.getResult();
            this.cachedExecutionResults.remove(batchExecutionResult);
            return resultSet;
        }
        return null;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("max rows cannot be negative : asked for " + max);
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.escapeProcessing = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    public void setLocalInfileInputStream(InputStream inputStream) throws SQLException {
        this.checkClose();
        this.protocol.setLocalInfileInputStream(inputStream);
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClose();
        try {
            if (!this.executing) {
                return;
            }
            this.protocol.cancelCurrentQuery();
        }
        catch (QueryException e) {
            ExceptionMapper.throwException(e, this.connection, this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClose();
        if (!this.warningsCleared) {
            return this.connection.getWarnings();
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningsCleared = true;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Cursors are not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.executionResult != null && this.executionResult.getResult() == null) {
            int autoIncrementIncrement = this.connection.getAutoIncrementIncrement();
            if (this.executionResult.hasMoreThanOneAffectedRows()) {
                long[] data;
                if (this.executionResult instanceof SingleExecutionResult) {
                    int updateCount = this.executionResult.getFirstAffectedRows();
                    data = new long[updateCount];
                    for (int i = 0; i < updateCount; ++i) {
                        data[i] = ((SingleExecutionResult)this.executionResult).getInsertId() + (long)(i * autoIncrementIncrement);
                    }
                } else {
                    MultiIntExecutionResult multiExecution = (MultiIntExecutionResult)this.executionResult;
                    int size = 0;
                    int affectedRowslength = multiExecution.getAffectedRows().length;
                    for (int i = 0; i < affectedRowslength; ++i) {
                        size += multiExecution.getAffectedRows()[i];
                    }
                    data = new long[size];
                    for (int affectedRows = 0; affectedRows < affectedRowslength; ++affectedRows) {
                        for (int i = 0; i < affectedRows; ++i) {
                            data[i] = multiExecution.getInsertIds()[affectedRows] + (long)(i * autoIncrementIncrement);
                        }
                    }
                }
                return MariaSelectResultSet.createGeneratedData(data, this.connection.getProtocol(), true);
            }
            return MariaSelectResultSet.createGeneratedData(this.executionResult.getInsertIds(), this.connection.getProtocol(), true);
        }
        return MariaSelectResultSet.EMPTY;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClose();
        if (this.executionResult != null) {
            return this.executionResult.getResult();
        }
        return null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.executionResult == null || this.executionResult.getResult() != null) {
            return -1;
        }
        if (this.executionResult instanceof SingleExecutionResult) {
            return (int)((SingleExecutionResult)this.executionResult).getAffectedRows();
        }
        return ((MultiIntExecutionResult)this.executionResult).getAffectedRows()[0];
    }

    protected void skipMoreResults() throws SQLException {
        try {
            this.protocol.skip();
            this.warningsCleared = false;
            this.connection.reenableWarnings();
        }
        catch (QueryException e) {
            ExceptionMapper.throwException(e, this.connection, this);
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (this.executionResult != null) {
            if (this.executionResult.getFetchSize() == 0) {
                this.executionResult = this.cachedExecutionResults.poll();
                return this.executionResult != null && this.executionResult.getResult() != null;
            }
            this.checkClose();
            this.protocol.getLock().lock();
            try {
                this.executionResult.close();
                SingleExecutionResult internalExecutionResult = new SingleExecutionResult(this, this.fetchSize, true, false);
                if (internalExecutionResult.hasMoreResultAvailable()) {
                    this.protocol.getMoreResults(internalExecutionResult);
                    this.executionResult = internalExecutionResult;
                    boolean bl = this.executionResult.getResult() != null;
                    return bl;
                }
                this.executionResult = null;
                boolean bl = false;
                return bl;
            }
            catch (QueryException queryException) {
                ExceptionMapper.throwException(queryException, this.connection, this);
                boolean bl = false;
                return bl;
            }
            finally {
                this.protocol.getLock().unlock();
            }
        }
        return false;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0 && rows != Integer.MIN_VALUE) {
            throw new SQLException("invalid fetch size");
        }
        if (rows == Integer.MIN_VALUE) {
            this.fetchSize = 1;
            return;
        }
        this.fetchSize = rows;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1004;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        String sqlQuery;
        if (this.batchQueries == null) {
            this.batchQueries = new ArrayDeque<Query>();
        }
        if (this.protocol.getOptions().rewriteBatchedStatements || this.protocol.getOptions().allowMultiQueries) {
            sqlQuery = deleteEndSemicolonPattern.matcher(sql).replaceAll("");
            this.isInsertRewriteable(sqlQuery);
        } else {
            sqlQuery = sql;
        }
        this.batchQueries.add(new MariaDbQuery(sqlQuery));
    }

    protected void isInsertRewriteable(String sql) {
        if (!this.isRewriteable) {
            return;
        }
        int index = this.getInsertIncipit(sql);
        if (index == -1) {
            this.isRewriteable = false;
            return;
        }
        if (this.firstRewrite == null) {
            this.firstRewrite = sql.substring(0, index);
        }
    }

    protected int getInsertIncipit(String sql) {
        String sqlUpper = sql.toUpperCase();
        if (!sqlUpper.startsWith("INSERT") && !sqlUpper.startsWith("/*CLIENT*/ INSERT")) {
            return -1;
        }
        if (sqlUpper.indexOf("SELECT") != -1) {
            return -1;
        }
        int idx = sqlUpper.indexOf(" VALUE");
        if (idx == -1) {
            idx = sqlUpper.indexOf(")VALUE");
        }
        int startBracket = sqlUpper.indexOf("(", idx);
        int endBracket = sqlUpper.indexOf(")", startBracket);
        int semicolonPos = sqlUpper.indexOf(59);
        while (semicolonPos > -1) {
            if (semicolonPos < startBracket || semicolonPos > endBracket) {
                return -1;
            }
            semicolonPos = sqlUpper.indexOf(59, semicolonPos + 1);
        }
        return startBracket;
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.batchQueries != null) {
            this.batchQueries.clear();
        }
        this.firstRewrite = null;
        this.isRewriteable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClose();
        if (this.batchQueries == null || this.batchQueries.size() == 0) {
            return new int[0];
        }
        this.cachedExecutionResults.clear();
        MultiIntExecutionResult internalExecutionResult = new MultiIntExecutionResult((Statement)this, this.batchQueries.size(), 0, false);
        this.connection.lock.lock();
        try {
            QueryException exception = null;
            this.connection.lock.lock();
            try {
                this.executing = true;
                this.executeQueryProlog();
                try {
                    if (this.getProtocol().getOptions().allowMultiQueries || this.getProtocol().getOptions().rewriteBatchedStatements) {
                        boolean rewrittenBatch = this.isRewriteable && this.getProtocol().getOptions().rewriteBatchedStatements;
                        this.protocol.executeMultiQueries(this.batchQueries, internalExecutionResult, 0, rewrittenBatch, rewrittenBatch && this.firstRewrite != null ? this.firstRewrite.length() : 0);
                        this.cacheMoreResults(internalExecutionResult, 0, false);
                        if (rewrittenBatch) {
                            internalExecutionResult.updateResultsForRewrite();
                        } else {
                            internalExecutionResult.updateResultsMultiple(this.cachedExecutionResults);
                        }
                    } else {
                        this.protocol.executeQueries(this.batchQueries, internalExecutionResult, this.resultSetScrollType);
                        this.cacheMoreResults(internalExecutionResult, 0, false);
                    }
                }
                catch (QueryException e) {
                    exception = e;
                }
                finally {
                    this.executionResult = internalExecutionResult;
                    this.executing = false;
                    this.executeQueryEpilog(exception);
                }
            }
            finally {
                this.connection.lock.unlock();
            }
            int[] nArray = internalExecutionResult.getAffectedRows();
            return nArray;
        }
        catch (SQLException sqle) {
            throw new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), internalExecutionResult.getAffectedRows(), (Throwable)sqle);
        }
        finally {
            this.connection.lock.unlock();
            this.clearBatch();
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return (T)this;
            }
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
        catch (Exception e) {
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaceOrWrapper) throws SQLException {
        return interfaceOrWrapper.isInstance(this);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    private void checkReconnectWithoutProxy() throws SQLException {
        if (this.protocol.shouldReconnectWithoutProxy()) {
            try {
                this.protocol.connectWithoutProxy();
            }
            catch (QueryException qe) {
                ExceptionMapper.throwException(qe, this.connection, this);
            }
        }
    }

    protected void checkClose() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Cannot do an operation on a closed statement");
        }
    }

    static {
        deleteEndSemicolonPattern = Pattern.compile("[;][ ]*$", 2);
    }
}

