/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.JDBCUrl;
import org.mariadb.jdbc.MySQLConnection;
import org.mariadb.jdbc.internal.SQLExceptionMapper;
import org.mariadb.jdbc.internal.common.CharsetUtils;
import org.mariadb.jdbc.internal.common.MySQLCharset;
import org.mariadb.jdbc.internal.common.Options;
import org.mariadb.jdbc.internal.common.PacketFetcher;
import org.mariadb.jdbc.internal.common.PrepareStatementCache;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.common.UrlHAMode;
import org.mariadb.jdbc.internal.common.Utils;
import org.mariadb.jdbc.internal.common.packet.DecompressInputStream;
import org.mariadb.jdbc.internal.common.packet.EOFPacket;
import org.mariadb.jdbc.internal.common.packet.ErrorPacket;
import org.mariadb.jdbc.internal.common.packet.LocalInfilePacket;
import org.mariadb.jdbc.internal.common.packet.MaxAllowedPacketException;
import org.mariadb.jdbc.internal.common.packet.OKPacket;
import org.mariadb.jdbc.internal.common.packet.PacketOutputStream;
import org.mariadb.jdbc.internal.common.packet.RawPacket;
import org.mariadb.jdbc.internal.common.packet.ResultPacket;
import org.mariadb.jdbc.internal.common.packet.ResultPacketFactory;
import org.mariadb.jdbc.internal.common.packet.ResultSetPacket;
import org.mariadb.jdbc.internal.common.packet.SyncPacketFetcher;
import org.mariadb.jdbc.internal.common.packet.buffer.ReadUtil;
import org.mariadb.jdbc.internal.common.packet.buffer.Reader;
import org.mariadb.jdbc.internal.common.packet.commands.ClosePacket;
import org.mariadb.jdbc.internal.common.packet.commands.SelectDBPacket;
import org.mariadb.jdbc.internal.common.packet.commands.StreamedQueryPacket;
import org.mariadb.jdbc.internal.common.query.MySQLQuery;
import org.mariadb.jdbc.internal.common.query.Query;
import org.mariadb.jdbc.internal.common.query.parameters.LongDataParameterHolder;
import org.mariadb.jdbc.internal.common.query.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.common.queryresults.CachedSelectResult;
import org.mariadb.jdbc.internal.common.queryresults.PrepareResult;
import org.mariadb.jdbc.internal.common.queryresults.QueryResult;
import org.mariadb.jdbc.internal.common.queryresults.SelectQueryResult;
import org.mariadb.jdbc.internal.common.queryresults.StreamingSelectResult;
import org.mariadb.jdbc.internal.common.queryresults.UpdateResult;
import org.mariadb.jdbc.internal.mysql.FailoverProxy;
import org.mariadb.jdbc.internal.mysql.MySQLColumnInformation;
import org.mariadb.jdbc.internal.mysql.MySQLType;
import org.mariadb.jdbc.internal.mysql.MyX509TrustManager;
import org.mariadb.jdbc.internal.mysql.NamedPipeSocket;
import org.mariadb.jdbc.internal.mysql.Protocol;
import org.mariadb.jdbc.internal.mysql.SharedMemorySocket;
import org.mariadb.jdbc.internal.mysql.UnixDomainSocket;
import org.mariadb.jdbc.internal.mysql.listener.Listener;
import org.mariadb.jdbc.internal.mysql.listener.tools.SearchFilter;
import org.mariadb.jdbc.internal.mysql.packet.MySQLGreetingReadPacket;
import org.mariadb.jdbc.internal.mysql.packet.commands.AbbreviatedMySQLClientAuthPacket;
import org.mariadb.jdbc.internal.mysql.packet.commands.MySQLClientAuthPacket;
import org.mariadb.jdbc.internal.mysql.packet.commands.MySQLClientOldPasswordAuthPacket;
import org.mariadb.jdbc.internal.mysql.packet.commands.MySQLPingPacket;
import org.mariadb.jdbc.internal.mysql.packet.commands.SendClosePrepareStatementPacket;
import org.mariadb.jdbc.internal.mysql.packet.commands.SendExecutePrepareStatementPacket;
import org.mariadb.jdbc.internal.mysql.packet.commands.SendPrepareParameterPacket;
import org.mariadb.jdbc.internal.mysql.packet.commands.SendPrepareStatementPacket;

public class MySQLProtocol
implements Protocol {
    protected final ReentrantReadWriteLock lock;
    protected final JDBCUrl jdbcUrl;
    private final String username;
    private final String password;
    public boolean moreResults = false;
    public boolean hasWarnings = false;
    public StreamingSelectResult activeResult = null;
    public int datatypeMappingFlags;
    public short serverStatus;
    protected Socket socket;
    protected PacketOutputStream writer;
    protected boolean readOnly = false;
    protected SyncPacketFetcher packetFetcher;
    protected HostAddress currentHost;
    protected FailoverProxy proxy;
    boolean hostFailed;
    private boolean connected = false;
    private boolean explicitClosed = false;
    private String version;
    private String database;
    private int maxRows;
    private long serverThreadId;
    private int majorVersion;
    private int minorVersion;
    private int patchVersion;
    private byte serverLanguage;
    private MySQLCharset mySQLServerCharset;
    private int transactionIsolationLevel = 0;
    private PrepareStatementCache prepareStatementCache;
    private Map<String, String> serverData;
    private InputStream localInfileInputStream;
    private Calendar cal;

    public MySQLProtocol(JDBCUrl jdbcUrl, ReentrantReadWriteLock lock) {
        this.lock = lock;
        lock.writeLock().lock();
        this.jdbcUrl = jdbcUrl;
        this.database = jdbcUrl.getDatabase() == null ? "" : jdbcUrl.getDatabase();
        this.username = jdbcUrl.getUsername() == null ? "" : jdbcUrl.getUsername();
        String string = this.password = jdbcUrl.getPassword() == null ? "" : jdbcUrl.getPassword();
        if (jdbcUrl.getOptions().cachePrepStmts) {
            this.prepareStatementCache = PrepareStatementCache.newInstance(jdbcUrl.getOptions().prepStmtCacheSize);
        }
        lock.writeLock().unlock();
        this.setDatatypeMappingFlags();
    }

    public static MySQLProtocol getNewProtocol(FailoverProxy proxy, JDBCUrl jdbcUrl) {
        MySQLProtocol newProtocol = new MySQLProtocol(jdbcUrl, proxy.lock);
        newProtocol.setProxy(proxy);
        return newProtocol;
    }

    public static void loop(Listener listener, List<HostAddress> addresses, Map<HostAddress, Long> blacklist, SearchFilter searchFilter) throws QueryException {
        LinkedList<HostAddress> loopAddresses = new LinkedList<HostAddress>(addresses);
        QueryException lastQueryException = null;
        for (int maxConnectionTry = listener.getRetriesAllDown(); !loopAddresses.isEmpty() || !searchFilter.isUniqueLoop() && maxConnectionTry > 0; --maxConnectionTry) {
            MySQLProtocol protocol = MySQLProtocol.getNewProtocol(listener.getProxy(), listener.getJdbcUrl());
            if (listener.isExplicitClosed()) {
                return;
            }
            try {
                protocol.setHostAddress((HostAddress)loopAddresses.get(0));
                loopAddresses.remove(0);
                protocol.connect();
                blacklist.remove(protocol.getHostAddress());
                listener.foundActiveMaster(protocol);
                return;
            }
            catch (QueryException e) {
                blacklist.put(protocol.getHostAddress(), System.currentTimeMillis());
                lastQueryException = e;
                if (!loopAddresses.isEmpty() || searchFilter.isUniqueLoop() || maxConnectionTry <= 0) continue;
                loopAddresses = new LinkedList<HostAddress>(addresses);
                continue;
            }
        }
        if (lastQueryException != null) {
            throw new QueryException("No active connection found for master", lastQueryException.getErrorCode(), lastQueryException.getSqlState(), lastQueryException);
        }
        throw new QueryException("No active connection found for master");
    }

    protected static void close(PacketFetcher fetcher, PacketOutputStream packetOutputStream, Socket socket) throws QueryException {
        ClosePacket closePacket = new ClosePacket();
        try {
            try {
                closePacket.send(packetOutputStream);
                socket.shutdownOutput();
                socket.setSoTimeout(3);
                InputStream is = socket.getInputStream();
                while (is.read() != -1) {
                }
            }
            catch (Throwable is) {
                // empty catch block
            }
            packetOutputStream.close();
            fetcher.close();
        }
        catch (IOException e) {
            throw new QueryException("Could not close connection: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String hexdump(byte[] buffer, int offset) {
        StringBuffer dump = new StringBuffer();
        if (buffer.length - offset > 0) {
            dump.append(String.format("%02x", buffer[offset]));
            for (int i = offset + 1; i < buffer.length; ++i) {
                dump.append(String.format("%02x", buffer[i]));
            }
        }
        return dump.toString();
    }

    public static String hexdump(ByteBuffer bb, int offset) {
        byte[] b = new byte[bb.remaining()];
        bb.mark();
        bb.get(b);
        bb.reset();
        return MySQLProtocol.hexdump(b, offset);
    }

    private SSLSocketFactory getSSLSocketFactory() throws QueryException {
        if (!this.jdbcUrl.getOptions().trustServerCertificate && this.jdbcUrl.getOptions().serverSslCert == null) {
            return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManager[] m = new X509TrustManager[]{new MyX509TrustManager(this.jdbcUrl.getOptions())};
            sslContext.init(null, m, null);
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new QueryException(e.getMessage(), 0, "HY000", e);
        }
    }

    private void connect(String host, int port) throws QueryException, IOException {
        SocketFactory socketFactory;
        String socketFactoryName = this.jdbcUrl.getOptions().socketFactory;
        if (socketFactoryName != null) {
            try {
                socketFactory = (SocketFactory)Class.forName(socketFactoryName).newInstance();
            }
            catch (Exception sfex) {
                socketFactory = SocketFactory.getDefault();
            }
        } else {
            socketFactory = SocketFactory.getDefault();
        }
        if (this.jdbcUrl.getOptions().pipe != null) {
            this.socket = new NamedPipeSocket(host, this.jdbcUrl.getOptions().pipe);
        } else if (this.jdbcUrl.getOptions().localSocket != null) {
            try {
                this.socket = new UnixDomainSocket(this.jdbcUrl.getOptions().localSocket);
            }
            catch (RuntimeException re) {
                throw new IOException(re.getMessage(), re.getCause());
            }
        } else if (this.jdbcUrl.getOptions().sharedMemory != null) {
            try {
                this.socket = new SharedMemorySocket(this.jdbcUrl.getOptions().sharedMemory);
            }
            catch (RuntimeException re) {
                throw new IOException(re.getMessage(), re.getCause());
            }
        } else {
            this.socket = socketFactory.createSocket();
        }
        try {
            if (this.jdbcUrl.getOptions().tcpNoDelay) {
                this.socket.setTcpNoDelay(true);
            }
            if (this.jdbcUrl.getOptions().tcpKeepAlive) {
                this.socket.setKeepAlive(true);
            }
            if (this.jdbcUrl.getOptions().tcpRcvBuf != null) {
                this.socket.setReceiveBufferSize(this.jdbcUrl.getOptions().tcpRcvBuf);
            }
            if (this.jdbcUrl.getOptions().tcpSndBuf != null) {
                this.socket.setSendBufferSize(this.jdbcUrl.getOptions().tcpSndBuf);
            }
            if (this.jdbcUrl.getOptions().tcpAbortiveClose) {
                this.socket.setSoLinger(true, 0);
            }
        }
        catch (Exception re) {
            // empty catch block
        }
        if (this.jdbcUrl.getOptions().localSocketAddress != null) {
            InetSocketAddress localAddress = new InetSocketAddress(this.jdbcUrl.getOptions().localSocketAddress, 0);
            this.socket.bind(localAddress);
        }
        if (!this.socket.isConnected()) {
            InetSocketAddress sockAddr = new InetSocketAddress(host, port);
            if (this.jdbcUrl.getOptions().connectTimeout != null) {
                this.socket.connect(sockAddr, this.jdbcUrl.getOptions().connectTimeout);
            } else {
                this.socket.connect(sockAddr);
            }
        }
        if (this.jdbcUrl.getOptions().socketTimeout != null) {
            this.socket.setSoTimeout(this.jdbcUrl.getOptions().socketTimeout);
        }
        try {
            BufferedInputStream reader = new BufferedInputStream(this.socket.getInputStream(), 32768);
            this.packetFetcher = new SyncPacketFetcher(reader);
            this.writer = new PacketOutputStream(this.socket.getOutputStream());
            RawPacket packet = this.packetFetcher.getRawPacket();
            if (ReadUtil.isErrorPacket(packet)) {
                ((InputStream)reader).close();
                ErrorPacket errorPacket = (ErrorPacket)ResultPacketFactory.createResultPacket(packet);
                throw new QueryException(errorPacket.getMessage());
            }
            MySQLGreetingReadPacket greetingPacket = new MySQLGreetingReadPacket(packet);
            this.serverThreadId = greetingPacket.getServerThreadID();
            this.serverLanguage = greetingPacket.getServerLanguage();
            this.mySQLServerCharset = CharsetUtils.getServerCharset(this.serverLanguage);
            this.version = greetingPacket.getServerVersion();
            this.parseVersion();
            byte packetSeq = 1;
            int capabilities = 172931;
            if (this.jdbcUrl.getOptions().allowMultiQueries || this.jdbcUrl.getOptions().rewriteBatchedStatements) {
                capabilities |= 0x10000;
            }
            if (this.jdbcUrl.getOptions().useCompression) {
                capabilities |= 0x20;
            }
            if (this.jdbcUrl.getOptions().interactiveClient) {
                capabilities |= 0x400;
            }
            if (this.database != null && !this.jdbcUrl.getOptions().createDatabaseIfNotExist) {
                capabilities |= 8;
            }
            if (this.jdbcUrl.getOptions().useSSL && (greetingPacket.getServerCapabilities() & 0x800) != 0) {
                AbbreviatedMySQLClientAuthPacket amcap = new AbbreviatedMySQLClientAuthPacket(capabilities |= 0x800);
                amcap.send(this.writer);
                SSLSocketFactory f = this.getSSLSocketFactory();
                SSLSocket sslSocket = (SSLSocket)f.createSocket(this.socket, this.socket.getInetAddress().getHostAddress(), this.socket.getPort(), true);
                sslSocket.setEnabledProtocols(new String[]{"TLSv1"});
                sslSocket.setUseClientMode(true);
                sslSocket.startHandshake();
                this.socket = sslSocket;
                this.writer = new PacketOutputStream(this.socket.getOutputStream());
                reader = new BufferedInputStream(this.socket.getInputStream(), 32768);
                this.packetFetcher = new SyncPacketFetcher(reader);
                packetSeq = (byte)(packetSeq + 1);
            } else if (this.jdbcUrl.getOptions().useSSL) {
                throw new QueryException("Trying to connect with ssl, but ssl not enabled in the server");
            }
            MySQLClientAuthPacket cap = new MySQLClientAuthPacket(this.username, this.password, this.database, capabilities, this.decideLanguage(), greetingPacket.getSeed(), packetSeq);
            cap.send(this.writer);
            RawPacket rp = this.packetFetcher.getRawPacket();
            if ((rp.getByteBuffer().get(0) & 0xFF) == 254) {
                MySQLClientOldPasswordAuthPacket oldPassPacket = new MySQLClientOldPasswordAuthPacket(this.password, Utils.copyWithLength(greetingPacket.getSeed(), 8), rp.getPacketSeq() + 1);
                oldPassPacket.send(this.writer);
                rp = this.packetFetcher.getRawPacket();
            }
            this.checkErrorPacket(rp);
            ResultPacket resultPacket = ResultPacketFactory.createResultPacket(rp);
            OKPacket ok = (OKPacket)resultPacket;
            this.serverStatus = ok.getServerStatus();
            if (this.jdbcUrl.getOptions().useCompression) {
                this.writer.setUseCompression(true);
                this.packetFetcher = new SyncPacketFetcher(new DecompressInputStream(this.socket.getInputStream()));
            }
            if ((this.serverStatus & 2) == 0) {
                this.executeQuery(new MySQLQuery("set autocommit=1"));
            }
            if (this.jdbcUrl.getOptions().sessionVariables != null) {
                this.executeQuery(new MySQLQuery("set session " + this.jdbcUrl.getOptions().sessionVariables));
            }
            this.loadServerData();
            this.writer.setMaxAllowedPacket(Integer.parseInt(this.serverData.get("max_allowed_packet")));
            if (this.checkIfMaster() && this.jdbcUrl.getOptions().createDatabaseIfNotExist) {
                String quotedDB = MySQLConnection.quoteIdentifier(this.database);
                this.executeQuery(new MySQLQuery("CREATE DATABASE IF NOT EXISTS " + quotedDB));
                this.executeQuery(new MySQLQuery("USE " + quotedDB));
            }
            this.activeResult = null;
            this.moreResults = false;
            this.hasWarnings = false;
            this.connected = true;
            this.hostFailed = false;
            this.loadCalendar();
        }
        catch (IOException e) {
            throw new QueryException("Could not connect to " + host + ":" + port + ": " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    private void loadCalendar() throws QueryException {
        block5: {
            String timeZone = null;
            if (this.getOptions().serverTimezone != null) {
                timeZone = this.getOptions().serverTimezone;
            }
            if (timeZone == null && (timeZone = this.getServerData("time_zone")) != null && "SYSTEM".equals(timeZone)) {
                timeZone = this.getServerData("system_time_zone");
            }
            if (timeZone != null && timeZone.length() >= 2 && (timeZone.startsWith("+") || timeZone.startsWith("-")) && Character.isDigit(timeZone.charAt(1))) {
                timeZone = "GMT" + timeZone;
            }
            try {
                TimeZone tz = Utils.getTimeZone(timeZone);
                this.cal = Calendar.getInstance(tz);
            }
            catch (SQLException e) {
                this.cal = null;
                if (this.getOptions().useLegacyDatetimeCode) break block5;
                throw new QueryException("The server time_zone '" + timeZone + "' cannot be parsed. The server time zone must defined in the jdbc url string with the 'serverTimezone' parameter (or server time zone must be defined explicitly)", 0, "01S00");
            }
        }
    }

    private void loadServerData() throws QueryException, IOException {
        this.serverData = new TreeMap<String, String>();
        try (QueryResult qr = null;){
            qr = (SelectQueryResult)this.executeQuery(new MySQLQuery("SELECT @@character_set_client, @@character_set_server, @@max_allowed_packet, @@system_time_zone, @@time_zone"));
            if (((SelectQueryResult)qr).next()) {
                this.serverData.put("character_set_client", ((SelectQueryResult)qr).getValueObject(0).getString());
                this.serverData.put("character_set_server", ((SelectQueryResult)qr).getValueObject(1).getString());
                this.serverData.put("max_allowed_packet", ((SelectQueryResult)qr).getValueObject(2).getString());
                this.serverData.put("system_time_zone", ((SelectQueryResult)qr).getValueObject(3).getString());
                this.serverData.put("time_zone", ((SelectQueryResult)qr).getValueObject(4).getString());
            }
        }
    }

    @Override
    public String getServerData(String code) {
        return this.serverData.get(code);
    }

    @Override
    public boolean checkIfMaster() throws QueryException {
        return this.isMasterConnection();
    }

    private boolean isServerLanguageUTF8MB4(byte serverLanguage) {
        Byte[] utf8mb4Languages = new Byte[]{(byte)45, (byte)46, (byte)-32, (byte)-31, (byte)-30, (byte)-29, (byte)-28, (byte)-27, (byte)-26, (byte)-25, (byte)-24, (byte)-23, (byte)-22, (byte)-21, (byte)-20, (byte)-19, (byte)-18, (byte)-17, (byte)-16, (byte)-15, (byte)-14, (byte)-13, (byte)-11};
        return Arrays.asList(utf8mb4Languages).contains(serverLanguage);
    }

    private byte decideLanguage() {
        byte result = this.isServerLanguageUTF8MB4(this.serverLanguage) ? (byte)this.serverLanguage : (byte)33;
        return result;
    }

    void checkErrorPacket(RawPacket rp) throws QueryException {
        if (rp.getByteBuffer().get(0) == -1) {
            ErrorPacket ep = new ErrorPacket(rp);
            String message = ep.getMessage();
            throw new QueryException("Could not connect: " + message, ep.getErrorNumber(), ep.getSqlState());
        }
    }

    void readEOFPacket() throws QueryException, IOException {
        RawPacket rp = this.packetFetcher.getRawPacket();
        this.checkErrorPacket(rp);
        ResultPacket resultPacket = ResultPacketFactory.createResultPacket(rp);
        if (resultPacket.getResultType() != ResultPacket.ResultType.EOF) {
            throw new QueryException("Unexpected packet type " + (Object)((Object)resultPacket.getResultType()) + "insted of EOF");
        }
        EOFPacket eof = (EOFPacket)resultPacket;
        this.hasWarnings = eof.getWarningCount() > 0;
        this.serverStatus = eof.getStatusFlags();
    }

    @Override
    public PrepareResult prepare(String sql) throws QueryException {
        try {
            if (this.jdbcUrl.getOptions().cachePrepStmts && this.prepareStatementCache.containsKey(sql)) {
                PrepareResult pr = (PrepareResult)this.prepareStatementCache.get(sql);
                pr.addUse();
                return pr;
            }
            SendPrepareStatementPacket sendPrepareStatementPacket = new SendPrepareStatementPacket(sql);
            sendPrepareStatementPacket.send(this.writer);
            RawPacket rp = this.packetFetcher.getRawPacket();
            this.checkErrorPacket(rp);
            byte b = rp.getByteBuffer().get(0);
            if (b == 0) {
                Reader r = new Reader(rp);
                r.readByte();
                int statementId = r.readInt();
                int numColumns = r.readShort();
                int numParams = r.readShort();
                r.readByte();
                this.hasWarnings = r.readShort() > 0;
                MySQLColumnInformation[] params = new MySQLColumnInformation[numParams];
                if (numParams > 0) {
                    for (int i = 0; i < numParams; ++i) {
                        params[i] = new MySQLColumnInformation(this.packetFetcher.getRawPacket());
                    }
                    this.readEOFPacket();
                }
                MySQLColumnInformation[] columns = new MySQLColumnInformation[numColumns];
                if (numColumns > 0) {
                    for (int i = 0; i < numColumns; ++i) {
                        columns[i] = new MySQLColumnInformation(this.packetFetcher.getRawPacket());
                    }
                    this.readEOFPacket();
                }
                PrepareResult prepareResult = new PrepareResult(statementId, columns, params);
                if (this.jdbcUrl.getOptions().cachePrepStmts && sql != null && sql.length() < this.jdbcUrl.getOptions().prepStmtCacheSqlLimit) {
                    this.prepareStatementCache.putIfNone(sql, prepareResult);
                }
                return prepareResult;
            }
            throw new QueryException("Unexpected packet returned by server, first byte " + b);
        }
        catch (IOException e) {
            throw new QueryException(e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    @Override
    public void closePreparedStatement(int statementId) throws QueryException {
        this.lock.writeLock().lock();
        try {
            this.writer.startPacket(0);
            this.writer.write(25);
            this.writer.write(statementId);
            this.writer.finishPacket();
        }
        catch (IOException e) {
            throw new QueryException(e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void setHostFailedWithoutProxy() {
        this.hostFailed = true;
        this.close();
    }

    @Override
    public JDBCUrl getJdbcUrl() {
        return this.jdbcUrl;
    }

    @Override
    public boolean getAutocommit() {
        this.lock.readLock().lock();
        try {
            boolean bl = (this.serverStatus & 2) != 0;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isMasterConnection() {
        return "master".equals(this.currentHost.type);
    }

    @Override
    public boolean mustBeMasterConnection() {
        return true;
    }

    @Override
    public boolean noBackslashEscapes() {
        this.lock.readLock().lock();
        try {
            boolean bl = (this.serverStatus & 0x200) != 0;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void connect() throws QueryException {
        if (!this.isClosed()) {
            this.close();
        }
        try {
            this.connect(this.currentHost.host, this.currentHost.port);
            return;
        }
        catch (IOException e) {
            throw new QueryException("Could not connect to " + this.currentHost + "." + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    @Override
    public void connectWithoutProxy() throws QueryException {
        if (!this.isClosed()) {
            this.close();
        }
        Random rand = new Random();
        List<HostAddress> addrs = this.jdbcUrl.getHostAddresses();
        LinkedList<HostAddress> hosts = new LinkedList<HostAddress>(addrs);
        while (!hosts.isEmpty()) {
            this.currentHost = this.jdbcUrl.getHaMode().equals((Object)UrlHAMode.LOADBALANCE) ? (HostAddress)hosts.get(rand.nextInt(hosts.size())) : (HostAddress)hosts.get(0);
            hosts.remove(this.currentHost);
            try {
                this.connect(this.currentHost.host, this.currentHost.port);
                return;
            }
            catch (IOException e) {
                if (!hosts.isEmpty()) continue;
                throw new QueryException("Could not connect to " + HostAddress.toString(addrs) + " : " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
            }
        }
    }

    @Override
    public boolean shouldReconnectWithoutProxy() {
        return !this.inTransaction() && this.hostFailed && this.jdbcUrl.getOptions().autoReconnect;
    }

    @Override
    public boolean inTransaction() {
        this.lock.readLock().lock();
        try {
            boolean bl = (this.serverStatus & 1) != 0;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void setDatatypeMappingFlags() {
        this.datatypeMappingFlags = 0;
        if (this.jdbcUrl.getOptions().tinyInt1isBit) {
            this.datatypeMappingFlags |= 1;
        }
        if (this.jdbcUrl.getOptions().yearIsDateType) {
            this.datatypeMappingFlags |= 2;
        }
    }

    @Override
    public Options getOptions() {
        return this.jdbcUrl.getOptions();
    }

    void skip() throws IOException, QueryException {
        if (this.activeResult != null) {
            this.activeResult.close();
        }
        while (this.moreResults) {
            this.getMoreResults(true);
        }
    }

    @Override
    public boolean hasMoreResults() {
        return this.moreResults;
    }

    @Override
    public void closeExplicit() {
        this.explicitClosed = true;
        this.close();
    }

    @Override
    public void close() {
        if (this.lock != null) {
            this.lock.writeLock().lock();
        }
        try {
            this.skip();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.jdbcUrl.getOptions().cachePrepStmts) {
                this.prepareStatementCache.clear();
            }
            MySQLProtocol.close(this.packetFetcher, this.writer, this.socket);
        }
        catch (Exception exception) {
        }
        finally {
            this.connected = false;
            if (this.lock != null) {
                this.lock.writeLock().unlock();
            }
        }
    }

    @Override
    public void rollback() {
        this.lock.writeLock().lock();
        try {
            if (this.inTransaction()) {
                this.executeQuery(new MySQLQuery("ROLLBACK"));
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean isClosed() {
        return !this.connected;
    }

    private SelectQueryResult createQueryResult(ResultSetPacket packet, boolean streaming, boolean binaryProtocol) throws IOException, QueryException {
        StreamingSelectResult streamingResult = StreamingSelectResult.createStreamingSelectResult(packet, this.packetFetcher, this, binaryProtocol);
        if (streaming) {
            return streamingResult;
        }
        return CachedSelectResult.createCachedSelectResult(streamingResult);
    }

    @Override
    public void setCatalog(String database) throws QueryException {
        this.lock.writeLock().lock();
        SelectDBPacket packet = new SelectDBPacket(database);
        try {
            packet.send(this.writer);
            RawPacket rawPacket = this.packetFetcher.getRawPacket();
            ResultPacket rs = ResultPacketFactory.createResultPacket(rawPacket);
            if (rs.getResultType() == ResultPacket.ResultType.ERROR) {
                throw new QueryException("Could not select database '" + database + "' : " + ((ErrorPacket)rs).getMessage());
            }
            this.database = database;
        }
        catch (IOException e) {
            throw new QueryException("Could not select database '" + database + "' :" + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public String getServerVersion() {
        return this.version;
    }

    @Override
    public boolean getReadonly() {
        return this.readOnly;
    }

    @Override
    public void setReadonly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public HostAddress getHostAddress() {
        return this.currentHost;
    }

    @Override
    public void setHostAddress(HostAddress host) {
        this.currentHost = host;
        this.readOnly = "slave".equals(this.currentHost.type);
    }

    @Override
    public String getHost() {
        return this.currentHost.host;
    }

    @Override
    public FailoverProxy getProxy() {
        return this.proxy;
    }

    @Override
    public void setProxy(FailoverProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public int getPort() {
        return this.currentHost.port;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public boolean ping() throws QueryException {
        this.lock.writeLock().lock();
        try {
            MySQLPingPacket pingPacket = new MySQLPingPacket();
            try {
                pingPacket.send(this.writer);
                RawPacket rawPacket = this.packetFetcher.getRawPacket();
                boolean bl = ResultPacketFactory.createResultPacket(rawPacket).getResultType() == ResultPacket.ResultType.OK;
                return bl;
            }
            catch (IOException e) {
                throw new QueryException("Could not ping: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public QueryResult executeQuery(Query dQuery) throws QueryException {
        return this.executeQuery(dQuery, false);
    }

    @Override
    public QueryResult getResult(Object dQueries, boolean streaming, boolean binaryProtocol) throws QueryException {
        ResultPacket resultPacket;
        RawPacket rawPacket = null;
        try {
            rawPacket = this.packetFetcher.getRawPacket();
            resultPacket = ResultPacketFactory.createResultPacket(rawPacket);
            if (resultPacket.getResultType() == ResultPacket.ResultType.LOCALINFILE) {
                InputStream is;
                if (this.localInfileInputStream == null) {
                    if (!this.getJdbcUrl().getOptions().allowLocalInfile) {
                        this.writer.writeEmptyPacket(rawPacket.getPacketSeq() + 1);
                        throw new QueryException("Usage of LOCAL INFILE is disabled. To use it enable it via the connection property allowLocalInfile=true", -1, SQLExceptionMapper.SQLStates.FEATURE_NOT_SUPPORTED.getSqlState());
                    }
                    LocalInfilePacket localInfilePacket = (LocalInfilePacket)resultPacket;
                    String localInfile = localInfilePacket.getFileName();
                    try {
                        URL u = new URL(localInfile);
                        is = u.openStream();
                    }
                    catch (IOException ioe) {
                        try {
                            is = new FileInputStream(localInfile);
                        }
                        catch (FileNotFoundException f) {
                            this.writer.writeEmptyPacket(rawPacket.getPacketSeq() + 1);
                            rawPacket = this.packetFetcher.getRawPacket();
                            ResultPacketFactory.createResultPacket(rawPacket);
                            throw new QueryException("Could not send file : " + f.getMessage(), -1, "22000", f);
                        }
                    }
                } else {
                    is = this.localInfileInputStream;
                    this.localInfileInputStream = null;
                }
                this.writer.sendFile(is, rawPacket.getPacketSeq() + 1);
                is.close();
                rawPacket = this.packetFetcher.getRawPacket();
                resultPacket = ResultPacketFactory.createResultPacket(rawPacket);
            }
        }
        catch (SocketTimeoutException ste) {
            this.close();
            throw new QueryException("Could not read resultset: " + ste.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), ste);
        }
        catch (IOException e) {
            try {
                if (this.writer != null) {
                    this.writer.writeEmptyPacket(rawPacket.getPacketSeq() + 1);
                    rawPacket = this.packetFetcher.getRawPacket();
                    ResultPacketFactory.createResultPacket(rawPacket);
                }
            }
            catch (IOException localInfilePacket) {
                // empty catch block
            }
            throw new QueryException("Could not read resultset: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        switch (resultPacket.getResultType()) {
            case ERROR: {
                this.moreResults = false;
                this.hasWarnings = false;
                ErrorPacket ep = (ErrorPacket)resultPacket;
                throw new QueryException(ep.getMessage(), ep.getErrorNumber(), ep.getSqlState());
            }
            case OK: {
                OKPacket okpacket = (OKPacket)resultPacket;
                this.serverStatus = okpacket.getServerStatus();
                this.moreResults = (this.serverStatus & 8) != 0;
                this.hasWarnings = okpacket.getWarnings() > 0;
                UpdateResult updateResult = new UpdateResult(okpacket.getAffectedRows(), okpacket.getWarnings(), okpacket.getMessage(), okpacket.getInsertId());
                return updateResult;
            }
            case RESULTSET: {
                this.hasWarnings = false;
                ResultSetPacket resultSetPacket = (ResultSetPacket)resultPacket;
                try {
                    return this.createQueryResult(resultSetPacket, streaming, binaryProtocol);
                }
                catch (IOException e) {
                    throw new QueryException("Could not read result set: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
                }
            }
        }
        throw new QueryException("Could not parse result", -1, SQLExceptionMapper.SQLStates.INTERRUPTED_EXCEPTION.getSqlState());
    }

    @Override
    public QueryResult executeQuery(Query query, boolean streaming) throws QueryException {
        ArrayList<Query> queries = new ArrayList<Query>();
        queries.add(query);
        return this.executeQuery(queries, streaming, false, 0);
    }

    @Override
    public QueryResult executeQuery(List<Query> dQueries, boolean streaming, boolean isRewritable, int rewriteOffset) throws QueryException {
        for (Query query : dQueries) {
            query.validate();
        }
        this.moreResults = false;
        StreamedQueryPacket packet = new StreamedQueryPacket(dQueries, isRewritable, rewriteOffset);
        try {
            packet.send(this.writer);
        }
        catch (MaxAllowedPacketException e) {
            if (e.isMustReconnect()) {
                this.connect();
            }
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.INTERRUPTED_EXCEPTION.getSqlState(), e);
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        try {
            return this.getResult(dQueries, streaming, false);
        }
        catch (QueryException qex) {
            if (qex.getCause() instanceof SocketTimeoutException) {
                throw new QueryException("Connection timed out", -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), qex);
            }
            throw qex;
        }
    }

    public QueryResult executeBatch(List<Query> dQueries, boolean streaming, boolean isRewritable, int rewriteOffset) throws QueryException {
        for (Query query : dQueries) {
            query.validate();
        }
        this.moreResults = false;
        StreamedQueryPacket packet = new StreamedQueryPacket(dQueries, isRewritable, rewriteOffset);
        try {
            packet.send(this.writer);
        }
        catch (MaxAllowedPacketException e) {
            if (e.isMustReconnect()) {
                this.connect();
            }
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.INTERRUPTED_EXCEPTION.getSqlState(), e);
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        try {
            return this.getResult(dQueries, streaming, false);
        }
        catch (QueryException qex) {
            if (qex.getCause() instanceof SocketTimeoutException) {
                throw new QueryException("Connection timed out", -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), qex);
            }
            throw qex;
        }
    }

    @Override
    public QueryResult executePreparedQueryAfterFailover(String sql, ParameterHolder[] parameters, PrepareResult oldPrepareResult, MySQLType[] parameterTypeHeader, boolean isStreaming) throws QueryException {
        PrepareResult prepareResult = this.prepare(sql);
        QueryResult queryResult = this.executePreparedQuery(sql, parameters, prepareResult, parameterTypeHeader, isStreaming);
        queryResult.setFailureObject(prepareResult);
        return queryResult;
    }

    @Override
    public QueryResult executePreparedQuery(String sql, ParameterHolder[] parameters, PrepareResult prepareResult, MySQLType[] parameterTypeHeader, boolean isStreaming) throws QueryException {
        this.moreResults = false;
        try {
            int parameterCount = parameters.length;
            for (int i = 0; i < parameterCount; ++i) {
                if (!parameters[i].isLongData()) continue;
                SendPrepareParameterPacket sendPrepareParameterPacket = new SendPrepareParameterPacket(i, (LongDataParameterHolder)parameters[i], prepareResult.statementId, this.mySQLServerCharset);
                sendPrepareParameterPacket.send(this.writer);
            }
            SendExecutePrepareStatementPacket packet = new SendExecutePrepareStatementPacket(prepareResult, parameters, parameterCount, parameterTypeHeader);
            packet.send(this.writer);
        }
        catch (MaxAllowedPacketException e) {
            if (e.isMustReconnect()) {
                this.connect();
            }
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.INTERRUPTED_EXCEPTION.getSqlState(), e);
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        try {
            return this.getResult(sql, isStreaming, true);
        }
        catch (QueryException qex) {
            if (qex.getCause() instanceof SocketTimeoutException) {
                throw new QueryException("Connection timed out", -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), qex);
            }
            throw qex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releasePrepareStatement(String sql, int statementId) throws QueryException {
        this.lock.writeLock().lock();
        try {
            if (this.jdbcUrl.getOptions().cachePrepStmts && this.prepareStatementCache.containsKey(sql)) {
                PrepareResult pr = (PrepareResult)this.prepareStatementCache.get(sql);
                pr.removeUse();
                if (!pr.hasToBeClose()) {
                    return;
                }
                this.prepareStatementCache.remove(sql);
            }
            SendClosePrepareStatementPacket packet = new SendClosePrepareStatementPacket(statementId);
            try {
                packet.send(this.writer);
            }
            catch (IOException e) {
                throw new QueryException("Could not send query: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void cancelCurrentQuery() throws QueryException, IOException {
        MySQLProtocol copiedProtocol = new MySQLProtocol(this.jdbcUrl, new ReentrantReadWriteLock());
        copiedProtocol.setHostAddress(this.getHostAddress());
        copiedProtocol.connect();
        copiedProtocol.executeQuery(new MySQLQuery("KILL QUERY " + this.serverThreadId));
        copiedProtocol.close();
    }

    @Override
    public QueryResult getMoreResults(boolean streaming) throws QueryException {
        if (!this.moreResults) {
            return null;
        }
        return this.getResult(null, streaming, this.activeResult != null ? this.activeResult.isBinaryProtocol() : false);
    }

    @Override
    public boolean hasUnreadData() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.activeResult != null;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void setInternalMaxRows(int max) {
        if (this.maxRows != max) {
            this.maxRows = max;
        }
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws QueryException {
        if (this.maxRows != max) {
            if (max == 0) {
                this.executeQuery(new MySQLQuery("set @@SQL_SELECT_LIMIT=DEFAULT"));
            } else {
                this.executeQuery(new MySQLQuery("set @@SQL_SELECT_LIMIT=" + max));
            }
            this.maxRows = max;
        }
    }

    void parseVersion() {
        String[] a = this.version.split("[^0-9]");
        if (a.length > 0) {
            this.majorVersion = Integer.parseInt(a[0]);
        }
        if (a.length > 1) {
            this.minorVersion = Integer.parseInt(a[1]);
        }
        if (a.length > 2) {
            this.patchVersion = Integer.parseInt(a[2]);
        }
    }

    @Override
    public int getMajorServerVersion() {
        return this.majorVersion;
    }

    @Override
    public int getMinorServerVersion() {
        return this.minorVersion;
    }

    @Override
    public boolean versionGreaterOrEqual(int major, int minor, int patch) {
        if (this.majorVersion > major) {
            return true;
        }
        if (this.majorVersion < major) {
            return false;
        }
        if (this.minorVersion > minor) {
            return true;
        }
        if (this.minorVersion < minor) {
            return false;
        }
        if (this.patchVersion > patch) {
            return true;
        }
        return this.patchVersion >= patch;
    }

    @Override
    public void setLocalInfileInputStream(InputStream inputStream) {
        this.localInfileInputStream = inputStream;
    }

    @Override
    public int getTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    @Override
    public void setTimeout(int timeout) throws SocketException {
        this.lock.writeLock().lock();
        try {
            this.getOptions().socketTimeout = timeout;
            this.socket.setSoTimeout(timeout);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean getPinGlobalTxToPhysicalConnection() {
        return this.jdbcUrl.getOptions().pinGlobalTxToPhysicalConnection;
    }

    @Override
    public void setTransactionIsolation(int level) throws QueryException {
        this.lock.writeLock().lock();
        try {
            String query = "SET SESSION TRANSACTION ISOLATION LEVEL";
            switch (level) {
                case 1: {
                    query = query + " READ UNCOMMITTED";
                    break;
                }
                case 2: {
                    query = query + " READ COMMITTED";
                    break;
                }
                case 4: {
                    query = query + " REPEATABLE READ";
                    break;
                }
                case 8: {
                    query = query + " SERIALIZABLE";
                    break;
                }
                default: {
                    throw new QueryException("Unsupported transaction isolation level");
                }
            }
            this.executeQuery(new MySQLQuery(query));
            this.transactionIsolationLevel = level;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    @Override
    public boolean hasWarnings() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.hasWarnings;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isConnected() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.connected;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public long getServerThreadId() {
        return this.serverThreadId;
    }

    @Override
    public int getDatatypeMappingFlags() {
        return this.datatypeMappingFlags;
    }

    @Override
    public void closeIfActiveResult() {
        if (this.activeResult != null) {
            this.activeResult.close();
        }
    }

    @Override
    public boolean isExplicitClosed() {
        return this.explicitClosed;
    }

    @Override
    public PrepareStatementCache prepareStatementCache() {
        return this.prepareStatementCache;
    }

    @Override
    public Calendar getCalendar() {
        return this.cal;
    }
}

