/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql.packet;

import java.io.IOException;
import org.mariadb.jdbc.internal.common.Options;
import org.mariadb.jdbc.internal.common.PacketFetcher;
import org.mariadb.jdbc.internal.common.ValueObject;
import org.mariadb.jdbc.internal.common.packet.RawPacket;
import org.mariadb.jdbc.internal.common.packet.buffer.Reader;
import org.mariadb.jdbc.internal.mysql.MySQLColumnInformation;
import org.mariadb.jdbc.internal.mysql.MySQLValueObject;

public class MySQLRowPacket {
    private final ValueObject[] columns;
    private final Reader reader;
    private final MySQLColumnInformation[] columnInformation;
    private final Options options;

    public MySQLRowPacket(RawPacket rawPacket, MySQLColumnInformation[] columnInformation2, Options options) throws IOException {
        this.columns = new ValueObject[columnInformation2.length];
        this.reader = new Reader(rawPacket);
        this.columnInformation = columnInformation2;
        this.options = options;
    }

    public boolean isPacketComplete() throws IOException {
        long remaining;
        long encLength = this.reader.getSilentLengthEncodedBinary();
        return encLength <= (remaining = (long)this.reader.getRemainingSize());
    }

    public void appendPacket(RawPacket rawPacket) {
        this.reader.appendPacket(rawPacket);
    }

    public ValueObject[] getRow(PacketFetcher packetFetcher) throws IOException {
        for (int i = 0; i < this.columnInformation.length; ++i) {
            while (!this.isPacketComplete()) {
                this.appendPacket(packetFetcher.getRawPacket());
            }
            this.columns[i] = new MySQLValueObject(this.reader.getLengthEncodedBytes(), this.columnInformation[i], this.options);
        }
        return this.columns;
    }
}

