/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import org.mariadb.jdbc.MySQLBlob;

public class MySQLClob
extends MySQLBlob
implements Clob,
NClob,
Serializable {
    private static final long serialVersionUID = -2006825230517923067L;

    public MySQLClob(byte[] bytes) {
        super(bytes);
    }

    public MySQLClob() {
    }

    public String toString() {
        try {
            return new String(this.blobContent, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        try {
            return this.toString().substring((int)pos - 1, (int)pos - 1 + length);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return new StringReader(this.toString());
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return this.getBinaryStream();
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        return this.toString().indexOf(searchstr, (int)start - 1);
    }

    private int UTF8position(int charPosition) {
        int pos = 0;
        for (int i = 0; i < charPosition; ++i) {
            int c = this.blobContent[pos] & 0xFF;
            if (c < 128) {
                ++pos;
                continue;
            }
            if (c < 194) {
                throw new AssertionError((Object)"invalid UTF8");
            }
            if (c < 224) {
                pos += 2;
                continue;
            }
            if (c < 240) {
                pos += 3;
                continue;
            }
            if (c < 248) {
                pos += 4;
                continue;
            }
            throw new AssertionError((Object)"invalid UTF8");
        }
        return pos;
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        return this.position(searchstr.toString(), start);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        int bytePosition = this.UTF8position((int)pos - 1);
        super.setBytes(bytePosition + 1, str.getBytes(StandardCharsets.UTF_8));
        return str.length();
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        return this.setString(pos, str.substring(offset, offset + len));
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        return this.setBinaryStream(this.UTF8position((int)pos - 1) + 1);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        int bytePosition = this.UTF8position((int)pos - 1);
        OutputStream stream = this.setBinaryStream(bytePosition + 1);
        return new OutputStreamWriter(stream, StandardCharsets.UTF_8);
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        String sub = this.toString().substring((int)pos - 1, (int)pos - 1 + (int)length);
        return new StringReader(sub);
    }

    @Override
    public long length() {
        long len = 0L;
        int i = 0;
        while (i < this.actualSize) {
            int c = this.blobContent[i] & 0xFF;
            if (c < 128) {
                ++i;
            } else {
                if (c < 194) {
                    throw new AssertionError((Object)"invalid UTF8");
                }
                if (c < 224) {
                    i += 2;
                } else if (c < 240) {
                    i += 3;
                } else if (c < 248) {
                    i += 4;
                } else {
                    throw new AssertionError((Object)"invalid UTF8");
                }
            }
            ++len;
        }
        return len;
    }
}

