/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.util.ArrayList;
import java.util.List;
import org.mariadb.jdbc.internal.common.UrlHAMode;

public class HostAddress {
    public String host;
    public int port;
    public String type = null;

    public HostAddress() {
    }

    public HostAddress(String host, int port) {
        this.host = host;
        this.port = port;
        this.type = "master";
    }

    public HostAddress(String host, int port, String type) {
        this.host = host;
        this.port = port;
        this.type = type;
    }

    public static List<HostAddress> parse(String spec, UrlHAMode haMode) {
        if (spec == null) {
            throw new IllegalArgumentException("Invalid connection URL, host address must not be empty ");
        }
        String[] tokens = spec.trim().split(",");
        ArrayList<HostAddress> arr = new ArrayList<HostAddress>(tokens.length);
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i].startsWith("address=")) {
                arr.add(HostAddress.parseParameterHostAddress(tokens[i]));
                continue;
            }
            arr.add(HostAddress.parseSimpleHostAddress(tokens[i]));
        }
        int defaultPort = ((HostAddress)arr.get((int)(arr.size() - 1))).port;
        if (defaultPort == 0) {
            defaultPort = 3306;
        }
        for (int i = 0; i < arr.size(); ++i) {
            if (haMode == UrlHAMode.REPLICATION) {
                if (i == 0 && ((HostAddress)arr.get((int)i)).type == null) {
                    ((HostAddress)arr.get((int)i)).type = "master";
                } else if (i != 0 && ((HostAddress)arr.get((int)i)).type == null) {
                    ((HostAddress)arr.get((int)i)).type = "slave";
                }
            }
            if (((HostAddress)arr.get((int)i)).port != 0) continue;
            ((HostAddress)arr.get((int)i)).port = defaultPort;
        }
        return arr;
    }

    static HostAddress parseSimpleHostAddress(String s) {
        HostAddress result = new HostAddress();
        if (s.startsWith("[")) {
            int ind = s.indexOf(93);
            result.host = s.substring(1, ind);
            if (ind != s.length() - 1 && s.charAt(ind + 1) == ':') {
                result.port = Integer.parseInt(s.substring(ind + 2));
            }
        } else if (s.contains(":")) {
            String[] hostPort = s.split(":");
            result.host = hostPort[0];
            result.port = Integer.parseInt(hostPort[1]);
        } else {
            result.host = s;
        }
        return result;
    }

    static HostAddress parseParameterHostAddress(String s) {
        HostAddress result = new HostAddress();
        String[] array = s.split("(?=\\()|(?<=\\))");
        for (int i = 1; i < array.length; ++i) {
            String[] token = array[i].replace("(", "").replace(")", "").trim().split("=");
            if (token.length != 2) {
                throw new IllegalArgumentException("Invalid connection URL, expected key=value pairs, found " + array[i]);
            }
            String key = token[0].toLowerCase();
            String value = token[1].toLowerCase();
            if (key.equals("host")) {
                result.host = value.replace("[", "").replace("]", "");
                continue;
            }
            if (key.equals("port")) {
                result.port = Integer.parseInt(value);
                continue;
            }
            if (!key.equals("type") || !value.equals("master") && !value.equals("slave")) continue;
            result.type = value;
        }
        return result;
    }

    public static String toString(List<HostAddress> addrs) {
        String s = "";
        for (int i = 0; i < addrs.size(); ++i) {
            if (addrs.get((int)i).type != null) {
                s = s + "address=(host=" + addrs.get((int)i).host + ")(port=" + addrs.get((int)i).port + ")(type=" + addrs.get((int)i).type + ")";
            } else {
                boolean isIPv6 = addrs.get((int)i).host != null && addrs.get((int)i).host.contains(":");
                String host = isIPv6 ? "[" + addrs.get((int)i).host + "]" : addrs.get((int)i).host;
                s = s + host + ":" + addrs.get((int)i).port;
            }
            if (i >= addrs.size() - 1) continue;
            s = s + ",";
        }
        return s;
    }

    public static String toString(HostAddress[] addrs) {
        String s = "";
        for (int i = 0; i < addrs.length; ++i) {
            if (addrs[i].type != null) {
                s = s + "address=(host=" + addrs[i].host + ")(port=" + addrs[i].port + ")(type=" + addrs[i].type + ")";
            } else {
                boolean isIPv6 = addrs[i].host != null && addrs[i].host.contains(":");
                String host = isIPv6 ? "[" + addrs[i].host + "]" : addrs[i].host;
                s = s + host + ":" + addrs[i].port;
            }
            if (i >= addrs.length - 1) continue;
            s = s + ",";
        }
        return s;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostAddress that = (HostAddress)o;
        if (this.port != that.port) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        return !(this.type == null ? that.type != null : !this.type.equals(that.type));
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + this.port;
        return result;
    }

    public String toString() {
        return "HostAddress{host='" + this.host + '\'' + ", port=" + this.port + ", type='" + this.type + '\'' + '}';
    }
}

