/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql;

import java.text.ParseException;
import java.util.Calendar;
import org.mariadb.jdbc.internal.common.AbstractValueObject;
import org.mariadb.jdbc.internal.mysql.MySQLColumnInformation;
import org.mariadb.jdbc.internal.mysql.MySQLType;

public class MySQLValueObject
extends AbstractValueObject {
    MySQLColumnInformation columnInfo;

    public MySQLValueObject(byte[] rawBytes, MySQLColumnInformation columnInfo) {
        super(rawBytes, columnInfo.getType());
        this.columnInfo = columnInfo;
    }

    @Override
    public String getString() {
        byte[] bytes = this.getBytes();
        if (bytes == null) {
            return null;
        }
        if (this.columnInfo.getType() == MySQLType.BIT && this.columnInfo.getLength() == 1L) {
            return bytes[0] == 0 ? "false" : "true";
        }
        return super.getString();
    }

    @Override
    public Object getObject(int datatypeMappingFlags, Calendar cal) throws ParseException {
        if (this.getBytes() == null) {
            return null;
        }
        switch (this.dataType) {
            case BIT: {
                if (this.columnInfo.getLength() == 1L) {
                    return this.getBytes()[0] != 0;
                }
                return this.getBytes();
            }
            case TINYINT: {
                if ((datatypeMappingFlags & 1) != 0 && this.columnInfo.getLength() == 1L) {
                    return this.getBytes()[0] != 48;
                }
                return this.getInt();
            }
            case INTEGER: {
                if (!this.columnInfo.isSigned()) {
                    return this.getLong();
                }
                return this.getInt();
            }
            case BIGINT: {
                if (!this.columnInfo.isSigned()) {
                    return this.getBigInteger();
                }
                return this.getLong();
            }
            case DOUBLE: {
                return this.getDouble();
            }
            case TIMESTAMP: {
                return this.getTimestamp(cal);
            }
            case DATETIME: {
                return this.getTimestamp(cal);
            }
            case DATE: {
                return this.getDate(cal);
            }
            case VARCHAR: {
                if (this.columnInfo.isBinary()) {
                    return this.getBytes();
                }
                return this.getString();
            }
            case DECIMAL: {
                return this.getBigDecimal();
            }
            case BLOB: {
                return this.getBytes();
            }
            case LONGBLOB: {
                return this.getBytes();
            }
            case MEDIUMBLOB: {
                return this.getBytes();
            }
            case TINYBLOB: {
                return this.getBytes();
            }
            case NULL: {
                return null;
            }
            case YEAR: {
                if ((datatypeMappingFlags & 2) != 0) {
                    return this.getDate(cal);
                }
                return this.getShort();
            }
            case SMALLINT: 
            case MEDIUMINT: {
                return this.getInt();
            }
            case FLOAT: {
                return Float.valueOf(this.getFloat());
            }
            case TIME: {
                return this.getTime(cal);
            }
            case VARSTRING: 
            case STRING: {
                if (this.columnInfo.isBinary()) {
                    return this.getBytes();
                }
                return this.getString();
            }
            case OLDDECIMAL: {
                return this.getString();
            }
        }
        throw new RuntimeException(this.dataType.toString());
    }
}

