/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.extensions.spring.converter;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.io.IOException;
import java.io.Writer;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.mapstruct.extensions.spring.SpringMapperConfig;
import org.mapstruct.extensions.spring.converter.ConversionServiceAdapterDescriptor;
import org.mapstruct.extensions.spring.converter.ConversionServiceAdapterGenerator;

@SupportedAnnotationTypes(value={"org.mapstruct.Mapper", "org.mapstruct.extensions.spring.SpringMapperConfig"})
public class ConverterMapperProcessor
extends AbstractProcessor {
    protected static final String MAPPER = "org.mapstruct.Mapper";
    protected static final String SPRING_MAPPER_CONFIG = "org.mapstruct.extensions.spring.SpringMapperConfig";
    protected static final String SPRING_CONVERTER_FULL_NAME = "org.springframework.core.convert.converter.Converter";
    private final ConversionServiceAdapterGenerator adapterGenerator;

    public ConverterMapperProcessor() {
        this(new ConversionServiceAdapterGenerator(Clock.systemUTC()));
    }

    ConverterMapperProcessor(ConversionServiceAdapterGenerator adapterGenerator) {
        this.adapterGenerator = adapterGenerator;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.adapterGenerator.init(processingEnv);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ConversionServiceAdapterDescriptor descriptor = this.buildDescriptor(annotations, roundEnv);
        annotations.stream().filter(this::isMapperAnnotation).forEach(annotation -> this.processMapperAnnotation(roundEnv, descriptor, (TypeElement)annotation));
        return false;
    }

    private ConversionServiceAdapterDescriptor buildDescriptor(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return new ConversionServiceAdapterDescriptor().adapterClassName(this.getAdapterClassName(annotations, roundEnv)).conversionServiceBeanName(ConverterMapperProcessor.getConversionServiceBeanName(annotations, roundEnv)).lazyAnnotatedConversionServiceBean(ConverterMapperProcessor.getLazyAnnotatedConversionServiceBean(annotations, roundEnv)).fromToMappings(this.getExternalConversionMappings(annotations, roundEnv));
    }

    private List<Pair<TypeName, TypeName>> getExternalConversionMappings(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return annotations.stream().filter(ConverterMapperProcessor::isSpringMapperConfigAnnotation).findFirst().flatMap(annotation -> ConverterMapperProcessor.findFirstElementAnnotatedWith(roundEnv, annotation)).flatMap(this::toSpringMapperConfigMirror).map(AnnotationMirror::getElementValues).flatMap(this::extractExternalConversions).map(Map.Entry::getValue).map(AnnotationValue::getValue).map(List.class::cast).map(this::toSourceTargetTypeNamePairs).orElse(Collections.emptyList());
    }

    private List<Pair<TypeName, TypeName>> toSourceTargetTypeNamePairs(List<? extends AnnotationMirror> list) {
        return list.stream().map(AnnotationMirror::getElementValues).map(this::toSourceTargetTypeNamePair).collect(Collectors.toList());
    }

    private Pair<TypeName, TypeName> toSourceTargetTypeNamePair(Map<? extends ExecutableElement, ? extends AnnotationValue> elementMap) {
        return Pair.of((Object)TypeName.get((TypeMirror)ConverterMapperProcessor.findSourceType(elementMap)), (Object)TypeName.get((TypeMirror)ConverterMapperProcessor.findTargetType(elementMap)));
    }

    private Optional<? extends Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> extractExternalConversions(Map<? extends ExecutableElement, ? extends AnnotationValue> map) {
        return map.entrySet().stream().filter(this::hasNameExternalConversions).findFirst();
    }

    private boolean hasNameExternalConversions(Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry) {
        return ConverterMapperProcessor.hasName(entry.getKey().getSimpleName(), "externalConversions");
    }

    private static TypeMirror findTargetType(Map<? extends ExecutableElement, ? extends AnnotationValue> externalConversionElementMap) {
        return ConverterMapperProcessor.findTypeMirrorAttribute(externalConversionElementMap, "targetType");
    }

    private static TypeMirror findSourceType(Map<? extends ExecutableElement, ? extends AnnotationValue> externalConversionElementMap) {
        return ConverterMapperProcessor.findTypeMirrorAttribute(externalConversionElementMap, "sourceType");
    }

    private static TypeMirror findTypeMirrorAttribute(Map<? extends ExecutableElement, ? extends AnnotationValue> externalConversionElementMap, String attributeName) {
        return externalConversionElementMap.entrySet().stream().filter(entry -> ConverterMapperProcessor.hasName(((ExecutableElement)entry.getKey()).getSimpleName(), attributeName)).map(Map.Entry::getValue).map(AnnotationValue::getValue).map(TypeMirror.class::cast).findFirst().orElseThrow(IllegalStateException::new);
    }

    private boolean isMapperAnnotation(TypeElement annotation) {
        return MAPPER.contentEquals(annotation.getQualifiedName());
    }

    private void processMapperAnnotation(RoundEnvironment roundEnv, ConversionServiceAdapterDescriptor descriptor, TypeElement annotation) {
        List fromToMappings = roundEnv.getElementsAnnotatedWith(annotation).stream().filter(ConverterMapperProcessor::isKindDeclared).filter(this::hasConverterSupertype).map(this::toTypeArguments).filter(Objects::nonNull).map(ConverterMapperProcessor::toFromToMapping).collect(Collectors.toCollection(ArrayList::new));
        fromToMappings.addAll(descriptor.getFromToMappings());
        descriptor.fromToMappings(fromToMappings);
        this.writeAdapterClassFile(descriptor);
    }

    private boolean hasConverterSupertype(Element mapper) {
        return this.getConverterSupertype(mapper).isPresent();
    }

    private static boolean isKindDeclared(Element mapper) {
        return mapper.asType().getKind() == TypeKind.DECLARED;
    }

    private static Pair<TypeName, TypeName> toFromToMapping(List<? extends TypeMirror> sourceTypeTargetType) {
        return Pair.of((Object)TypeName.get((TypeMirror)sourceTypeTargetType.get(0)), (Object)TypeName.get((TypeMirror)sourceTypeTargetType.get(1)));
    }

    private List<? extends TypeMirror> toTypeArguments(Element mapper) {
        return ((DeclaredType)this.getConverterSupertype(mapper).orElseThrow()).getTypeArguments();
    }

    private static boolean hasName(Name name, String comparisonName) {
        return name.contentEquals(comparisonName);
    }

    private void writeAdapterClassFile(ConversionServiceAdapterDescriptor descriptor) {
        try (Writer outputWriter = this.openAdapterFile(descriptor);){
            this.adapterGenerator.writeConversionServiceAdapter(descriptor, outputWriter);
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Error while opening %s output file: %s", descriptor.getAdapterClassName().simpleName(), e.getMessage()));
        }
    }

    private Writer openAdapterFile(ConversionServiceAdapterDescriptor descriptor) throws IOException {
        return this.processingEnv.getFiler().createSourceFile(descriptor.getAdapterClassName().canonicalName(), new Element[0]).openWriter();
    }

    private ClassName getAdapterClassName(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        MutablePair<String, String> packageAndClass = ConverterMapperProcessor.defaultPackageAndClassName();
        this.updateFromConfigAnnotationIfFound(annotations, roundEnv, packageAndClass);
        return ClassName.get((String)((String)packageAndClass.getLeft()), (String)((String)packageAndClass.getRight()), (String[])new String[0]);
    }

    private static MutablePair<String, String> defaultPackageAndClassName() {
        return MutablePair.of((Object)ConverterMapperProcessor.class.getPackage().getName(), (Object)"ConversionServiceAdapter");
    }

    private void updateFromConfigAnnotationIfFound(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv, MutablePair<String, String> packageAndClass) {
        annotations.stream().filter(ConverterMapperProcessor::isSpringMapperConfigAnnotation).forEach(annotation -> this.updateFromSpringMapperConfig(packageAndClass, (TypeElement)annotation, roundEnv));
    }

    private void updateFromSpringMapperConfig(MutablePair<String, String> packageAndClass, TypeElement springMapperConfig, RoundEnvironment roundEnv) {
        roundEnv.getElementsAnnotatedWith(springMapperConfig).forEach(element -> this.updateFromDeclaration(packageAndClass, (Element)element));
    }

    private static boolean isSpringMapperConfigAnnotation(TypeElement annotation) {
        return SPRING_MAPPER_CONFIG.contentEquals(annotation.getQualifiedName());
    }

    private void updateFromDeclaration(MutablePair<String, String> adapterPackageAndClass, Element element) {
        SpringMapperConfig springMapperConfig = element.getAnnotation(SpringMapperConfig.class);
        adapterPackageAndClass.setLeft((Object)Optional.of(springMapperConfig.conversionServiceAdapterPackage()).filter(StringUtils::isNotBlank).orElseGet(() -> this.getPackageName(element)));
        adapterPackageAndClass.setRight((Object)springMapperConfig.conversionServiceAdapterClassName());
    }

    private String getPackageName(Element element) {
        return String.valueOf(this.processingEnv.getElementUtils().getPackageOf(element).getQualifiedName());
    }

    private static String getConversionServiceBeanName(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return annotations.stream().filter(ConverterMapperProcessor::isSpringMapperConfigAnnotation).findFirst().flatMap(annotation -> ConverterMapperProcessor.findFirstElementAnnotatedWith(roundEnv, annotation)).map(ConverterMapperProcessor::toSpringMapperConfig).map(SpringMapperConfig::conversionServiceBeanName).orElse(null);
    }

    private static Optional<? extends Element> findFirstElementAnnotatedWith(RoundEnvironment roundEnv, TypeElement annotation) {
        return roundEnv.getElementsAnnotatedWith(annotation).stream().findFirst();
    }

    private static SpringMapperConfig toSpringMapperConfig(Element element) {
        return element.getAnnotation(SpringMapperConfig.class);
    }

    private Optional<? extends AnnotationMirror> toSpringMapperConfigMirror(Element element) {
        return element.getAnnotationMirrors().stream().filter(this::isSpringMapperConfigMirror).findFirst();
    }

    private boolean isSpringMapperConfigMirror(AnnotationMirror annotationMirror) {
        return this.processingEnv.getElementUtils().getTypeElement(SpringMapperConfig.class.getName()).asType().equals(annotationMirror.getAnnotationType().asElement().asType());
    }

    private static boolean getLazyAnnotatedConversionServiceBean(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return annotations.stream().filter(ConverterMapperProcessor::isSpringMapperConfigAnnotation).findFirst().flatMap(annotation -> ConverterMapperProcessor.findFirstElementAnnotatedWith(roundEnv, annotation)).map(ConverterMapperProcessor::toSpringMapperConfig).map(SpringMapperConfig::lazyAnnotatedConversionServiceBean).orElse(Boolean.TRUE);
    }

    private Optional<? extends TypeMirror> getConverterSupertype(Element mapper) {
        return this.getDirectSupertypes(mapper).stream().filter(this::isSpringConverterType).findFirst();
    }

    private List<? extends TypeMirror> getDirectSupertypes(Element mapper) {
        return this.processingEnv.getTypeUtils().directSupertypes(mapper.asType());
    }

    private boolean isSpringConverterType(TypeMirror supertype) {
        return this.processingEnv.getTypeUtils().erasure(supertype).toString().equals(SPRING_CONVERTER_FULL_NAME);
    }
}

