/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.extensions.spring.converter;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;
import javax.tools.Diagnostic;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.mapstruct.extensions.spring.converter.ConversionServiceAdapterDescriptor;

public class ConversionServiceAdapterGenerator {
    private static final ClassName CONVERSION_SERVICE_CLASS_NAME = ClassName.get((String)"org.springframework.core.convert", (String)"ConversionService", (String[])new String[0]);
    private static final String CONVERSION_SERVICE_FIELD_NAME = "conversionService";
    private static final ClassName QUALIFIER_ANNOTATION_CLASS_NAME = ClassName.get((String)"org.springframework.beans.factory.annotation", (String)"Qualifier", (String[])new String[0]);
    private static final ClassName LAZY_ANNOTATION_CLASS_NAME = ClassName.get((String)"org.springframework.context.annotation", (String)"Lazy", (String[])new String[0]);
    private static final ClassName TYPE_DESCRIPTOR_CLASS_NAME = ClassName.get((String)"org.springframework.core.convert", (String)"TypeDescriptor", (String[])new String[0]);
    private static final String GENERATED_ANNOTATION_CLASS_NAME_STRING = "Generated";
    private static final String PRE_JAVA_9_ANNOTATION_GENERATED_PACKAGE = "javax.annotation";
    private static final ClassName PRE_JAVA_9_ANNOTATION_GENERATED_CLASS_NAME = ClassName.get((String)"javax.annotation", (String)"Generated", (String[])new String[0]);
    private static final String JAVA_9_PLUS_ANNOTATION_GENERATED_PACKAGE = "javax.annotation.processing";
    private static final ClassName JAVA_9_PLUS_ANNOTATION_GENERATED_CLASS_NAME = ClassName.get((String)"javax.annotation.processing", (String)"Generated", (String[])new String[0]);
    private static final String PRE_JAVA_9_ANNOTATION_GENERATED = String.format("%s.%s", "javax.annotation", "Generated");
    private static final String JAVA_9_PLUS_ANNOTATION_GENERATED = String.format("%s.%s", "javax.annotation.processing", "Generated");
    private static final ClassName COMPONENT_ANNOTATION_CLASS_NAME = ClassName.get((String)"org.springframework.stereotype", (String)"Component", (String[])new String[0]);
    private static final String SUPPRESS_GENERATOR_TIMESTAMP = "mapstruct.suppressGeneratorTimestamp";
    private final Clock clock;
    private final AtomicReference<ProcessingEnvironment> processingEnvironment;

    public ConversionServiceAdapterGenerator(Clock clock) {
        this.clock = clock;
        this.processingEnvironment = new AtomicReference();
    }

    ProcessingEnvironment getProcessingEnvironment() {
        return this.processingEnvironment.get();
    }

    public void writeConversionServiceAdapter(ConversionServiceAdapterDescriptor descriptor, Writer out) {
        try {
            JavaFile.builder((String)descriptor.getAdapterClassName().packageName(), (TypeSpec)this.createConversionServiceTypeSpec(descriptor)).build().writeTo((Appendable)out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private TypeSpec createConversionServiceTypeSpec(ConversionServiceAdapterDescriptor descriptor) {
        FieldSpec conversionServiceFieldSpec = ConversionServiceAdapterGenerator.buildConversionServiceFieldSpec();
        TypeSpec.Builder adapterClassTypeSpec = TypeSpec.classBuilder((ClassName)descriptor.getAdapterClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        Optional.ofNullable(this.buildGeneratedAnnotationSpec()).ifPresent(arg_0 -> ((TypeSpec.Builder)adapterClassTypeSpec).addAnnotation(arg_0));
        return adapterClassTypeSpec.addAnnotation(COMPONENT_ANNOTATION_CLASS_NAME).addField(conversionServiceFieldSpec).addMethod(ConversionServiceAdapterGenerator.buildConstructorSpec(descriptor, conversionServiceFieldSpec)).addMethods(this.buildMappingMethods(descriptor, conversionServiceFieldSpec)).build();
    }

    private static MethodSpec buildConstructorSpec(ConversionServiceAdapterDescriptor descriptor, FieldSpec conversionServiceFieldSpec) {
        ParameterSpec constructorParameterSpec = ConversionServiceAdapterGenerator.buildConstructorParameterSpec(descriptor, conversionServiceFieldSpec);
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(constructorParameterSpec).addStatement("this.$N = $N", new Object[]{conversionServiceFieldSpec, constructorParameterSpec}).build();
    }

    private static ParameterSpec buildConstructorParameterSpec(ConversionServiceAdapterDescriptor descriptor, FieldSpec conversionServiceFieldSpec) {
        ParameterSpec.Builder parameterBuilder = ParameterSpec.builder((TypeName)conversionServiceFieldSpec.type, (String)conversionServiceFieldSpec.name, (Modifier[])new Modifier[]{Modifier.FINAL});
        if (StringUtils.isNotEmpty((CharSequence)descriptor.getConversionServiceBeanName())) {
            parameterBuilder.addAnnotation(ConversionServiceAdapterGenerator.buildQualifierAnnotation(descriptor));
        }
        if (Boolean.TRUE.equals(descriptor.isLazyAnnotatedConversionServiceBean())) {
            parameterBuilder.addAnnotation(ConversionServiceAdapterGenerator.buildLazyAnnotation());
        }
        return parameterBuilder.build();
    }

    private static AnnotationSpec buildQualifierAnnotation(ConversionServiceAdapterDescriptor descriptor) {
        return AnnotationSpec.builder((ClassName)QUALIFIER_ANNOTATION_CLASS_NAME).addMember("value", "$S", new Object[]{descriptor.getConversionServiceBeanName()}).build();
    }

    private static AnnotationSpec buildLazyAnnotation() {
        return AnnotationSpec.builder((ClassName)LAZY_ANNOTATION_CLASS_NAME).build();
    }

    private String collectionOfMethodName(ParameterizedTypeName parameterizedTypeName) {
        if (this.isCollectionWithGenericParameter(parameterizedTypeName)) {
            return ConversionServiceAdapterGenerator.simpleName((TypeName)parameterizedTypeName) + "Of" + this.collectionOfNameIfApplicable((TypeName)parameterizedTypeName.typeArguments.iterator().next());
        }
        return ConversionServiceAdapterGenerator.simpleName((TypeName)parameterizedTypeName);
    }

    private boolean isCollectionWithGenericParameter(ParameterizedTypeName parameterizedTypeName) {
        return parameterizedTypeName.typeArguments != null && parameterizedTypeName.typeArguments.size() > 0 && this.isCollection(parameterizedTypeName);
    }

    private boolean isCollection(ParameterizedTypeName parameterizedTypeName) {
        try {
            return Collection.class.isAssignableFrom(Class.forName(parameterizedTypeName.rawType.canonicalName()));
        }
        catch (ClassNotFoundException e) {
            this.processingEnvironment.get().getMessager().printMessage(Diagnostic.Kind.WARNING, "Caught ClassNotFoundException when trying to resolve parameterized type: " + e.getMessage());
            return false;
        }
    }

    private String collectionOfNameIfApplicable(TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName) {
            return this.collectionOfMethodName((ParameterizedTypeName)typeName);
        }
        return ConversionServiceAdapterGenerator.simpleName(typeName);
    }

    private static String simpleName(TypeName typeName) {
        TypeName rawType = ConversionServiceAdapterGenerator.rawType(typeName);
        if (rawType instanceof ArrayTypeName) {
            return ConversionServiceAdapterGenerator.arraySimpleName((ArrayTypeName)rawType);
        }
        if (rawType instanceof ClassName) {
            return ((ClassName)rawType).simpleName();
        }
        return String.valueOf(typeName);
    }

    private static String arraySimpleName(ArrayTypeName arrayTypeName) {
        return "ArrayOf" + (arrayTypeName.componentType instanceof ArrayTypeName ? ConversionServiceAdapterGenerator.arraySimpleName((ArrayTypeName)arrayTypeName.componentType) : arrayTypeName.componentType);
    }

    private static TypeName rawType(TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName) {
            return ((ParameterizedTypeName)typeName).rawType;
        }
        return typeName;
    }

    private Iterable<MethodSpec> buildMappingMethods(ConversionServiceAdapterDescriptor descriptor, FieldSpec injectedConversionServiceFieldSpec) {
        return descriptor.getFromToMappings().stream().map(sourceTargetPair -> this.toMappingMethodSpec(injectedConversionServiceFieldSpec, (Pair<TypeName, TypeName>)sourceTargetPair)).collect(Collectors.toList());
    }

    private MethodSpec toMappingMethodSpec(FieldSpec injectedConversionServiceFieldSpec, Pair<TypeName, TypeName> sourceTargetPair) {
        ParameterSpec sourceParameterSpec = ConversionServiceAdapterGenerator.buildSourceParameterSpec((TypeName)sourceTargetPair.getLeft());
        return MethodSpec.methodBuilder((String)String.format("map%sTo%s", this.collectionOfNameIfApplicable((TypeName)sourceTargetPair.getLeft()), this.collectionOfNameIfApplicable((TypeName)sourceTargetPair.getRight()))).addParameter(sourceParameterSpec).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)sourceTargetPair.getRight()).addStatement(String.format("return ($T) $N.convert($N, %s, %s)", this.typeDescriptorFormat((TypeName)sourceTargetPair.getLeft()), this.typeDescriptorFormat((TypeName)sourceTargetPair.getRight())), this.allTypeDescriptorArguments(injectedConversionServiceFieldSpec, sourceParameterSpec, sourceTargetPair)).build();
    }

    private Object[] allTypeDescriptorArguments(FieldSpec injectedConversionServiceFieldSpec, ParameterSpec sourceParameterSpec, Pair<TypeName, TypeName> sourceTargetPair) {
        return Stream.concat(Stream.concat(Stream.of(sourceTargetPair.getRight(), injectedConversionServiceFieldSpec, sourceParameterSpec), this.typeDescriptorArguments((TypeName)sourceTargetPair.getLeft())), this.typeDescriptorArguments((TypeName)sourceTargetPair.getRight())).toArray();
    }

    private String typeDescriptorFormat(TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName && this.isCollectionWithGenericParameter((ParameterizedTypeName)typeName)) {
            return String.format("$T.collection($T.class, %s)", this.typeDescriptorFormat((TypeName)((ParameterizedTypeName)typeName).typeArguments.iterator().next()));
        }
        return "$T.valueOf($T.class)";
    }

    private Stream<Object> typeDescriptorArguments(TypeName typeName) {
        return typeName instanceof ParameterizedTypeName && this.isCollectionWithGenericParameter((ParameterizedTypeName)typeName) ? Stream.concat(Stream.of(TYPE_DESCRIPTOR_CLASS_NAME, ((ParameterizedTypeName)typeName).rawType), this.typeDescriptorArguments((TypeName)((ParameterizedTypeName)typeName).typeArguments.iterator().next())) : Stream.of(TYPE_DESCRIPTOR_CLASS_NAME, ConversionServiceAdapterGenerator.rawType(typeName));
    }

    private static ParameterSpec buildSourceParameterSpec(TypeName sourceClassName) {
        return ParameterSpec.builder((TypeName)sourceClassName, (String)"source", (Modifier[])new Modifier[]{Modifier.FINAL}).build();
    }

    private static FieldSpec buildConversionServiceFieldSpec() {
        return FieldSpec.builder((TypeName)CONVERSION_SERVICE_CLASS_NAME, (String)CONVERSION_SERVICE_FIELD_NAME, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    private AnnotationSpec buildGeneratedAnnotationSpec() {
        return Optional.ofNullable(this.baseAnnotationSpecBuilder()).map(build -> build.addMember("value", "$S", new Object[]{ConversionServiceAdapterGenerator.class.getName()})).map(this::addDateIfNotSuppressed).map(AnnotationSpec.Builder::build).orElse(null);
    }

    private AnnotationSpec.Builder addDateIfNotSuppressed(AnnotationSpec.Builder generatedAnnotationSpecBuilder) {
        return Boolean.parseBoolean(this.processingEnvironment.get().getOptions().get(SUPPRESS_GENERATOR_TIMESTAMP)) ? generatedAnnotationSpecBuilder : generatedAnnotationSpecBuilder.addMember("date", "$S", new Object[]{DateTimeFormatter.ISO_INSTANT.format(ZonedDateTime.now(this.clock))});
    }

    private AnnotationSpec.Builder baseAnnotationSpecBuilder() {
        Object builder = this.isJava9PlusGeneratedAvailable() ? AnnotationSpec.builder((ClassName)JAVA_9_PLUS_ANNOTATION_GENERATED_CLASS_NAME) : (this.isPreJava9GeneratedAvailable() ? AnnotationSpec.builder((ClassName)PRE_JAVA_9_ANNOTATION_GENERATED_CLASS_NAME) : null);
        return builder;
    }

    private boolean isPreJava9GeneratedAvailable() {
        return this.isTypeAvailable(PRE_JAVA_9_ANNOTATION_GENERATED);
    }

    private boolean isJava9PlusGeneratedAvailable() {
        return this.isSourceVersionAtLeast9() && this.isTypeAvailable(JAVA_9_PLUS_ANNOTATION_GENERATED);
    }

    private boolean isSourceVersionAtLeast9() {
        return this.processingEnvironment.get().getSourceVersion().compareTo(SourceVersion.RELEASE_8) > 0;
    }

    private boolean isTypeAvailable(String name) {
        return this.processingEnvironment.get().getElementUtils().getTypeElement(name) != null;
    }

    public void init(ProcessingEnvironment processingEnv) {
        if (!this.processingEnvironment.compareAndSet(null, processingEnv)) {
            throw new IllegalStateException("ProcessingEnvironment already set.");
        }
    }
}

