/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.extensions.spring.converter;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.io.IOException;
import java.io.Writer;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.mapstruct.extensions.spring.SpringMapperConfig;
import org.mapstruct.extensions.spring.converter.ConversionServiceAdapterDescriptor;
import org.mapstruct.extensions.spring.converter.ConversionServiceAdapterGenerator;

@SupportedAnnotationTypes(value={"org.mapstruct.Mapper", "org.mapstruct.extensions.spring.SpringMapperConfig"})
public class ConverterMapperProcessor
extends AbstractProcessor {
    protected static final String MAPPER = "org.mapstruct.Mapper";
    protected static final String SPRING_MAPPER_CONFIG = "org.mapstruct.extensions.spring.SpringMapperConfig";
    protected static final String SPRING_CONVERTER_FULL_NAME = "org.springframework.core.convert.converter.Converter";
    private final ConversionServiceAdapterGenerator adapterGenerator;

    public ConverterMapperProcessor() {
        this(new ConversionServiceAdapterGenerator(Clock.systemUTC()));
    }

    ConverterMapperProcessor(ConversionServiceAdapterGenerator adapterGenerator) {
        this.adapterGenerator = adapterGenerator;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ConversionServiceAdapterDescriptor descriptor = new ConversionServiceAdapterDescriptor();
        descriptor.setAdapterClassName(this.getAdapterClassName(annotations, roundEnv));
        descriptor.setConversionServiceBeanName(this.getConversionServiceName(annotations, roundEnv));
        descriptor.setLazyAnnotatedConversionServiceBean(this.getLazyAnnotatedConversionServiceBean(annotations, roundEnv));
        descriptor.setFromToMappings(this.getExternalConversionMappings(annotations, roundEnv));
        annotations.stream().filter(this::isMapperAnnotation).forEach(annotation -> this.processMapperAnnotation(roundEnv, descriptor, (TypeElement)annotation));
        return false;
    }

    private List<Pair<TypeName, TypeName>> getExternalConversionMappings(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return annotations.stream().filter(this::isSpringMapperConfigAnnotation).findFirst().flatMap(annotation -> ConverterMapperProcessor.findFirstElementAnnotatedWith(roundEnv, annotation)).flatMap(this::toSpringMapperConfigMirror).map(AnnotationMirror::getElementValues).flatMap(map -> map.entrySet().stream().filter(entry -> ((ExecutableElement)entry.getKey()).getSimpleName().contentEquals("externalConversions")).findFirst()).map(Map.Entry::getValue).map(AnnotationValue::getValue).map(objectValue -> (List)objectValue).map(list -> list.stream().map(AnnotationMirror::getElementValues).map(elementMap -> Pair.of((Object)TypeName.get((TypeMirror)ConverterMapperProcessor.findSourceType(elementMap)), (Object)TypeName.get((TypeMirror)ConverterMapperProcessor.findTargetType(elementMap)))).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private static TypeMirror findTargetType(Map<? extends ExecutableElement, ? extends AnnotationValue> externalConversionElementMap) {
        return ConverterMapperProcessor.findTypeMirrorAttribute(externalConversionElementMap, "targetType");
    }

    private static TypeMirror findSourceType(Map<? extends ExecutableElement, ? extends AnnotationValue> externalConversionElementMap) {
        return ConverterMapperProcessor.findTypeMirrorAttribute(externalConversionElementMap, "sourceType");
    }

    private static TypeMirror findTypeMirrorAttribute(Map<? extends ExecutableElement, ? extends AnnotationValue> externalConversionElementMap, String attributeName) {
        return externalConversionElementMap.entrySet().stream().filter(entry -> ((ExecutableElement)entry.getKey()).getSimpleName().contentEquals(attributeName)).map(Map.Entry::getValue).map(AnnotationValue::getValue).map(TypeMirror.class::cast).findFirst().orElseThrow(IllegalStateException::new);
    }

    private boolean isMapperAnnotation(TypeElement annotation) {
        return MAPPER.contentEquals(annotation.getQualifiedName());
    }

    private void processMapperAnnotation(RoundEnvironment roundEnv, ConversionServiceAdapterDescriptor descriptor, TypeElement annotation) {
        List fromToMappings = roundEnv.getElementsAnnotatedWith(annotation).stream().filter(this::isKindDeclared).filter(this::hasConverterSupertype).map(this::toConvertMethod).filter(Objects::nonNull).map(ExecutableElement.class::cast).map(this::toFromToMapping).collect(Collectors.toCollection(ArrayList::new));
        fromToMappings.addAll(descriptor.getFromToMappings());
        descriptor.setFromToMappings(fromToMappings);
        this.writeAdapterClassFile(descriptor);
    }

    private boolean hasConverterSupertype(Element mapper) {
        return this.getConverterSupertype(mapper).isPresent();
    }

    private boolean isKindDeclared(Element mapper) {
        return mapper.asType().getKind() == TypeKind.DECLARED;
    }

    private Pair<TypeName, TypeName> toFromToMapping(ExecutableElement convert) {
        return Pair.of((Object)convert.getParameters().stream().map(Element::asType).map(TypeName::get).findFirst().orElseThrow(NoSuchElementException::new), (Object)TypeName.get((TypeMirror)convert.getReturnType()));
    }

    private Element toConvertMethod(Element mapper) {
        return mapper.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.METHOD).filter(method -> method.getModifiers().contains((Object)Modifier.PUBLIC)).filter(method -> method.getSimpleName().contentEquals("convert")).filter(convert -> ((ExecutableElement)convert).getParameters().size() == 1).filter(convert -> this.processingEnv.getTypeUtils().isSameType(ConverterMapperProcessor.getFirstParameterType((ExecutableElement)convert), ConverterMapperProcessor.getFirstTypeArgument(this.getConverterSupertype(mapper).get()))).findFirst().orElse(null);
    }

    private void writeAdapterClassFile(ConversionServiceAdapterDescriptor descriptor) {
        try (Writer outputWriter = this.processingEnv.getFiler().createSourceFile(descriptor.getAdapterClassName().canonicalName(), new Element[0]).openWriter();){
            this.adapterGenerator.writeConversionServiceAdapter(descriptor, outputWriter);
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error while opening " + descriptor.getAdapterClassName().simpleName() + " output file: " + e.getMessage());
        }
    }

    private ClassName getAdapterClassName(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        MutablePair packageAndClass = MutablePair.of((Object)ConverterMapperProcessor.class.getPackage().getName(), (Object)"ConversionServiceAdapter");
        for (TypeElement typeElement : annotations) {
            if (!this.isSpringMapperConfigAnnotation(typeElement)) continue;
            roundEnv.getElementsAnnotatedWith(typeElement).forEach(element -> this.updateFromDeclaration((Element)element, (MutablePair<String, String>)packageAndClass));
        }
        return ClassName.get((String)((String)packageAndClass.getLeft()), (String)((String)packageAndClass.getRight()), (String[])new String[0]);
    }

    private boolean isSpringMapperConfigAnnotation(TypeElement annotation) {
        return SPRING_MAPPER_CONFIG.contentEquals(annotation.getQualifiedName());
    }

    private void updateFromDeclaration(Element element, MutablePair<String, String> adapterPackageAndClass) {
        SpringMapperConfig springMapperConfig = element.getAnnotation(SpringMapperConfig.class);
        adapterPackageAndClass.setLeft((Object)Optional.of(springMapperConfig.conversionServiceAdapterPackage()).filter(StringUtils::isNotBlank).orElse(String.valueOf(this.processingEnv.getElementUtils().getPackageOf(element).getQualifiedName())));
        adapterPackageAndClass.setRight((Object)springMapperConfig.conversionServiceAdapterClassName());
    }

    private String getConversionServiceName(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return annotations.stream().filter(this::isSpringMapperConfigAnnotation).findFirst().flatMap(annotation -> ConverterMapperProcessor.findFirstElementAnnotatedWith(roundEnv, annotation)).map(this::toSpringMapperConfig).map(SpringMapperConfig::conversionServiceBeanName).orElse(null);
    }

    private static Optional<? extends Element> findFirstElementAnnotatedWith(RoundEnvironment roundEnv, TypeElement annotation) {
        return roundEnv.getElementsAnnotatedWith(annotation).stream().findFirst();
    }

    private SpringMapperConfig toSpringMapperConfig(Element element) {
        return element.getAnnotation(SpringMapperConfig.class);
    }

    private Optional<? extends AnnotationMirror> toSpringMapperConfigMirror(Element element) {
        return element.getAnnotationMirrors().stream().filter(annotationMirror -> this.processingEnv.getElementUtils().getTypeElement(SpringMapperConfig.class.getName()).asType().equals(annotationMirror.getAnnotationType().asElement().asType())).findFirst();
    }

    private boolean getLazyAnnotatedConversionServiceBean(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return annotations.stream().filter(this::isSpringMapperConfigAnnotation).findFirst().flatMap(annotation -> ConverterMapperProcessor.findFirstElementAnnotatedWith(roundEnv, annotation)).map(this::toSpringMapperConfig).map(SpringMapperConfig::lazyAnnotatedConversionServiceBean).orElse(Boolean.TRUE);
    }

    private Optional<? extends TypeMirror> getConverterSupertype(Element mapper) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        return typeUtils.directSupertypes(mapper.asType()).stream().filter(supertype -> typeUtils.erasure((TypeMirror)supertype).toString().equals(SPRING_CONVERTER_FULL_NAME)).findFirst();
    }

    private static TypeMirror getFirstParameterType(ExecutableElement convert) {
        return convert.getParameters().stream().findFirst().map(Element::asType).orElse(null);
    }

    private static TypeMirror getFirstTypeArgument(TypeMirror converterSupertype) {
        return ((DeclaredType)converterSupertype).getTypeArguments().stream().findFirst().orElse(null);
    }
}

