/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mapsforge.core.model.Tag;
import org.mapsforge.core.util.LRUCache;
import org.mapsforge.core.util.Utils;
import org.mapsforge.map.datastore.PointOfInterest;
import org.mapsforge.map.layer.renderer.PolylineContainer;
import org.mapsforge.map.layer.renderer.StandardRenderer;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.rendertheme.RenderCallback;
import org.mapsforge.map.rendertheme.RenderContext;
import org.mapsforge.map.rendertheme.renderinstruction.Hillshading;
import org.mapsforge.map.rendertheme.renderinstruction.RenderInstruction;
import org.mapsforge.map.rendertheme.rule.Closed;
import org.mapsforge.map.rendertheme.rule.RenderThemeBuilder;
import org.mapsforge.map.rendertheme.rule.Rule;

public class RenderTheme {
    private static final int MATCHING_CACHE_SIZE = 8192;
    private final float baseStrokeWidth;
    private final float baseTextSize;
    private final boolean hasBackgroundOutside;
    private int levels;
    private final int mapBackground;
    private final int mapBackgroundOutside;
    private final LRUCache<Integer, RenderInstruction[]> wayMatchingCache;
    private final LRUCache<Integer, RenderInstruction[]> poiMatchingCache;
    private final ArrayList<Rule> rulesList;
    private ArrayList<Hillshading> hillShadings = new ArrayList();
    private final Map<Byte, Float> strokeScales = new HashMap<Byte, Float>();
    private final Map<Byte, Float> textScales = new HashMap<Byte, Float>();
    private static final int keyCodeName = Utils.hashTagParameter((String)"name");

    RenderTheme(RenderThemeBuilder renderThemeBuilder) {
        this.baseStrokeWidth = renderThemeBuilder.baseStrokeWidth;
        this.baseTextSize = renderThemeBuilder.baseTextSize;
        this.hasBackgroundOutside = renderThemeBuilder.hasBackgroundOutside;
        this.mapBackground = renderThemeBuilder.mapBackground;
        this.mapBackgroundOutside = renderThemeBuilder.mapBackgroundOutside;
        this.rulesList = new ArrayList();
        this.poiMatchingCache = new LRUCache(8192);
        this.wayMatchingCache = new LRUCache(8192);
    }

    public void destroy() {
        this.poiMatchingCache.clear();
        this.wayMatchingCache.clear();
        for (Rule r : this.rulesList) {
            r.destroy();
        }
    }

    public int getLevels() {
        return this.levels;
    }

    public int getMapBackground() {
        return this.mapBackground;
    }

    public int getMapBackgroundOutside() {
        return this.mapBackgroundOutside;
    }

    public boolean hasMapBackgroundOutside() {
        return this.hasBackgroundOutside;
    }

    public void matchClosedWay(RenderCallback renderCallback, RenderContext renderContext, PolylineContainer way) {
        this.matchWay(renderCallback, renderContext, Closed.YES, way);
    }

    public void matchLinearWay(RenderCallback renderCallback, RenderContext renderContext, PolylineContainer way) {
        this.matchWay(renderCallback, renderContext, Closed.NO, way);
    }

    public synchronized void matchNode(RenderCallback renderCallback, RenderContext renderContext, PointOfInterest poi) {
        int matchingCacheKey = this.computeMatchingCacheKey(poi.tags, renderContext.rendererJob.tile.zoomLevel, Closed.NO);
        RenderInstruction[] instructions = (RenderInstruction[])this.poiMatchingCache.get((Object)matchingCacheKey);
        if (instructions != null) {
            for (int i = 0; i < instructions.length; ++i) {
                instructions[i].renderNode(renderCallback, renderContext, poi);
            }
            return;
        }
        ArrayList<RenderInstruction> matchingList = new ArrayList<RenderInstruction>();
        int n = this.rulesList.size();
        for (int i = 0; i < n; ++i) {
            this.rulesList.get(i).matchNode(renderCallback, renderContext, matchingList, poi);
        }
        RenderInstruction[] matchingListA = new RenderInstruction[matchingList.size()];
        matchingList.toArray(matchingListA);
        this.poiMatchingCache.put((Object)matchingCacheKey, (Object)matchingListA);
    }

    public synchronized void scaleStrokeWidth(float scaleFactor, byte zoomLevel) {
        if (!this.strokeScales.containsKey(zoomLevel) || scaleFactor != this.strokeScales.get(zoomLevel).floatValue()) {
            int n = this.rulesList.size();
            for (int i = 0; i < n; ++i) {
                Rule rule = this.rulesList.get(i);
                if (rule.zoomMin > zoomLevel || rule.zoomMax < zoomLevel) continue;
                rule.scaleStrokeWidth(scaleFactor * this.baseStrokeWidth * DisplayModel.lineScale, zoomLevel);
            }
            this.strokeScales.put(zoomLevel, Float.valueOf(scaleFactor));
        }
    }

    public synchronized void scaleTextSize(float scaleFactor, byte zoomLevel) {
        if (!this.textScales.containsKey(zoomLevel) || scaleFactor != this.textScales.get(zoomLevel).floatValue()) {
            int n = this.rulesList.size();
            for (int i = 0; i < n; ++i) {
                Rule rule = this.rulesList.get(i);
                if (rule.zoomMin > zoomLevel || rule.zoomMax < zoomLevel) continue;
                rule.scaleTextSize(scaleFactor * this.baseTextSize * DisplayModel.textScale, zoomLevel);
            }
            this.textScales.put(zoomLevel, Float.valueOf(scaleFactor));
        }
    }

    void addRule(Rule rule) {
        this.rulesList.add(rule);
    }

    void addHillShadings(Hillshading hillshading) {
        this.hillShadings.add(hillshading);
    }

    void complete() {
        this.rulesList.trimToSize();
        this.hillShadings.trimToSize();
        int n = this.rulesList.size();
        for (int i = 0; i < n; ++i) {
            this.rulesList.get(i).onComplete();
        }
    }

    void setLevels(int levels) {
        this.levels = levels;
    }

    private synchronized void matchWay(RenderCallback renderCallback, RenderContext renderContext, Closed closed, PolylineContainer way) {
        int matchingCacheKey = this.computeMatchingCacheKey(way.getTags(), way.getUpperLeft().zoomLevel, closed);
        RenderInstruction[] instructions = (RenderInstruction[])this.wayMatchingCache.get((Object)matchingCacheKey);
        if (instructions != null) {
            for (int i = 0; i < instructions.length; ++i) {
                instructions[i].renderWay(renderCallback, renderContext, way);
            }
            return;
        }
        ArrayList<RenderInstruction> matchingList = new ArrayList<RenderInstruction>();
        int n = this.rulesList.size();
        for (int i = 0; i < n; ++i) {
            this.rulesList.get(i).matchWay(renderCallback, way, way.getUpperLeft(), closed, matchingList, renderContext);
        }
        RenderInstruction[] matchingListA = new RenderInstruction[matchingList.size()];
        matchingList.toArray(matchingListA);
        this.wayMatchingCache.put((Object)matchingCacheKey, (Object)matchingListA);
    }

    public void traverseRules(Rule.RuleVisitor visitor) {
        for (Rule rule : this.rulesList) {
            rule.apply(visitor);
        }
    }

    public void matchHillShadings(StandardRenderer renderer, RenderContext renderContext) {
        for (Hillshading hillShading : this.hillShadings) {
            hillShading.render(renderContext, renderer.hillsRenderConfig);
        }
    }

    private Integer computeMatchingCacheKey(List<Tag> tags, byte zoomLevel, Closed closed) {
        int result = 1;
        result = 31 * result + (closed == null ? 0 : closed.hashCode());
        if (tags != null) {
            int n = tags.size();
            for (int i = 0; i < n; ++i) {
                Tag tag = tags.get(i);
                if (keyCodeName == tag.keyCode) continue;
                result = 31 * result + tag.hashCode();
            }
        }
        result = 31 * result + zoomLevel;
        return result;
    }
}

