/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme.rule;

import java.util.List;
import org.mapsforge.core.model.Tag;
import org.mapsforge.map.rendertheme.rule.Closed;
import org.mapsforge.map.rendertheme.rule.Element;
import org.mapsforge.map.rendertheme.rule.NegativeMatcher;
import org.mapsforge.map.rendertheme.rule.Rule;
import org.mapsforge.map.rendertheme.rule.RuleBuilder;

class NegativeRule
extends Rule {
    final NegativeMatcher attributeMatcher;

    NegativeRule(RuleBuilder ruleBuilder, NegativeMatcher attributeMatcher) {
        super(ruleBuilder);
        this.attributeMatcher = attributeMatcher;
    }

    @Override
    boolean matchesNode(List<Tag> tags, byte zoomLevel) {
        return this.zoomMin <= zoomLevel && this.zoomMax >= zoomLevel && this.elementMatcher.matches(Element.NODE) && this.matchesTags(tags);
    }

    @Override
    boolean matchesWay(List<Tag> tags, byte zoomLevel, Closed closed) {
        return this.zoomMin <= zoomLevel && this.zoomMax >= zoomLevel && this.elementMatcher.matches(Element.WAY) && this.closedMatcher.matches(closed) && this.matchesTags(tags);
    }

    private boolean matchesTags(List<Tag> tags) {
        if (this.attributeMatcher.keyListDoesNotContainKeys(tags)) {
            return true;
        }
        int n = tags.size();
        for (int i = 0; i < n; ++i) {
            if (!this.attributeMatcher.matches(tags.get(i))) continue;
            return true;
        }
        return false;
    }
}

