/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme.renderinstruction;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.HillshadingBitmap;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Rectangle;
import org.mapsforge.core.model.Tile;
import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.map.layer.hills.HillsRenderConfig;
import org.mapsforge.map.layer.renderer.HillshadingContainer;
import org.mapsforge.map.layer.renderer.ShapePaintContainer;
import org.mapsforge.map.rendertheme.RenderContext;

public class Hillshading {
    private static final Logger LOGGER = Logger.getLogger(Hillshading.class.getName());
    private boolean always;
    private final int level;
    private final byte layer;
    private final byte minZoom;
    private final byte maxZoom;
    private final float magnitude;

    public Hillshading(byte minZoom, byte maxZoom, short magnitude, byte layer, boolean always, int level, GraphicFactory graphicFactory) {
        this.always = always;
        this.level = level;
        this.layer = layer;
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
        this.magnitude = magnitude;
    }

    public void render(RenderContext renderContext, HillsRenderConfig hillsRenderConfig) {
        if (hillsRenderConfig == null) {
            if (this.always) {
                renderContext.setDrawingLayers(this.layer);
                HillshadingContainer hillShape = new HillshadingContainer(null, this.magnitude, null, null);
                renderContext.addToCurrentDrawingLayer(this.level, new ShapePaintContainer(hillShape, null));
            }
            return;
        }
        float effectiveMagnitude = Math.min(Math.max(0.0f, this.magnitude * hillsRenderConfig.getMaginuteScaleFactor()), 255.0f) / 255.0f;
        Tile tile = renderContext.rendererJob.tile;
        byte zoomLevel = tile.zoomLevel;
        if (zoomLevel > this.maxZoom || zoomLevel < this.minZoom) {
            return;
        }
        Point origin = tile.getOrigin();
        double maptileTopLat = MercatorProjection.pixelYToLatitude((double)((long)origin.y), (long)tile.mapSize);
        double maptileLeftLng = MercatorProjection.pixelXToLongitude((double)((long)origin.x), (long)tile.mapSize);
        double maptileBottomLat = MercatorProjection.pixelYToLatitude((double)((long)origin.y + (long)tile.tileSize), (long)tile.mapSize);
        double maptileRightLng = MercatorProjection.pixelXToLongitude((double)((long)origin.x + (long)tile.tileSize), (long)tile.mapSize);
        double mapTileLatDegrees = maptileTopLat - maptileBottomLat;
        double mapTileLngDegrees = maptileRightLng - maptileLeftLng;
        double pxPerLat = (double)tile.tileSize / mapTileLatDegrees;
        double pxPerLng = (double)tile.tileSize / mapTileLngDegrees;
        if (maptileRightLng < maptileLeftLng) {
            maptileRightLng += (double)tile.mapSize;
        }
        int shadingLngStep = 1;
        int shadingLatStep = 1;
        int shadingLeftLng = (int)Math.floor(maptileLeftLng);
        while ((double)shadingLeftLng <= maptileRightLng) {
            int shadingBottomLat = (int)Math.floor(maptileBottomLat);
            while ((double)shadingBottomLat <= maptileTopLat) {
                int shadingRightLng = shadingLeftLng + 1;
                int shadingTopLat = shadingBottomLat + 1;
                HillshadingBitmap shadingTile = null;
                try {
                    shadingTile = hillsRenderConfig.getShadingTile(shadingBottomLat, shadingLeftLng, pxPerLat, pxPerLng);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
                if (shadingTile != null || this.always) {
                    int shadingInnerHeight;
                    int shadingInnerWidth;
                    int padding;
                    double shadingPixelOffset = 0.0;
                    if (shadingTile != null) {
                        padding = shadingTile.getPadding();
                        shadingInnerWidth = shadingTile.getWidth() - 2 * padding;
                        shadingInnerHeight = shadingTile.getHeight() - 2 * padding;
                    } else {
                        padding = 0;
                        shadingInnerWidth = 1;
                        shadingInnerHeight = 1;
                    }
                    double shadingSubrectTop = padding;
                    double shadingSubrectLeft = padding;
                    double shadingSubrectRight = shadingSubrectLeft + (double)shadingInnerWidth;
                    double shadingSubrectBottom = shadingSubrectTop + (double)shadingInnerHeight;
                    double maptileSubrectLeft = 0.0;
                    double maptileSubrectTop = 0.0;
                    double maptileSubrectRight = tile.tileSize;
                    double maptileSubrectBottom = tile.tileSize;
                    if ((double)shadingTopLat > maptileTopLat) {
                        shadingSubrectTop = (double)padding + (double)shadingInnerHeight * (((double)shadingTopLat - maptileTopLat) / (double)shadingLatStep);
                    } else if (maptileTopLat > (double)shadingTopLat) {
                        maptileSubrectTop = MercatorProjection.latitudeToPixelY((double)((double)shadingTopLat + shadingPixelOffset / (double)shadingInnerHeight), (long)tile.mapSize) - origin.y;
                    }
                    if ((double)shadingBottomLat < maptileBottomLat) {
                        shadingSubrectBottom = (double)(padding + shadingInnerHeight) - (double)shadingInnerHeight * ((maptileBottomLat - (double)shadingBottomLat) / (double)shadingLatStep);
                    } else if (maptileBottomLat < (double)shadingBottomLat) {
                        maptileSubrectBottom = MercatorProjection.latitudeToPixelY((double)((double)shadingBottomLat + shadingPixelOffset / (double)shadingInnerHeight), (long)tile.mapSize) - origin.y;
                    }
                    if ((double)shadingLeftLng < maptileLeftLng) {
                        shadingSubrectLeft = (double)padding + (double)shadingInnerWidth * ((maptileLeftLng - (double)shadingLeftLng) / (double)shadingLngStep);
                    } else if (maptileLeftLng < (double)shadingLeftLng) {
                        maptileSubrectLeft = MercatorProjection.longitudeToPixelX((double)((double)shadingLeftLng + shadingPixelOffset / (double)shadingInnerWidth), (long)tile.mapSize) - origin.x;
                    }
                    if ((double)shadingRightLng > maptileRightLng) {
                        shadingSubrectRight = (double)(padding + shadingInnerWidth) - (double)shadingInnerWidth * (((double)shadingRightLng - maptileRightLng) / (double)shadingLngStep);
                    } else if (maptileRightLng > (double)shadingRightLng) {
                        maptileSubrectRight = MercatorProjection.longitudeToPixelX((double)((double)shadingRightLng + shadingPixelOffset / (double)shadingInnerHeight), (long)tile.mapSize) - origin.x;
                    }
                    Rectangle hillsRect = shadingTile == null ? null : new Rectangle(shadingSubrectLeft, shadingSubrectTop, shadingSubrectRight, shadingSubrectBottom);
                    Rectangle maptileRect = new Rectangle(maptileSubrectLeft, maptileSubrectTop, maptileSubrectRight, maptileSubrectBottom);
                    HillshadingContainer hillShape = new HillshadingContainer(shadingTile, effectiveMagnitude, hillsRect, maptileRect);
                    renderContext.setDrawingLayers(this.layer);
                    renderContext.addToCurrentDrawingLayer(this.level, new ShapePaintContainer(hillShape, null));
                }
                shadingBottomLat += shadingLatStep;
            }
            shadingLeftLng += shadingLngStep;
        }
    }
}

