/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme.renderinstruction;

import java.util.HashMap;
import java.util.Map;
import org.mapsforge.core.graphics.Color;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.graphics.Style;
import org.mapsforge.map.datastore.PointOfInterest;
import org.mapsforge.map.layer.renderer.PolylineContainer;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.rendertheme.RenderCallback;
import org.mapsforge.map.rendertheme.RenderContext;
import org.mapsforge.map.rendertheme.XmlUtils;
import org.mapsforge.map.rendertheme.renderinstruction.RenderInstruction;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class Circle
extends RenderInstruction {
    private final Paint fill;
    private final Map<Byte, Paint> fills;
    private final int level;
    private float radius;
    private float renderRadius;
    private final Map<Byte, Float> renderRadiusScaled;
    private boolean scaleRadius;
    private final Paint stroke;
    private final Map<Byte, Paint> strokes;
    private float strokeWidth;

    public Circle(GraphicFactory graphicFactory, DisplayModel displayModel, String elementName, XmlPullParser pullParser, int level) throws XmlPullParserException {
        super(graphicFactory, displayModel);
        this.level = level;
        this.fill = graphicFactory.createPaint();
        this.fill.setColor(Color.TRANSPARENT);
        this.fill.setStyle(Style.FILL);
        this.fills = new HashMap<Byte, Paint>();
        this.stroke = graphicFactory.createPaint();
        this.stroke.setColor(Color.TRANSPARENT);
        this.stroke.setStyle(Style.STROKE);
        this.strokes = new HashMap<Byte, Paint>();
        this.renderRadiusScaled = new HashMap<Byte, Float>();
        this.extractValues(graphicFactory, displayModel, elementName, pullParser);
        if (!this.scaleRadius) {
            this.renderRadius = this.radius;
            this.stroke.setStrokeWidth(this.strokeWidth);
        }
    }

    @Override
    public void destroy() {
    }

    private void extractValues(GraphicFactory graphicFactory, DisplayModel displayModel, String elementName, XmlPullParser pullParser) throws XmlPullParserException {
        for (int i = 0; i < pullParser.getAttributeCount(); ++i) {
            String name = pullParser.getAttributeName(i);
            String value = pullParser.getAttributeValue(i);
            if ("radius".equals(name) || "r".equals(name)) {
                this.radius = XmlUtils.parseNonNegativeFloat(name, value) * displayModel.getScaleFactor();
                continue;
            }
            if ("cat".equals(name)) {
                this.category = value;
                continue;
            }
            if ("fill".equals(name)) {
                this.fill.setColor(XmlUtils.getColor(graphicFactory, value, displayModel.getThemeCallback(), this));
                continue;
            }
            if ("scale-radius".equals(name)) {
                this.scaleRadius = Boolean.parseBoolean(value);
                continue;
            }
            if ("stroke".equals(name)) {
                this.stroke.setColor(XmlUtils.getColor(graphicFactory, value, displayModel.getThemeCallback(), this));
                continue;
            }
            if ("stroke-width".equals(name)) {
                this.strokeWidth = XmlUtils.parseNonNegativeFloat(name, value) * displayModel.getScaleFactor();
                continue;
            }
            XmlUtils.logUnknownAttribute(elementName, name, value, i);
        }
        XmlUtils.checkMandatoryAttribute(elementName, "radius", Float.valueOf(this.radius));
    }

    private Paint getFillPaint(byte zoomLevel) {
        Paint paint = this.fills.get(zoomLevel);
        if (paint == null) {
            paint = this.fill;
        }
        return paint;
    }

    private float getRenderRadius(byte zoomLevel) {
        Float radius = this.renderRadiusScaled.get(zoomLevel);
        if (radius == null) {
            radius = Float.valueOf(this.renderRadius);
        }
        return radius.floatValue();
    }

    private Paint getStrokePaint(byte zoomLevel) {
        Paint paint = this.strokes.get(zoomLevel);
        if (paint == null) {
            paint = this.stroke;
        }
        return paint;
    }

    @Override
    public void renderNode(RenderCallback renderCallback, RenderContext renderContext, PointOfInterest poi) {
        renderCallback.renderPointOfInterestCircle(renderContext, this.getRenderRadius(renderContext.rendererJob.tile.zoomLevel), this.getFillPaint(renderContext.rendererJob.tile.zoomLevel), this.getStrokePaint(renderContext.rendererJob.tile.zoomLevel), this.level, poi);
    }

    @Override
    public void renderWay(RenderCallback renderCallback, RenderContext renderContext, PolylineContainer way) {
    }

    @Override
    public void scaleStrokeWidth(float scaleFactor, byte zoomLevel) {
        if (this.scaleRadius) {
            this.renderRadiusScaled.put(zoomLevel, Float.valueOf(this.radius * scaleFactor));
            if (this.stroke != null) {
                Paint paint = this.graphicFactory.createPaint(this.stroke);
                paint.setStrokeWidth(this.strokeWidth * scaleFactor);
                this.strokes.put(zoomLevel, paint);
            }
        }
    }

    @Override
    public void scaleTextSize(float scaleFactor, byte zoomLevel) {
    }
}

