/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme;

import java.io.IOException;
import java.io.InputStream;
import org.mapsforge.core.util.Utils;
import org.mapsforge.map.rendertheme.XmlRenderTheme;
import org.mapsforge.map.rendertheme.XmlRenderThemeMenuCallback;
import org.mapsforge.map.rendertheme.XmlThemeResourceProvider;

public class ZipRenderTheme
implements XmlRenderTheme {
    private XmlRenderThemeMenuCallback menuCallback;
    private final String relativePathPrefix;
    private XmlThemeResourceProvider resourceProvider;
    protected final String xmlTheme;

    public ZipRenderTheme(String xmlTheme, XmlThemeResourceProvider resourceProvider) {
        this(xmlTheme, resourceProvider, null);
    }

    public ZipRenderTheme(String xmlTheme, XmlThemeResourceProvider resourceProvider, XmlRenderThemeMenuCallback menuCallback) {
        this.xmlTheme = xmlTheme;
        this.resourceProvider = resourceProvider;
        this.menuCallback = menuCallback;
        this.relativePathPrefix = xmlTheme.substring(0, xmlTheme.lastIndexOf("/") + 1);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ZipRenderTheme)) {
            return false;
        }
        ZipRenderTheme other = (ZipRenderTheme)obj;
        try {
            if (this.getRenderThemeAsStream() != other.getRenderThemeAsStream()) {
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return Utils.equals((Object)this.relativePathPrefix, (Object)other.relativePathPrefix);
    }

    @Override
    public XmlRenderThemeMenuCallback getMenuCallback() {
        return this.menuCallback;
    }

    @Override
    public String getRelativePathPrefix() {
        return this.relativePathPrefix;
    }

    @Override
    public InputStream getRenderThemeAsStream() throws IOException {
        return this.resourceProvider.createInputStream(this.relativePathPrefix, this.xmlTheme.substring(this.xmlTheme.lastIndexOf("/") + 1));
    }

    @Override
    public XmlThemeResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        InputStream inputStream = null;
        try {
            inputStream = this.getRenderThemeAsStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        result = 31 * result + (inputStream == null ? 0 : inputStream.hashCode());
        result = 31 * result + (this.relativePathPrefix == null ? 0 : this.relativePathPrefix.hashCode());
        return result;
    }

    @Override
    public void setMenuCallback(XmlRenderThemeMenuCallback menuCallback) {
        this.menuCallback = menuCallback;
    }

    @Override
    public void setResourceProvider(XmlThemeResourceProvider resourceProvider) {
        this.resourceProvider = resourceProvider;
    }
}

