/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.renderer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Color;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.TileBitmap;
import org.mapsforge.core.mapelements.MapElementContainer;
import org.mapsforge.core.model.Rectangle;
import org.mapsforge.core.model.Tile;
import org.mapsforge.map.datastore.MapDataStore;
import org.mapsforge.map.datastore.MapReadResult;
import org.mapsforge.map.layer.hills.HillsRenderConfig;
import org.mapsforge.map.layer.renderer.CanvasRasterer;
import org.mapsforge.map.layer.renderer.RendererJob;
import org.mapsforge.map.layer.renderer.StandardRenderer;
import org.mapsforge.map.layer.renderer.TileDependencies;
import org.mapsforge.map.rendertheme.RenderContext;
import org.mapsforge.map.util.LayerUtil;

public class DirectRenderer
extends StandardRenderer {
    private static final Logger LOGGER = Logger.getLogger(DirectRenderer.class.getName());
    private final boolean renderLabels;
    private final TileDependencies tileDependencies;
    private final List<TileRefresher> tileRefreshers;

    public DirectRenderer(MapDataStore mapDataStore, GraphicFactory graphicFactory, boolean renderLabels, HillsRenderConfig hillsRenderConfig) {
        super(mapDataStore, graphicFactory, renderLabels, hillsRenderConfig);
        this.renderLabels = renderLabels;
        this.tileDependencies = new TileDependencies();
        this.tileRefreshers = new ArrayList<TileRefresher>();
    }

    public void addTileRefresher(TileRefresher tileRefresher) {
        this.tileRefreshers.add(tileRefresher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TileBitmap executeJob(RendererJob rendererJob) {
        RenderContext renderContext = null;
        try {
            renderContext = new RenderContext(rendererJob, new CanvasRasterer(this.graphicFactory));
            if (this.renderBitmap(renderContext)) {
                TileBitmap bitmap = null;
                if (this.mapDataStore != null) {
                    MapReadResult mapReadResult = this.mapDataStore.readMapData(rendererJob.tile);
                    this.processReadMapData(renderContext, mapReadResult);
                }
                if (!rendererJob.labelsOnly) {
                    renderContext.renderTheme.matchHillShadings(this, renderContext);
                    bitmap = this.graphicFactory.createTileBitmap(rendererJob.tile.tileSize, rendererJob.hasAlpha);
                    bitmap.setTimestamp(rendererJob.mapDataStore.getDataTimestamp(rendererJob.tile));
                    renderContext.canvasRasterer.setCanvasBitmap((Bitmap)bitmap);
                    if (!rendererJob.hasAlpha && rendererJob.displayModel.getBackgroundColor() != renderContext.renderTheme.getMapBackground()) {
                        renderContext.canvasRasterer.fill(renderContext.renderTheme.getMapBackground());
                    }
                    renderContext.canvasRasterer.drawWays(renderContext);
                }
                if (this.renderLabels) {
                    Set<MapElementContainer> labelsToDraw = this.processLabels(renderContext);
                    renderContext.canvasRasterer.drawMapElements(labelsToDraw, rendererJob.tile);
                }
                if (!rendererJob.labelsOnly && renderContext.renderTheme.hasMapBackgroundOutside()) {
                    Rectangle insideArea = this.mapDataStore.boundingBox().getPositionRelativeToTile(rendererJob.tile);
                    if (!rendererJob.hasAlpha) {
                        renderContext.canvasRasterer.fillOutsideAreas(renderContext.renderTheme.getMapBackgroundOutside(), insideArea);
                    } else {
                        renderContext.canvasRasterer.fillOutsideAreas(Color.TRANSPARENT, insideArea);
                    }
                }
                TileBitmap tileBitmap = bitmap;
                return tileBitmap;
            }
            TileBitmap bitmap = null;
            return bitmap;
        }
        catch (Exception e) {
            LOGGER.warning("Exception: " + e.getMessage());
            TileBitmap tileBitmap = null;
            return tileBitmap;
        }
        finally {
            if (renderContext != null) {
                renderContext.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<MapElementContainer> processLabels(RenderContext renderContext) {
        TileDependencies tileDependencies = this.tileDependencies;
        synchronized (tileDependencies) {
            HashSet<MapElementContainer> labelsToDraw = new HashSet<MapElementContainer>();
            Set neighbours = renderContext.rendererJob.tile.getNeighbours();
            for (Tile neighbour : neighbours) {
                labelsToDraw.addAll(this.tileDependencies.getOverlappingElements(neighbour, renderContext.rendererJob.tile));
            }
            List<MapElementContainer> currentElementsOrdered = LayerUtil.collisionFreeOrdered(renderContext.labels);
            Iterator<MapElementContainer> currentMapElementsIterator = currentElementsOrdered.iterator();
            block4: while (currentMapElementsIterator.hasNext()) {
                MapElementContainer current = currentMapElementsIterator.next();
                for (MapElementContainer label : labelsToDraw) {
                    if (!label.clashesWith(current)) continue;
                    currentMapElementsIterator.remove();
                    continue block4;
                }
            }
            labelsToDraw.addAll(currentElementsOrdered);
            for (Tile neighbour : neighbours) {
                Set<MapElementContainer> before = this.tileDependencies.getOverlappingElements(renderContext.rendererJob.tile, neighbour);
                HashSet<MapElementContainer> after = new HashSet<MapElementContainer>();
                for (MapElementContainer element : labelsToDraw) {
                    if (!element.intersects(neighbour.getBoundaryAbsolute())) continue;
                    after.add(element);
                }
                if (before.equals(after)) continue;
                this.tileDependencies.removeTileData(renderContext.rendererJob.tile, neighbour);
                for (MapElementContainer element : after) {
                    this.tileDependencies.addOverlappingElement(renderContext.rendererJob.tile, neighbour, element);
                }
                for (TileRefresher tileRefresher : this.tileRefreshers) {
                    tileRefresher.refresh(neighbour);
                }
            }
            return labelsToDraw;
        }
    }

    public static interface TileRefresher {
        public void refresh(Tile var1);
    }
}

