/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.renderer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.Color;
import org.mapsforge.core.graphics.Curve;
import org.mapsforge.core.graphics.Filter;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.GraphicUtils;
import org.mapsforge.core.graphics.Matrix;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.graphics.Path;
import org.mapsforge.core.mapelements.MapElementContainer;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Rectangle;
import org.mapsforge.core.model.Tile;
import org.mapsforge.core.util.Parameters;
import org.mapsforge.map.layer.renderer.CircleContainer;
import org.mapsforge.map.layer.renderer.HillshadingContainer;
import org.mapsforge.map.layer.renderer.PolylineContainer;
import org.mapsforge.map.layer.renderer.RendererUtils;
import org.mapsforge.map.layer.renderer.ShapeContainer;
import org.mapsforge.map.layer.renderer.ShapePaintContainer;
import org.mapsforge.map.layer.renderer.ShapeType;
import org.mapsforge.map.rendertheme.RenderContext;

public class CanvasRasterer {
    private final Canvas canvas;
    private final Path path;
    private final Matrix symbolMatrix;

    public CanvasRasterer(GraphicFactory graphicFactory) {
        this.canvas = graphicFactory.createCanvas();
        this.path = graphicFactory.createPath();
        this.symbolMatrix = graphicFactory.createMatrix();
    }

    public void destroy() {
        this.canvas.destroy();
    }

    void drawWays(RenderContext renderContext) {
        int levelsPerLayer = renderContext.ways.get(0).size();
        int layers = renderContext.ways.size();
        for (int layer = 0; layer < layers; ++layer) {
            List<List<ShapePaintContainer>> shapePaintContainers = renderContext.ways.get(layer);
            for (int level = 0; level < levelsPerLayer; ++level) {
                List<ShapePaintContainer> wayList = shapePaintContainers.get(level);
                for (int index = wayList.size() - 1; index >= 0; --index) {
                    this.drawShapePaintContainer(renderContext, wayList.get(index));
                }
            }
        }
    }

    void drawMapElements(Set<MapElementContainer> elements, Tile tile) {
        ArrayList<MapElementContainer> elementsAsList = new ArrayList<MapElementContainer>(elements);
        Collections.sort(elementsAsList);
        for (MapElementContainer element : elementsAsList) {
            element.draw(this.canvas, tile.getOrigin(), this.symbolMatrix, Filter.NONE);
        }
    }

    void fill(int color) {
        if (GraphicUtils.getAlpha((int)color) > 0) {
            this.canvas.fillColor(color);
        }
    }

    void fillOutsideAreas(Color color, Rectangle insideArea) {
        this.canvas.setClipDifference((int)insideArea.left, (int)insideArea.top, (int)insideArea.getWidth(), (int)insideArea.getHeight());
        this.canvas.fillColor(color);
        this.canvas.resetClip();
    }

    void fillOutsideAreas(int color, Rectangle insideArea) {
        this.canvas.setClipDifference((int)insideArea.left, (int)insideArea.top, (int)insideArea.getWidth(), (int)insideArea.getHeight());
        this.canvas.fillColor(color);
        this.canvas.resetClip();
    }

    void setCanvasBitmap(Bitmap bitmap) {
        this.canvas.setBitmap(bitmap);
    }

    private void drawCircleContainer(ShapePaintContainer shapePaintContainer) {
        CircleContainer circleContainer = (CircleContainer)shapePaintContainer.shapeContainer;
        Point point = circleContainer.point;
        this.canvas.drawCircle((int)point.x, (int)point.y, (int)circleContainer.radius, shapePaintContainer.paint);
    }

    private void drawHillshading(HillshadingContainer container) {
        this.canvas.shadeBitmap(container.bitmap, container.hillsRect, container.tileRect, container.magnitude);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawPath(RenderContext renderContext, ShapePaintContainer shapePaintContainer, Point[][] coordinates, float dy) {
        this.path.clear();
        for (Point[] innerList : coordinates) {
            Point[] points = dy != 0.0f ? RendererUtils.parallelPath(innerList, dy) : innerList;
            if (points.length < 2) continue;
            if (shapePaintContainer.curveStyle == Curve.CUBIC) {
                float[] p1 = new float[]{(float)points[0].x, (float)points[0].y};
                float[] p2 = new float[]{0.0f, 0.0f};
                float[] p3 = new float[]{0.0f, 0.0f};
                this.path.moveTo(p1[0], p1[1]);
                for (int i = 1; i < points.length; ++i) {
                    p3[0] = (float)points[i].x;
                    p3[1] = (float)points[i].y;
                    p2[0] = (p1[0] + p3[0]) / 2.0f;
                    p2[1] = (p1[1] + p3[1]) / 2.0f;
                    this.path.quadTo(p1[0], p1[1], p2[0], p2[1]);
                    p1[0] = p3[0];
                    p1[1] = p3[1];
                }
                this.path.quadTo(p2[0], p2[1], p3[0], p3[1]);
                continue;
            }
            this.path.moveTo((float)points[0].x, (float)points[0].y);
            for (int i = 1; i < points.length; ++i) {
                this.path.lineTo((float)((int)points[i].x), (float)((int)points[i].y));
            }
        }
        if (Parameters.NUMBER_OF_THREADS > 1) {
            Paint paint = shapePaintContainer.paint;
            synchronized (paint) {
                shapePaintContainer.paint.setBitmapShaderShift(renderContext.rendererJob.tile.getOrigin());
                this.canvas.drawPath(this.path, shapePaintContainer.paint);
            }
        } else {
            this.canvas.drawPath(this.path, shapePaintContainer.paint);
        }
    }

    private void drawShapePaintContainer(RenderContext renderContext, ShapePaintContainer shapePaintContainer) {
        ShapeContainer shapeContainer = shapePaintContainer.shapeContainer;
        ShapeType shapeType = shapeContainer.getShapeType();
        switch (shapeType) {
            case CIRCLE: {
                this.drawCircleContainer(shapePaintContainer);
                break;
            }
            case HILLSHADING: {
                HillshadingContainer hillshadingContainer = (HillshadingContainer)shapeContainer;
                this.drawHillshading(hillshadingContainer);
                break;
            }
            case POLYLINE: {
                PolylineContainer polylineContainer = (PolylineContainer)shapeContainer;
                this.drawPath(renderContext, shapePaintContainer, polylineContainer.getCoordinatesRelativeToOrigin(), shapePaintContainer.dy);
            }
        }
    }
}

