/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.overlay;

import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Rectangle;
import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.map.layer.Layer;

public class Marker
extends Layer {
    private Bitmap bitmap;
    private int horizontalOffset;
    private LatLong latLong;
    private int verticalOffset;

    public Marker(LatLong latLong, Bitmap bitmap, int horizontalOffset, int verticalOffset) {
        this.latLong = latLong;
        this.bitmap = bitmap;
        this.horizontalOffset = horizontalOffset;
        this.verticalOffset = verticalOffset;
    }

    public synchronized boolean contains(Point center, Point point) {
        double width = Math.max(20.0f * this.displayModel.getScaleFactor(), (float)this.bitmap.getWidth());
        double height = Math.max(20.0f * this.displayModel.getScaleFactor(), (float)this.bitmap.getHeight());
        Rectangle r = new Rectangle(center.x - width / 2.0 + (double)this.horizontalOffset, center.y - height / 2.0 + (double)this.verticalOffset, center.x + width / 2.0 + (double)this.horizontalOffset, center.y + height / 2.0 + (double)this.verticalOffset);
        return r.contains(point);
    }

    @Override
    public synchronized void draw(BoundingBox boundingBox, byte zoomLevel, Canvas canvas, Point topLeftPoint) {
        if (this.latLong == null || this.bitmap == null || this.bitmap.isDestroyed()) {
            return;
        }
        long mapSize = MercatorProjection.getMapSize((byte)zoomLevel, (int)this.displayModel.getTileSize());
        double pixelX = MercatorProjection.longitudeToPixelX((double)this.latLong.longitude, (long)mapSize);
        double pixelY = MercatorProjection.latitudeToPixelY((double)this.latLong.latitude, (long)mapSize);
        int halfBitmapWidth = this.bitmap.getWidth() / 2;
        int halfBitmapHeight = this.bitmap.getHeight() / 2;
        int left = (int)(pixelX - topLeftPoint.x - (double)halfBitmapWidth + (double)this.horizontalOffset);
        int top = (int)(pixelY - topLeftPoint.y - (double)halfBitmapHeight + (double)this.verticalOffset);
        int right = left + this.bitmap.getWidth();
        int bottom = top + this.bitmap.getHeight();
        Rectangle bitmapRectangle = new Rectangle((double)left, (double)top, (double)right, (double)bottom);
        Rectangle canvasRectangle = new Rectangle(0.0, 0.0, (double)canvas.getWidth(), (double)canvas.getHeight());
        if (!canvasRectangle.intersects(bitmapRectangle)) {
            return;
        }
        canvas.drawBitmap(this.bitmap, left, top);
    }

    public synchronized Bitmap getBitmap() {
        return this.bitmap;
    }

    public synchronized int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public synchronized LatLong getLatLong() {
        return this.latLong;
    }

    @Override
    public synchronized LatLong getPosition() {
        return this.latLong;
    }

    public synchronized int getVerticalOffset() {
        return this.verticalOffset;
    }

    @Override
    public synchronized void onDestroy() {
        if (this.bitmap != null) {
            this.bitmap.decrementRefCount();
        }
    }

    public synchronized void setBitmap(Bitmap bitmap) {
        if (this.bitmap != null && this.bitmap.equals(bitmap)) {
            return;
        }
        if (this.bitmap != null) {
            this.bitmap.decrementRefCount();
        }
        this.bitmap = bitmap;
    }

    public synchronized void setHorizontalOffset(int horizontalOffset) {
        this.horizontalOffset = horizontalOffset;
    }

    public synchronized void setLatLong(LatLong latLong) {
        this.latLong = latLong;
    }

    public synchronized void setVerticalOffset(int verticalOffset) {
        this.verticalOffset = verticalOffset;
    }
}

