/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.hills;

import org.mapsforge.core.graphics.HillshadingBitmap;
import org.mapsforge.map.layer.hills.DemFile;
import org.mapsforge.map.layer.hills.HgtCache;

public interface ShadingAlgorithm {
    public int getAxisLenght(HgtCache.HgtFileInfo var1);

    public RawShadingResult transformToByteBuffer(HgtCache.HgtFileInfo var1, int var2);

    public static interface RawHillTileSource {
        public long getSize();

        public DemFile getFile();

        public HillshadingBitmap getFinishedConverted();

        public double northLat();

        public double southLat();

        public double westLng();

        public double eastLng();
    }

    public static class RawShadingResult {
        public final byte[] bytes;
        public final int width;
        public final int height;
        public final int padding;

        public RawShadingResult(byte[] bytes, int width, int height, int padding) {
            this.bytes = bytes;
            this.width = width;
            this.height = height;
            this.padding = padding;
        }

        void fillPadding(HillshadingBitmap.Border side) {
            int sourceOuterStep;
            int sourceInnerStep;
            int sourceOffset;
            int start;
            int outersteps;
            int skip;
            int innersteps;
            int lineLen = this.padding * 2 + this.width;
            if (side.vertical) {
                innersteps = this.padding;
                skip = this.width + this.padding;
                outersteps = this.height;
                if (side == HillshadingBitmap.Border.WEST) {
                    start = this.padding * lineLen;
                    sourceOffset = start + this.padding;
                } else {
                    start = this.padding * lineLen + this.padding + this.width;
                    sourceOffset = start - 1;
                }
                sourceInnerStep = 0;
                sourceOuterStep = lineLen;
            } else {
                innersteps = this.width;
                skip = 2 * this.padding;
                outersteps = this.padding;
                if (side == HillshadingBitmap.Border.NORTH) {
                    start = this.padding;
                    sourceOffset = start + this.padding * lineLen;
                } else {
                    start = (this.height + this.padding) * lineLen + this.padding;
                    sourceOffset = start - lineLen;
                }
                sourceInnerStep = 1;
                sourceOuterStep = -this.width;
            }
            int dest = start;
            int src = sourceOffset;
            for (int o = 0; o < outersteps; ++o) {
                for (int i = 0; i < innersteps; ++i) {
                    this.bytes[dest] = this.bytes[src];
                    ++dest;
                    src += sourceInnerStep;
                }
                dest += skip;
                src += sourceOuterStep;
            }
        }

        public void fillPadding() {
            if (this.padding < 1) {
                return;
            }
            this.fillPadding(HillshadingBitmap.Border.EAST);
            this.fillPadding(HillshadingBitmap.Border.WEST);
            this.fillPadding(HillshadingBitmap.Border.NORTH);
            this.fillPadding(HillshadingBitmap.Border.SOUTH);
            int lineLen = this.padding * 2 + this.width;
            int widthOncePadded = this.width + this.padding;
            int heightOncePadded = this.height + this.padding;
            byte nw = this.bytes[lineLen * this.padding + this.padding];
            byte ne = this.bytes[lineLen * this.padding + widthOncePadded - 1];
            byte se = this.bytes[lineLen * (heightOncePadded - 1) + this.padding];
            byte sw = this.bytes[lineLen * (heightOncePadded - 1) + (widthOncePadded - 1)];
            int seOffset = lineLen * heightOncePadded;
            int swOffset = seOffset + widthOncePadded;
            for (int y = 0; y < this.padding; ++y) {
                int yoff = lineLen * y;
                for (int x = 0; x < this.padding; ++x) {
                    this.bytes[x + yoff] = nw;
                    this.bytes[x + yoff + widthOncePadded] = ne;
                    this.bytes[x + yoff + seOffset] = se;
                    this.bytes[x + yoff + swOffset] = sw;
                }
            }
        }
    }
}

