/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.download.tilesource;

import java.net.MalformedURLException;
import java.net.URL;
import org.mapsforge.core.model.Tile;
import org.mapsforge.map.layer.download.tilesource.AbstractTileSource;

public class OnlineTileSource
extends AbstractTileSource {
    private boolean alpha = false;
    private float alphaValue = 1.0f;
    private String baseUrl = "/";
    private String extension = "png";
    private String name;
    private int parallelRequestsLimit = 8;
    private String protocol = "http";
    private int tileSize = 256;
    private byte zoomLevelMax = (byte)18;
    private byte zoomLevelMin = 0;

    public OnlineTileSource(String[] hostNames, int port) {
        super(hostNames, port);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OnlineTileSource)) {
            return false;
        }
        OnlineTileSource other = (OnlineTileSource)obj;
        return this.baseUrl.equals(other.baseUrl);
    }

    public float getAlphaValue() {
        return this.alphaValue;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getParallelRequestsLimit() {
        return this.parallelRequestsLimit;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getTileSize() {
        return this.tileSize;
    }

    @Override
    public URL getTileUrl(Tile tile) throws MalformedURLException {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(this.baseUrl);
        stringBuilder.append(tile.zoomLevel);
        stringBuilder.append('/');
        stringBuilder.append(tile.tileX);
        stringBuilder.append('/');
        stringBuilder.append(tile.tileY);
        stringBuilder.append('.').append(this.extension);
        if (this.apiKey != null) {
            stringBuilder.append('?').append(this.keyName).append("=").append(this.apiKey);
        }
        return new URL(this.protocol, this.getHostName(), this.port, stringBuilder.toString());
    }

    @Override
    public byte getZoomLevelMax() {
        return this.zoomLevelMax;
    }

    @Override
    public byte getZoomLevelMin() {
        return this.zoomLevelMin;
    }

    @Override
    public boolean hasAlpha() {
        return this.alpha;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.baseUrl.hashCode();
        return result;
    }

    public OnlineTileSource setAlpha(boolean alpha) {
        this.alpha = alpha;
        return this;
    }

    public OnlineTileSource setAlphaValue(float alphaValue) {
        this.alphaValue = Math.max(0.0f, Math.min(1.0f, alphaValue));
        return this;
    }

    public OnlineTileSource setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public OnlineTileSource setExtension(String extension) {
        this.extension = extension;
        return this;
    }

    public OnlineTileSource setName(String name) {
        this.name = name;
        return this;
    }

    public OnlineTileSource setParallelRequestsLimit(int parallelRequestsLimit) {
        this.parallelRequestsLimit = parallelRequestsLimit;
        return this;
    }

    public OnlineTileSource setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public OnlineTileSource setTileSize(int tileSize) {
        this.tileSize = tileSize;
        return this;
    }

    public OnlineTileSource setZoomLevelMax(byte zoomLevelMax) {
        this.zoomLevelMax = zoomLevelMax;
        return this;
    }

    public OnlineTileSource setZoomLevelMin(byte zoomLevelMin) {
        this.zoomLevelMin = zoomLevelMin;
        return this;
    }
}

