/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer;

import java.util.ArrayList;
import java.util.List;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.Point;
import org.mapsforge.map.layer.Layer;
import org.mapsforge.map.model.DisplayModel;

public class GroupLayer
extends Layer {
    public final List<Layer> layers = new ArrayList<Layer>();

    @Override
    public void draw(BoundingBox boundingBox, byte zoomLevel, Canvas canvas, Point topLeftPoint) {
        for (Layer layer : this.layers) {
            layer.draw(boundingBox, zoomLevel, canvas, topLeftPoint);
        }
    }

    @Override
    public void onDestroy() {
        for (Layer layer : this.layers) {
            layer.onDestroy();
        }
    }

    @Override
    public boolean onLongPress(LatLong tapLatLong, Point layerXY, Point tapXY) {
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            Layer layer = this.layers.get(i);
            if (!layer.onLongPress(tapLatLong, layerXY, tapXY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onTap(LatLong tapLatLong, Point layerXY, Point tapXY) {
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            Layer layer = this.layers.get(i);
            if (!layer.onTap(tapLatLong, layerXY, tapXY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void setDisplayModel(DisplayModel displayModel) {
        super.setDisplayModel(displayModel);
        for (Layer layer : this.layers) {
            layer.setDisplayModel(displayModel);
        }
    }
}

