/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.view;

import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.GraphicContext;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Matrix;
import org.mapsforge.core.model.Dimension;
import org.mapsforge.core.model.MapPosition;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.model.FrameBufferModel;
import org.mapsforge.map.view.FrameBufferBitmap;
import org.mapsforge.map.view.FrameBufferOld;

public class FrameBufferHA2
extends FrameBufferOld {
    private final FrameBufferBitmap lmBitmap = new FrameBufferBitmap();
    private final FrameBufferBitmap odBitmap = new FrameBufferBitmap();
    private final FrameBufferBitmap.Lock allowSwap = new FrameBufferBitmap.Lock();
    private MapPosition lmMapPosition;

    public FrameBufferHA2(FrameBufferModel frameBufferModel, DisplayModel displayModel, GraphicFactory graphicFactory) {
        super(frameBufferModel, displayModel, graphicFactory);
        this.allowSwap.disable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustMatrix(float diffX, float diffY, float scaleFactor, Dimension mapViewDimension, float pivotDistanceX, float pivotDistanceY) {
        Matrix matrix = this.matrix;
        synchronized (matrix) {
            if (this.dimension == null) {
                return;
            }
            this.matrix.reset();
            this.centerFrameBufferToMapView(mapViewDimension);
            if (pivotDistanceX == 0.0f && pivotDistanceY == 0.0f) {
                this.matrix.translate(diffX, diffY);
            }
            this.scale(scaleFactor, pivotDistanceX, pivotDistanceY);
        }
    }

    @Override
    public synchronized void destroy() {
        this.odBitmap.destroy();
        this.lmBitmap.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(GraphicContext graphicContext) {
        graphicContext.fillColor(this.displayModel.getBackgroundColor());
        this.swapBitmaps();
        Matrix matrix = this.matrix;
        synchronized (matrix) {
            Bitmap b = this.odBitmap.lock();
            if (b != null) {
                graphicContext.drawBitmap(b, this.matrix);
            }
        }
        this.odBitmap.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void frameFinished(MapPosition framePosition) {
        FrameBufferBitmap.Lock lock = this.allowSwap;
        synchronized (lock) {
            this.lmMapPosition = framePosition;
            this.lmBitmap.release();
            this.allowSwap.enable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap getDrawingBitmap() {
        FrameBufferBitmap.Lock lock = this.allowSwap;
        synchronized (lock) {
            this.allowSwap.waitDisabled();
            Bitmap b = this.lmBitmap.lock();
            if (b != null) {
                b.setBackgroundColor(this.displayModel.getBackgroundColor());
            }
            return b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDimension(Dimension dimension) {
        Object object = this.matrix;
        synchronized (object) {
            if (this.dimension != null && this.dimension.equals((Object)dimension)) {
                return;
            }
            this.dimension = dimension;
        }
        object = this.allowSwap;
        synchronized (object) {
            this.odBitmap.create(this.graphicFactory, dimension, this.displayModel.getBackgroundColor(), false);
            this.lmBitmap.create(this.graphicFactory, dimension, this.displayModel.getBackgroundColor(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapBitmaps() {
        FrameBufferBitmap.Lock lock = this.allowSwap;
        synchronized (lock) {
            if (this.allowSwap.isEnabled()) {
                FrameBufferBitmap.swap(this.odBitmap, this.lmBitmap);
                this.frameBufferModel.setMapPosition(this.lmMapPosition);
                this.allowSwap.disable();
            }
        }
    }
}

