/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.view;

import java.util.logging.Logger;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.model.Dimension;

class FrameBufferBitmap {
    private static final Logger LOGGER = Logger.getLogger(FrameBufferBitmap.class.getName());
    private Bitmap bitmap = null;
    private BitmapRequest bitmapRequest = null;
    private final Object bitmapRequestSync = new Object();
    private final Lock frameLock = new Lock();

    FrameBufferBitmap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void create(GraphicFactory factory, Dimension dimension, int color, boolean isTransparent) {
        Object object = this.bitmapRequestSync;
        synchronized (object) {
            this.bitmapRequest = new BitmapRequest(factory, dimension, color, isTransparent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBitmapIfRequested() {
        Object object = this.bitmapRequestSync;
        synchronized (object) {
            if (this.bitmapRequest != null) {
                this.destroyBitmap();
                this.bitmap = this.bitmapRequest.create();
                this.bitmapRequest = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        Lock lock = this.frameLock;
        synchronized (lock) {
            if (this.bitmap != null) {
                this.frameLock.waitDisabled();
                this.destroyBitmap();
            }
        }
    }

    private void destroyBitmap() {
        if (this.bitmap != null) {
            this.bitmap.decrementRefCount();
            this.bitmap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bitmap lock() {
        Lock lock = this.frameLock;
        synchronized (lock) {
            this.createBitmapIfRequested();
            if (this.bitmap != null) {
                this.frameLock.enable();
            }
            return this.bitmap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release() {
        Lock lock = this.frameLock;
        synchronized (lock) {
            this.frameLock.disable();
        }
    }

    static void swap(FrameBufferBitmap a, FrameBufferBitmap b) {
        Bitmap t = a.bitmap;
        a.bitmap = b.bitmap;
        b.bitmap = t;
        BitmapRequest r = a.bitmapRequest;
        a.bitmapRequest = b.bitmapRequest;
        b.bitmapRequest = r;
    }

    private static class BitmapRequest {
        private final GraphicFactory factory;
        private final Dimension dimension;
        private final int color;
        private final boolean isTransparent;

        BitmapRequest(GraphicFactory factory, Dimension dimension, int color, boolean isTransparent) {
            this.factory = factory;
            this.dimension = dimension;
            this.color = color;
            this.isTransparent = isTransparent;
        }

        Bitmap create() {
            if (this.dimension.width > 0 && this.dimension.height > 0) {
                Bitmap bitmap = this.factory.createBitmap(this.dimension.width, this.dimension.height, this.isTransparent);
                bitmap.setBackgroundColor(this.color);
                return bitmap;
            }
            return null;
        }
    }

    static class Lock {
        private boolean enabled = false;

        Lock() {
        }

        synchronized void disable() {
            this.enabled = false;
            this.notifyAll();
        }

        synchronized void enable() {
            this.enabled = true;
        }

        boolean isEnabled() {
            return this.enabled;
        }

        synchronized void waitDisabled() {
            try {
                while (this.enabled) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                LOGGER.fine("Frame buffer interrupted");
            }
        }
    }
}

