/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme.renderinstruction;

import java.io.IOException;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Display;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Position;
import org.mapsforge.core.model.Rectangle;
import org.mapsforge.map.datastore.PointOfInterest;
import org.mapsforge.map.layer.renderer.PolylineContainer;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.rendertheme.RenderCallback;
import org.mapsforge.map.rendertheme.RenderContext;
import org.mapsforge.map.rendertheme.XmlThemeResourceProvider;
import org.mapsforge.map.rendertheme.XmlUtils;
import org.mapsforge.map.rendertheme.renderinstruction.RenderInstruction;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class Symbol
extends RenderInstruction {
    private Bitmap bitmap;
    private boolean bitmapInvalid;
    private Rectangle boundary;
    private Display display;
    private String id;
    private Position position;
    private int priority;
    private final String relativePathPrefix;
    private final XmlThemeResourceProvider resourceProvider;
    private String src;

    public Symbol(GraphicFactory graphicFactory, DisplayModel displayModel, String elementName, XmlPullParser pullParser, String relativePathPrefix, XmlThemeResourceProvider resourceProvider) throws IOException, XmlPullParserException {
        super(graphicFactory, displayModel);
        this.relativePathPrefix = relativePathPrefix;
        this.resourceProvider = resourceProvider;
        this.display = Display.IFSPACE;
        this.position = Position.CENTER;
        this.extractValues(elementName, pullParser);
        Bitmap bitmap = this.getBitmap();
        if (bitmap != null) {
            this.boundary = this.computeBoundary(bitmap.getWidth(), bitmap.getHeight(), this.position);
        }
    }

    @Override
    public void destroy() {
        if (this.bitmap != null) {
            this.bitmap.decrementRefCount();
        }
    }

    private void extractValues(String elementName, XmlPullParser pullParser) throws IOException, XmlPullParserException {
        for (int i = 0; i < pullParser.getAttributeCount(); ++i) {
            String name = pullParser.getAttributeName(i);
            String value = pullParser.getAttributeValue(i);
            if ("src".equals(name)) {
                this.src = value;
                continue;
            }
            if ("cat".equals(name)) {
                this.category = value;
                continue;
            }
            if ("display".equals(name)) {
                this.display = Display.fromString((String)value);
                continue;
            }
            if ("id".equals(name)) {
                this.id = value;
                continue;
            }
            if ("priority".equals(name)) {
                this.priority = Integer.parseInt(value);
                continue;
            }
            if ("symbol-height".equals(name)) {
                this.height = (float)XmlUtils.parseNonNegativeInteger(name, value) * this.displayModel.getScaleFactor();
                continue;
            }
            if ("symbol-percent".equals(name)) {
                this.percent = XmlUtils.parseNonNegativeInteger(name, value);
                continue;
            }
            if ("symbol-scaling".equals(name)) continue;
            if ("symbol-width".equals(name)) {
                this.width = (float)XmlUtils.parseNonNegativeInteger(name, value) * this.displayModel.getScaleFactor();
                continue;
            }
            if ("position".equals(name)) {
                this.position = Position.fromString((String)value);
                continue;
            }
            XmlUtils.logUnknownAttribute(elementName, name, value, i);
        }
    }

    public Bitmap getBitmap() {
        if (this.bitmap == null && !this.bitmapInvalid) {
            try {
                this.bitmap = this.createBitmap(this.relativePathPrefix, this.src, this.resourceProvider);
            }
            catch (IOException ioException) {
                this.bitmapInvalid = true;
            }
        }
        return this.bitmap;
    }

    public Rectangle getBoundary() {
        return this.boundary;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void renderNode(RenderCallback renderCallback, RenderContext renderContext, PointOfInterest poi) {
        if (Display.NEVER == this.display) {
            return;
        }
        if (this.getBitmap() != null) {
            renderCallback.renderPointOfInterestSymbol(renderContext, this.display, this.priority, this.boundary, this.bitmap, poi);
        }
    }

    @Override
    public void renderWay(RenderCallback renderCallback, RenderContext renderContext, PolylineContainer way) {
        if (Display.NEVER == this.display) {
            return;
        }
        if (this.getBitmap() != null) {
            renderCallback.renderAreaSymbol(renderContext, this.display, this.priority, this.bitmap, way);
        }
    }

    @Override
    public void scaleStrokeWidth(float scaleFactor, byte zoomLevel) {
    }

    @Override
    public void scaleTextSize(float scaleFactor, byte zoomLevel) {
    }
}

