/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.renderer;

import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.TileBitmap;
import org.mapsforge.core.model.Tile;
import org.mapsforge.map.datastore.MapDataStore;
import org.mapsforge.map.layer.TileLayer;
import org.mapsforge.map.layer.cache.TileCache;
import org.mapsforge.map.layer.hills.HillsRenderConfig;
import org.mapsforge.map.layer.labels.LabelStore;
import org.mapsforge.map.layer.labels.TileBasedLabelStore;
import org.mapsforge.map.layer.renderer.DatabaseRenderer;
import org.mapsforge.map.layer.renderer.MapWorkerPool;
import org.mapsforge.map.layer.renderer.RendererJob;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.model.IMapViewPosition;
import org.mapsforge.map.model.common.Observer;
import org.mapsforge.map.rendertheme.XmlRenderTheme;
import org.mapsforge.map.rendertheme.rule.RenderThemeFuture;

public class TileRendererLayer
extends TileLayer<RendererJob>
implements Observer {
    private final DatabaseRenderer databaseRenderer;
    private final GraphicFactory graphicFactory;
    private final MapDataStore mapDataStore;
    private MapWorkerPool mapWorkerPool;
    private RenderThemeFuture renderThemeFuture;
    private float textScale;
    private final TileBasedLabelStore tileBasedLabelStore;
    private XmlRenderTheme xmlRenderTheme;

    public TileRendererLayer(TileCache tileCache, MapDataStore mapDataStore, IMapViewPosition mapViewPosition, GraphicFactory graphicFactory) {
        this(tileCache, mapDataStore, mapViewPosition, false, true, false, graphicFactory);
    }

    public TileRendererLayer(TileCache tileCache, MapDataStore mapDataStore, IMapViewPosition mapViewPosition, boolean isTransparent, boolean renderLabels, boolean cacheLabels, GraphicFactory graphicFactory) {
        this(tileCache, mapDataStore, mapViewPosition, isTransparent, renderLabels, cacheLabels, graphicFactory, null);
    }

    public TileRendererLayer(TileCache tileCache, MapDataStore mapDataStore, IMapViewPosition mapViewPosition, boolean isTransparent, boolean renderLabels, boolean cacheLabels, GraphicFactory graphicFactory, HillsRenderConfig hillsRenderConfig) {
        super(tileCache, mapViewPosition, graphicFactory.createMatrix(), isTransparent);
        this.graphicFactory = graphicFactory;
        this.mapDataStore = mapDataStore;
        this.tileBasedLabelStore = cacheLabels ? new TileBasedLabelStore(tileCache.getCapacityFirstLevel()) : null;
        this.databaseRenderer = new DatabaseRenderer(this.mapDataStore, graphicFactory, tileCache, this.tileBasedLabelStore, renderLabels, cacheLabels, hillsRenderConfig);
        this.textScale = 1.0f;
    }

    public LabelStore getLabelStore() {
        return this.tileBasedLabelStore;
    }

    public MapDataStore getMapDataStore() {
        return this.mapDataStore;
    }

    public float getTextScale() {
        return this.textScale;
    }

    @Override
    public void onDestroy() {
        if (this.renderThemeFuture != null) {
            this.renderThemeFuture.decrementRefCount();
        }
        this.mapDataStore.close();
        super.onDestroy();
    }

    @Override
    public synchronized void setDisplayModel(DisplayModel displayModel) {
        super.setDisplayModel(displayModel);
        if (displayModel != null) {
            this.compileRenderTheme();
            if (this.mapWorkerPool == null) {
                this.mapWorkerPool = new MapWorkerPool(this.tileCache, this.jobQueue, this.databaseRenderer, this);
            }
            this.mapWorkerPool.start();
        } else if (this.mapWorkerPool != null) {
            this.mapWorkerPool.stop();
        }
    }

    public void setTextScale(float textScale) {
        this.textScale = textScale;
    }

    public void setXmlRenderTheme(XmlRenderTheme xmlRenderTheme) {
        this.xmlRenderTheme = xmlRenderTheme;
        this.compileRenderTheme();
    }

    protected void compileRenderTheme() {
        this.renderThemeFuture = new RenderThemeFuture(this.graphicFactory, this.xmlRenderTheme, this.displayModel);
        new Thread(this.renderThemeFuture).start();
    }

    public RenderThemeFuture getRenderThemeFuture() {
        return this.renderThemeFuture;
    }

    @Override
    protected RendererJob createJob(Tile tile) {
        return new RendererJob(tile, this.mapDataStore, this.renderThemeFuture, this.displayModel, this.textScale, this.isTransparent, false);
    }

    @Override
    protected boolean isTileStale(Tile tile, TileBitmap bitmap) {
        return this.mapDataStore.getDataTimestamp(tile) > bitmap.getTimestamp();
    }

    @Override
    protected void onAdd() {
        this.mapWorkerPool.start();
        if (this.tileCache != null) {
            this.tileCache.addObserver(this);
        }
        super.onAdd();
    }

    @Override
    protected void onRemove() {
        this.mapWorkerPool.stop();
        if (this.tileCache != null) {
            this.tileCache.removeObserver(this);
        }
        super.onRemove();
    }

    @Override
    protected void retrieveLabelsOnly(RendererJob job) {
        if (this.hasJobQueue && this.tileBasedLabelStore != null && this.tileBasedLabelStore.requiresTile(job.tile)) {
            job.setRetrieveLabelsOnly();
            this.jobQueue.add(job);
        }
    }

    @Override
    public void onChange() {
        this.requestRedraw();
    }
}

