/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.overlay;

import java.text.DecimalFormat;
import java.util.Map;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.Color;
import org.mapsforge.core.graphics.FontFamily;
import org.mapsforge.core.graphics.FontStyle;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.graphics.Style;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.map.layer.Layer;
import org.mapsforge.map.model.DisplayModel;

public class Grid
extends Layer {
    private final Paint lineBack;
    private final Paint lineFront;
    private final Paint textBack;
    private final Paint textFront;
    private final Map<Byte, Double> spacingConfig;

    private static String convertCoordinate(double coordinate) {
        StringBuilder sb = new StringBuilder();
        if (coordinate < 0.0) {
            sb.append('-');
            coordinate = -coordinate;
        }
        DecimalFormat df = new DecimalFormat("00");
        int degrees = (int)Math.floor(coordinate);
        sb.append(df.format(degrees));
        sb.append('\u00b0');
        coordinate -= (double)degrees;
        int minutes = (int)Math.floor(coordinate *= 60.0);
        sb.append(df.format(minutes));
        sb.append('\u2032');
        coordinate -= (double)minutes;
        sb.append(df.format(coordinate *= 60.0));
        sb.append('\u2033');
        return sb.toString();
    }

    private static Paint createLineFront(GraphicFactory graphicFactory, DisplayModel displayModel) {
        Paint paint = graphicFactory.createPaint();
        paint.setColor(Color.BLUE);
        paint.setStrokeWidth(2.0f * displayModel.getScaleFactor());
        paint.setStyle(Style.STROKE);
        return paint;
    }

    private static Paint createLineBack(GraphicFactory graphicFactory, DisplayModel displayModel) {
        Paint paint = graphicFactory.createPaint();
        paint.setColor(Color.WHITE);
        paint.setStrokeWidth(4.0f * displayModel.getScaleFactor());
        paint.setStyle(Style.STROKE);
        return paint;
    }

    private static Paint createTextFront(GraphicFactory graphicFactory, DisplayModel displayModel) {
        Paint paint = graphicFactory.createPaint();
        paint.setColor(Color.BLUE);
        paint.setTypeface(FontFamily.DEFAULT, FontStyle.BOLD);
        paint.setTextSize(12.0f * displayModel.getScaleFactor());
        return paint;
    }

    private static Paint createTextBack(GraphicFactory graphicFactory, DisplayModel displayModel) {
        Paint paint = graphicFactory.createPaint();
        paint.setColor(Color.WHITE);
        paint.setTypeface(FontFamily.DEFAULT, FontStyle.BOLD);
        paint.setTextSize(12.0f * displayModel.getScaleFactor());
        paint.setStrokeWidth(4.0f * displayModel.getScaleFactor());
        paint.setStyle(Style.STROKE);
        return paint;
    }

    public Grid(GraphicFactory graphicFactory, DisplayModel displayModel, Map<Byte, Double> spacingConfig) {
        this.displayModel = displayModel;
        this.spacingConfig = spacingConfig;
        this.lineBack = Grid.createLineBack(graphicFactory, displayModel);
        this.lineFront = Grid.createLineFront(graphicFactory, displayModel);
        this.textBack = Grid.createTextBack(graphicFactory, displayModel);
        this.textFront = Grid.createTextFront(graphicFactory, displayModel);
    }

    public Grid(DisplayModel displayModel, Map<Byte, Double> spacingConfig, Paint lineBack, Paint lineFront, Paint textBack, Paint textFront) {
        this.displayModel = displayModel;
        this.spacingConfig = spacingConfig;
        this.lineBack = lineBack;
        this.lineFront = lineFront;
        this.textBack = textBack;
        this.textFront = textFront;
    }

    @Override
    public void draw(BoundingBox boundingBox, byte zoomLevel, Canvas canvas, Point topLeftPoint) {
        if (this.spacingConfig.containsKey(zoomLevel)) {
            int pixelY;
            int pixelX;
            int pixelX2;
            double longitude;
            int pixelY2;
            double latitude;
            double spacing = this.spacingConfig.get(zoomLevel);
            double minLongitude = spacing * Math.floor(boundingBox.minLongitude / spacing);
            double maxLongitude = spacing * Math.ceil(boundingBox.maxLongitude / spacing);
            double minLatitude = spacing * Math.floor(boundingBox.minLatitude / spacing);
            double maxLatitude = spacing * Math.ceil(boundingBox.maxLatitude / spacing);
            long mapSize = MercatorProjection.getMapSize((byte)zoomLevel, (int)this.displayModel.getTileSize());
            int bottom = (int)(MercatorProjection.latitudeToPixelY((double)minLatitude, (long)mapSize) - topLeftPoint.y);
            int top = (int)(MercatorProjection.latitudeToPixelY((double)maxLatitude, (long)mapSize) - topLeftPoint.y);
            int left = (int)(MercatorProjection.longitudeToPixelX((double)minLongitude, (long)mapSize) - topLeftPoint.x);
            int right = (int)(MercatorProjection.longitudeToPixelX((double)maxLongitude, (long)mapSize) - topLeftPoint.x);
            for (latitude = minLatitude; latitude <= maxLatitude; latitude += spacing) {
                pixelY2 = (int)(MercatorProjection.latitudeToPixelY((double)latitude, (long)mapSize) - topLeftPoint.y);
                canvas.drawLine(left, pixelY2, right, pixelY2, this.lineBack);
            }
            for (longitude = minLongitude; longitude <= maxLongitude; longitude += spacing) {
                pixelX2 = (int)(MercatorProjection.longitudeToPixelX((double)longitude, (long)mapSize) - topLeftPoint.x);
                canvas.drawLine(pixelX2, bottom, pixelX2, top, this.lineBack);
            }
            for (latitude = minLatitude; latitude <= maxLatitude; latitude += spacing) {
                pixelY2 = (int)(MercatorProjection.latitudeToPixelY((double)latitude, (long)mapSize) - topLeftPoint.y);
                canvas.drawLine(left, pixelY2, right, pixelY2, this.lineFront);
            }
            for (longitude = minLongitude; longitude <= maxLongitude; longitude += spacing) {
                pixelX2 = (int)(MercatorProjection.longitudeToPixelX((double)longitude, (long)mapSize) - topLeftPoint.x);
                canvas.drawLine(pixelX2, bottom, pixelX2, top, this.lineFront);
            }
            for (latitude = minLatitude; latitude <= maxLatitude; latitude += spacing) {
                String text = Grid.convertCoordinate(latitude);
                pixelX = (canvas.getWidth() - this.textFront.getTextWidth(text)) / 2;
                pixelY = (int)(MercatorProjection.latitudeToPixelY((double)latitude, (long)mapSize) - topLeftPoint.y) + this.textFront.getTextHeight(text) / 2;
                canvas.drawText(text, pixelX, pixelY, this.textBack);
                canvas.drawText(text, pixelX, pixelY, this.textFront);
            }
            for (longitude = minLongitude; longitude <= maxLongitude; longitude += spacing) {
                String text = Grid.convertCoordinate(longitude);
                pixelX = (int)(MercatorProjection.longitudeToPixelX((double)longitude, (long)mapSize) - topLeftPoint.x) - this.textFront.getTextWidth(text) / 2;
                pixelY = (canvas.getHeight() + this.textFront.getTextHeight(text)) / 2;
                canvas.drawText(text, pixelX, pixelY, this.textBack);
                canvas.drawText(text, pixelX, pixelY, this.textFront);
            }
        }
    }
}

