/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.labels;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.mapelements.MapElementContainer;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Tile;
import org.mapsforge.map.layer.labels.LabelLayer;
import org.mapsforge.map.layer.labels.LabelStore;
import org.mapsforge.map.util.LayerUtil;

public class ThreadedLabelLayer
extends LabelLayer {
    ExecutorService executorService = Executors.newSingleThreadExecutor();
    Future<?> future;
    Tile requestedUpperLeft;
    Tile requestedLowerRight;

    public ThreadedLabelLayer(GraphicFactory graphicFactory, LabelStore labelStore) {
        super(graphicFactory, labelStore);
    }

    @Override
    public void draw(BoundingBox boundingBox, byte zoomLevel, Canvas canvas, Point topLeftPoint) {
        Tile newUpperLeft = LayerUtil.getUpperLeft(boundingBox, zoomLevel, this.displayModel.getTileSize());
        Tile newLowerRight = LayerUtil.getLowerRight(boundingBox, zoomLevel, this.displayModel.getTileSize());
        if (!newUpperLeft.equals((Object)this.upperLeft) || !newLowerRight.equals((Object)this.lowerRight) || this.lastLabelStoreVersion != this.labelStore.getVersion()) {
            this.getData(newUpperLeft, newLowerRight);
        }
        if (this.upperLeft != null && Tile.tileAreasOverlap((Tile)this.upperLeft, (Tile)this.lowerRight, (Tile)newUpperLeft, (Tile)newLowerRight)) {
            this.draw(canvas, topLeftPoint);
        }
    }

    protected void getData(final Tile upperLeft, final Tile lowerRight) {
        if (upperLeft.equals((Object)this.requestedUpperLeft) && lowerRight.equals((Object)this.requestedLowerRight)) {
            return;
        }
        this.requestedUpperLeft = upperLeft;
        this.requestedLowerRight = lowerRight;
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.future = this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                List<MapElementContainer> visibleItems = ThreadedLabelLayer.this.labelStore.getVisibleItems(upperLeft, lowerRight);
                ThreadedLabelLayer.this.elementsToDraw = LayerUtil.collisionFreeOrdered(visibleItems);
                Collections.sort(ThreadedLabelLayer.this.elementsToDraw);
                ThreadedLabelLayer.this.upperLeft = upperLeft;
                ThreadedLabelLayer.this.lowerRight = lowerRight;
                ThreadedLabelLayer.this.lastLabelStoreVersion = ThreadedLabelLayer.this.labelStore.getVersion();
                ThreadedLabelLayer.this.requestRedraw();
            }
        });
    }

    @Override
    public void onDestroy() {
        this.executorService.shutdownNow();
    }
}

