/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.hills;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.HillshadingBitmap;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.map.layer.hills.DemFile;
import org.mapsforge.map.layer.hills.DemFolder;
import org.mapsforge.map.layer.hills.LazyFuture;
import org.mapsforge.map.layer.hills.ShadingAlgorithm;

class HgtCache {
    private static final Logger LOGGER = Logger.getLogger(HgtCache.class.getName());
    final DemFolder demFolder;
    final boolean interpolatorOverlap;
    final ShadingAlgorithm algorithm;
    final int mainCacheSize;
    final int neighborCacheSize;
    private final GraphicFactory graphicsFactory;
    private final Lru secondaryLru;
    private final Lru mainLru;
    private LazyFuture<Map<TileKey, HgtFileInfo>> hgtFiles;
    private List<String> problems = new ArrayList<String>();

    HgtCache(DemFolder demFolder, boolean interpolationOverlap, GraphicFactory graphicsFactory, ShadingAlgorithm algorithm, int mainCacheSize, int neighborCacheSize) {
        this.demFolder = demFolder;
        this.interpolatorOverlap = interpolationOverlap;
        this.graphicsFactory = graphicsFactory;
        this.algorithm = algorithm;
        this.mainCacheSize = mainCacheSize;
        this.neighborCacheSize = neighborCacheSize;
        this.mainLru = new Lru(this.mainCacheSize);
        this.secondaryLru = this.interpolatorOverlap ? new Lru(neighborCacheSize) : null;
        this.hgtFiles = new LazyFuture<Map<TileKey, HgtFileInfo>>(){

            @Override
            protected Map<TileKey, HgtFileInfo> calculate() {
                HashMap<TileKey, HgtFileInfo> map = new HashMap<TileKey, HgtFileInfo>();
                Matcher matcher = Pattern.compile("([ns])(\\d{1,2})([ew])(\\d{1,3})\\.(?:(hgt)|(zip))", 2).matcher("");
                this.crawl(HgtCache.this.demFolder, matcher, map, (List<String>)HgtCache.this.problems);
                return map;
            }

            void crawl(DemFile file, Matcher matcher, Map<TileKey, HgtFileInfo> map, List<String> problems) {
                String name = file.getName();
                if (matcher.reset(name).matches()) {
                    int northsouth = Integer.parseInt(matcher.group(2));
                    int eastwest = Integer.parseInt(matcher.group(4));
                    int north = "n".equals(matcher.group(1).toLowerCase()) ? northsouth : -northsouth;
                    int east = "e".equals(matcher.group(3).toLowerCase()) ? eastwest : -eastwest;
                    long length = 0L;
                    if (matcher.group(6) == null) {
                        length = file.getSize();
                    } else {
                        ZipInputStream zipInputStream = null;
                        try {
                            ZipEntry entry;
                            zipInputStream = new ZipInputStream(file.openInputStream());
                            String expectedHgt = name.toLowerCase().substring(0, name.length() - 4) + ".hgt";
                            while (null != (entry = zipInputStream.getNextEntry())) {
                                if (!expectedHgt.equals(entry.getName().toLowerCase())) continue;
                                length = entry.getSize();
                                break;
                            }
                        }
                        catch (IOException e) {
                            problems.add("could not read zip file " + file.getName());
                        }
                        if (zipInputStream != null) {
                            try {
                                zipInputStream.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    long heights = length / 2L;
                    long sqrt = (long)Math.sqrt(heights);
                    if (heights == 0L || sqrt * sqrt != heights) {
                        if (problems != null) {
                            problems.add(file + " length in shorts (" + heights + ") is not a square number");
                        }
                        return;
                    }
                    TileKey tileKey = new TileKey(north, east);
                    HgtFileInfo existing = map.get(tileKey);
                    if (existing == null || existing.size < length) {
                        map.put(tileKey, new HgtFileInfo(file, north - 1, east, north, east + 1, length));
                    }
                }
            }

            void crawl(DemFolder file, Matcher matcher, Map<TileKey, HgtFileInfo> map, List<String> problems) {
                for (DemFile demFile : file.files()) {
                    this.crawl(demFile, matcher, map, problems);
                }
                for (DemFolder sub : file.subs()) {
                    this.crawl(sub, matcher, map, problems);
                }
            }
        };
    }

    void indexOnThread() {
        this.hgtFiles.withRunningThread();
    }

    HillshadingBitmap getHillshadingBitmap(int northInt, int eastInt, double pxPerLat, double pxPerLng) throws InterruptedException, ExecutionException {
        HgtFileInfo hgtFileInfo = (HgtFileInfo)((Map)this.hgtFiles.get()).get(new TileKey(northInt, eastInt));
        if (hgtFileInfo == null) {
            return null;
        }
        Future<HillshadingBitmap> future = hgtFileInfo.getBitmapFuture(pxPerLat, pxPerLng);
        return future.get();
    }

    static void mergeSameSized(HillshadingBitmap center, HillshadingBitmap neighbor, HillshadingBitmap.Border border, int padding, Canvas copyCanvas) {
        if (border == HillshadingBitmap.Border.EAST) {
            HillshadingBitmap sink = center;
            HillshadingBitmap source = neighbor;
            copyCanvas.setBitmap((Bitmap)sink);
            copyCanvas.setClip(sink.getWidth() - padding, padding, padding, sink.getHeight() - 2 * padding, true);
            copyCanvas.drawBitmap((Bitmap)source, source.getWidth() - 2 * padding, 0);
        } else if (border == HillshadingBitmap.Border.WEST) {
            HillshadingBitmap sink = center;
            HillshadingBitmap source = neighbor;
            copyCanvas.setBitmap((Bitmap)sink);
            copyCanvas.setClip(0, padding, padding, sink.getHeight() - 2 * padding, true);
            copyCanvas.drawBitmap((Bitmap)source, 2 * padding - source.getWidth(), 0);
        } else if (border == HillshadingBitmap.Border.NORTH) {
            HillshadingBitmap sink = center;
            HillshadingBitmap source = neighbor;
            copyCanvas.setBitmap((Bitmap)sink);
            copyCanvas.setClip(padding, 0, sink.getWidth() - 2 * padding, padding, true);
            copyCanvas.drawBitmap((Bitmap)source, 0, 2 * padding - source.getHeight());
        } else if (border == HillshadingBitmap.Border.SOUTH) {
            HillshadingBitmap sink = center;
            HillshadingBitmap source = neighbor;
            copyCanvas.setBitmap((Bitmap)sink);
            copyCanvas.setClip(padding, sink.getHeight() - padding, sink.getWidth() - 2 * padding, padding, true);
            copyCanvas.drawBitmap((Bitmap)source, 0, source.getHeight() - 2 * padding);
        }
    }

    private static class Lru {
        private int size;
        private final LinkedHashSet<Future<HillshadingBitmap>> lru;

        public int getSize() {
            return this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSize(int size) {
            this.size = Math.max(0, size);
            if (size < this.lru.size()) {
                LinkedHashSet<Future<HillshadingBitmap>> linkedHashSet = this.lru;
                synchronized (linkedHashSet) {
                    Iterator iterator = this.lru.iterator();
                    while (this.lru.size() > size) {
                        iterator.remove();
                    }
                }
            }
        }

        Lru(int size) {
            this.size = size;
            this.lru = size > 0 ? new LinkedHashSet() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Future<HillshadingBitmap> markUsed(Future<HillshadingBitmap> freshlyUsed) {
            if (this.size > 0 && freshlyUsed != null) {
                LinkedHashSet<Future<HillshadingBitmap>> linkedHashSet = this.lru;
                synchronized (linkedHashSet) {
                    this.lru.remove(freshlyUsed);
                    this.lru.add(freshlyUsed);
                    if (this.lru.size() > this.size) {
                        Iterator iterator = this.lru.iterator();
                        Future evicted = (Future)iterator.next();
                        iterator.remove();
                        return evicted;
                    }
                    return null;
                }
            }
            return freshlyUsed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void evict(Future<HillshadingBitmap> loadingFuture) {
            if (this.size > 0) {
                LinkedHashSet<Future<HillshadingBitmap>> linkedHashSet = this.lru;
                synchronized (linkedHashSet) {
                    this.lru.add(loadingFuture);
                }
            }
        }
    }

    protected static final class TileKey {
        final int north;
        final int east;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TileKey tileKey = (TileKey)o;
            return this.north == tileKey.north && this.east == tileKey.east;
        }

        public int hashCode() {
            int result = this.north;
            result = 31 * result + this.east;
            return result;
        }

        TileKey(int north, int east) {
            this.east = east;
            this.north = north;
        }
    }

    class HgtFileInfo
    extends BoundingBox
    implements ShadingAlgorithm.RawHillTileSource {
        final DemFile file;
        WeakReference<Future<HillshadingBitmap>> weakRef;
        final long size;

        HgtFileInfo(DemFile file, double minLatitude, double minLongitude, double maxLatitude, double maxLongitude, long size) {
            super(minLatitude, minLongitude, maxLatitude, maxLongitude);
            this.weakRef = null;
            this.file = file;
            this.size = size;
        }

        Future<HillshadingBitmap> getBitmapFuture(double pxPerLat, double pxPerLng) {
            if (HgtCache.this.interpolatorOverlap) {
                int axisLen = HgtCache.this.algorithm.getAxisLenght(this);
                if (pxPerLat > (double)axisLen || pxPerLng > (double)axisLen) {
                    return this.getForHires();
                }
                return this.getForLores();
            }
            return this.getForLores();
        }

        private MergeOverlapFuture getForHires() {
            MergeOverlapFuture ret;
            Future candidate;
            WeakReference<Future<HillshadingBitmap>> weak = this.weakRef;
            Future future = candidate = weak == null ? null : (Future)weak.get();
            if (candidate instanceof MergeOverlapFuture) {
                ret = (MergeOverlapFuture)candidate;
            } else if (candidate instanceof LoadUnmergedFuture) {
                LoadUnmergedFuture loadFuture = (LoadUnmergedFuture)candidate;
                ret = new MergeOverlapFuture(this, loadFuture);
                this.weakRef = new WeakReference<MergeOverlapFuture>(ret);
                HgtCache.this.secondaryLru.evict(loadFuture);
            } else {
                ret = new MergeOverlapFuture(this);
                this.weakRef = new WeakReference<MergeOverlapFuture>(ret);
            }
            HgtCache.this.mainLru.markUsed(ret);
            return ret;
        }

        private LoadUnmergedFuture getUnmergedAsMergePartner() {
            LoadUnmergedFuture ret;
            Future candidate;
            WeakReference<Future<HillshadingBitmap>> weak = this.weakRef;
            Future future = candidate = weak == null ? null : (Future)weak.get();
            if (candidate instanceof LoadUnmergedFuture) {
                HgtCache.this.secondaryLru.markUsed(candidate);
                ret = (LoadUnmergedFuture)candidate;
            } else if (candidate instanceof MergeOverlapFuture) {
                HgtCache.this.mainLru.markUsed(candidate);
                ret = ((MergeOverlapFuture)candidate).loadFuture;
            } else {
                LoadUnmergedFuture created = new LoadUnmergedFuture(this);
                this.weakRef = new WeakReference<LoadUnmergedFuture>(created);
                HgtCache.this.secondaryLru.markUsed(created);
                ret = created;
            }
            return ret;
        }

        private Future<HillshadingBitmap> getForLores() {
            Future candidate;
            WeakReference<Future<HillshadingBitmap>> weak = this.weakRef;
            Future future = candidate = weak == null ? null : (Future)weak.get();
            if (candidate == null) {
                candidate = new LoadUnmergedFuture(this);
                this.weakRef = new WeakReference<Future>(candidate);
            }
            Future<HillshadingBitmap> evicted = HgtCache.this.mainLru.markUsed(candidate);
            if (HgtCache.this.secondaryLru != null) {
                HgtCache.this.secondaryLru.markUsed(evicted);
            }
            return candidate;
        }

        @Override
        public HillshadingBitmap getFinishedConverted() {
            Future hillshadingBitmapFuture;
            WeakReference<Future<HillshadingBitmap>> weak = this.weakRef;
            if (weak != null && (hillshadingBitmapFuture = (Future)weak.get()) != null && hillshadingBitmapFuture.isDone()) {
                try {
                    return (HillshadingBitmap)hillshadingBitmapFuture.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        @Override
        public DemFile getFile() {
            return this.file;
        }

        @Override
        public double northLat() {
            return this.maxLatitude;
        }

        @Override
        public double southLat() {
            return this.minLatitude;
        }

        @Override
        public double westLng() {
            return this.minLongitude;
        }

        @Override
        public double eastLng() {
            return this.maxLongitude;
        }

        private HgtFileInfo getNeighbor(HillshadingBitmap.Border border) throws ExecutionException, InterruptedException {
            Map map = (Map)HgtCache.this.hgtFiles.get();
            switch (border) {
                case NORTH: {
                    return (HgtFileInfo)map.get(new TileKey((int)this.maxLatitude + 1, (int)this.minLongitude));
                }
                case SOUTH: {
                    return (HgtFileInfo)map.get(new TileKey((int)this.maxLatitude - 1, (int)this.minLongitude));
                }
                case EAST: {
                    return (HgtFileInfo)map.get(new TileKey((int)this.maxLatitude, (int)this.minLongitude + 1));
                }
                case WEST: {
                    return (HgtFileInfo)map.get(new TileKey((int)this.maxLatitude, (int)this.minLongitude - 1));
                }
            }
            return null;
        }

        public String toString() {
            Future future = this.weakRef == null ? null : (Future)this.weakRef.get();
            return "[lt:" + this.minLatitude + "-" + this.maxLatitude + " ln:" + this.minLongitude + "-" + this.maxLongitude + (future == null ? "" : (future.isDone() ? "done" : "wip")) + "]";
        }
    }

    class MergeOverlapFuture
    extends LazyFuture<HillshadingBitmap> {
        final LoadUnmergedFuture loadFuture;
        private HgtFileInfo hgtFileInfo;

        MergeOverlapFuture(HgtFileInfo hgtFileInfo, LoadUnmergedFuture loadFuture) {
            this.hgtFileInfo = hgtFileInfo;
            this.loadFuture = loadFuture;
        }

        MergeOverlapFuture(HgtFileInfo hgtFileInfo) {
            this(hgtFileInfo, this$0.new LoadUnmergedFuture(hgtFileInfo));
        }

        @Override
        public HillshadingBitmap calculate() throws ExecutionException, InterruptedException {
            HillshadingBitmap monoBitmap = (HillshadingBitmap)this.loadFuture.get();
            for (HillshadingBitmap.Border border : HillshadingBitmap.Border.values()) {
                HgtFileInfo neighbor = this.hgtFileInfo.getNeighbor(border);
                this.mergePaddingOnBitmap(monoBitmap, neighbor, border);
            }
            return monoBitmap;
        }

        private void mergePaddingOnBitmap(HillshadingBitmap fresh, HgtFileInfo neighbor, HillshadingBitmap.Border border) {
            LoadUnmergedFuture neighborUnmergedFuture;
            int padding = fresh.getPadding();
            if (padding < 1) {
                return;
            }
            if (neighbor != null && (neighborUnmergedFuture = neighbor.getUnmergedAsMergePartner()) != null) {
                try {
                    HillshadingBitmap other = (HillshadingBitmap)neighborUnmergedFuture.get();
                    Canvas copyCanvas = HgtCache.this.graphicsFactory.createCanvas();
                    HgtCache.mergeSameSized(fresh, other, border, padding, copyCanvas);
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class LoadUnmergedFuture
    extends LazyFuture<HillshadingBitmap> {
        private final HgtFileInfo hgtFileInfo;

        LoadUnmergedFuture(HgtFileInfo hgtFileInfo) {
            this.hgtFileInfo = hgtFileInfo;
        }

        @Override
        public HillshadingBitmap calculate() {
            ShadingAlgorithm.RawShadingResult raw = HgtCache.this.algorithm.transformToByteBuffer(this.hgtFileInfo, HgtCache.this.interpolatorOverlap ? 1 : 0);
            raw.fillPadding();
            return HgtCache.this.graphicsFactory.createMonoBitmap(raw.width, raw.height, raw.bytes, raw.padding, (BoundingBox)this.hgtFileInfo);
        }
    }
}

