/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.cache;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.mapsforge.core.graphics.TileBitmap;
import org.mapsforge.map.layer.cache.TileCache;
import org.mapsforge.map.layer.queue.Job;
import org.mapsforge.map.model.common.Observer;

public class TwoLevelTileCache
implements TileCache {
    private final TileCache firstLevelTileCache;
    private final TileCache secondLevelTileCache;
    private final Set<Job> workingSet;

    public TwoLevelTileCache(TileCache firstLevelTileCache, TileCache secondLevelTileCache) {
        this.firstLevelTileCache = firstLevelTileCache;
        this.secondLevelTileCache = secondLevelTileCache;
        this.workingSet = Collections.synchronizedSet(new HashSet());
    }

    @Override
    public boolean containsKey(Job key) {
        return this.firstLevelTileCache.containsKey(key) || this.secondLevelTileCache.containsKey(key);
    }

    @Override
    public void destroy() {
        this.firstLevelTileCache.destroy();
        this.secondLevelTileCache.destroy();
    }

    @Override
    public TileBitmap get(Job key) {
        TileBitmap returnBitmap = this.firstLevelTileCache.get(key);
        if (returnBitmap != null) {
            return returnBitmap;
        }
        returnBitmap = this.secondLevelTileCache.get(key);
        if (returnBitmap != null) {
            this.firstLevelTileCache.put(key, returnBitmap);
            return returnBitmap;
        }
        return null;
    }

    @Override
    public int getCapacity() {
        return Math.max(this.firstLevelTileCache.getCapacity(), this.secondLevelTileCache.getCapacity());
    }

    @Override
    public int getCapacityFirstLevel() {
        return this.firstLevelTileCache.getCapacity();
    }

    @Override
    public TileBitmap getImmediately(Job key) {
        return this.firstLevelTileCache.get(key);
    }

    @Override
    public void purge() {
        this.firstLevelTileCache.purge();
        this.secondLevelTileCache.purge();
    }

    @Override
    public void put(Job key, TileBitmap bitmap) {
        if (this.workingSet.contains(key)) {
            this.firstLevelTileCache.put(key, bitmap);
        }
        this.secondLevelTileCache.put(key, bitmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWorkingSet(Set<Job> newWorkingSet) {
        this.workingSet.clear();
        this.workingSet.addAll(newWorkingSet);
        this.firstLevelTileCache.setWorkingSet(this.workingSet);
        this.secondLevelTileCache.setWorkingSet(this.workingSet);
        Set<Job> set = this.workingSet;
        synchronized (set) {
            for (Job job : this.workingSet) {
                TileBitmap tileBitmap;
                if (this.firstLevelTileCache.containsKey(job) || !this.secondLevelTileCache.containsKey(job) || (tileBitmap = this.secondLevelTileCache.get(job)) == null) continue;
                this.firstLevelTileCache.put(job, tileBitmap);
            }
        }
    }

    @Override
    public void addObserver(Observer observer) {
        this.firstLevelTileCache.addObserver(observer);
        this.secondLevelTileCache.addObserver(observer);
    }

    @Override
    public void removeObserver(Observer observer) {
        this.secondLevelTileCache.removeObserver(observer);
        this.firstLevelTileCache.removeObserver(observer);
    }
}

