/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.util;

import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.MapPosition;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.map.view.MapView;

public class MapViewProjection {
    private static final String INVALID_MAP_VIEW_DIMENSIONS = "invalid MapView dimensions";
    private final MapView mapView;

    public MapViewProjection(MapView mapView) {
        this.mapView = mapView;
    }

    public LatLong fromPixels(double x, double y) {
        if (this.mapView.getWidth() <= 0 || this.mapView.getHeight() <= 0) {
            return null;
        }
        MapPosition mapPosition = this.mapView.getModel().frameBufferModel.getMapPosition();
        if (mapPosition == null) {
            return null;
        }
        LatLong latLong = mapPosition.latLong;
        long mapSize = MercatorProjection.getMapSize((byte)mapPosition.zoomLevel, (int)this.mapView.getModel().displayModel.getTileSize());
        double pixelX = MercatorProjection.longitudeToPixelX((double)latLong.longitude, (long)mapSize);
        double pixelY = MercatorProjection.latitudeToPixelY((double)latLong.latitude, (long)mapSize);
        pixelX -= (double)(this.mapView.getWidth() >> 1);
        pixelY -= (double)(this.mapView.getHeight() >> 1);
        try {
            return new LatLong(MercatorProjection.pixelYToLatitude((double)(pixelY + y), (long)mapSize), MercatorProjection.pixelXToLongitude((double)(pixelX + x), (long)mapSize));
        }
        catch (Exception e) {
            return null;
        }
    }

    public double getLatitudeSpan() {
        if (this.mapView.getWidth() > 0 && this.mapView.getHeight() > 0) {
            LatLong top = this.fromPixels(0.0, 0.0);
            LatLong bottom = this.fromPixels(0.0, this.mapView.getHeight());
            return Math.abs(top.latitude - bottom.latitude);
        }
        throw new IllegalStateException(INVALID_MAP_VIEW_DIMENSIONS);
    }

    public double getLongitudeSpan() {
        if (this.mapView.getWidth() > 0 && this.mapView.getHeight() > 0) {
            LatLong left = this.fromPixels(0.0, 0.0);
            LatLong right = this.fromPixels(this.mapView.getWidth(), 0.0);
            return Math.abs(left.longitude - right.longitude);
        }
        throw new IllegalStateException(INVALID_MAP_VIEW_DIMENSIONS);
    }

    public Point toPixels(LatLong in) {
        if (in == null || this.mapView.getWidth() <= 0 || this.mapView.getHeight() <= 0) {
            return null;
        }
        MapPosition mapPosition = this.mapView.getModel().mapViewPosition.getMapPosition();
        if (mapPosition == null) {
            return null;
        }
        LatLong latLong = mapPosition.latLong;
        long mapSize = MercatorProjection.getMapSize((byte)mapPosition.zoomLevel, (int)this.mapView.getModel().displayModel.getTileSize());
        double pixelX = MercatorProjection.longitudeToPixelX((double)latLong.longitude, (long)mapSize);
        double pixelY = MercatorProjection.latitudeToPixelY((double)latLong.latitude, (long)mapSize);
        return new Point((double)((int)(MercatorProjection.longitudeToPixelX((double)in.longitude, (long)mapSize) - (pixelX -= (double)(this.mapView.getWidth() >> 1)))), (double)((int)(MercatorProjection.latitudeToPixelY((double)in.latitude, (long)mapSize) - (pixelY -= (double)(this.mapView.getHeight() >> 1)))));
    }
}

