/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.mapsforge.core.mapelements.MapElementContainer;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Tile;
import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.map.layer.TilePosition;

public final class LayerUtil {
    public static List<TilePosition> getTilePositions(BoundingBox boundingBox, byte zoomLevel, Point topLeftPoint, int tileSize) {
        int tileLeft = MercatorProjection.longitudeToTileX((double)boundingBox.minLongitude, (byte)zoomLevel);
        int tileTop = MercatorProjection.latitudeToTileY((double)boundingBox.maxLatitude, (byte)zoomLevel);
        int tileRight = MercatorProjection.longitudeToTileX((double)boundingBox.maxLongitude, (byte)zoomLevel);
        int tileBottom = MercatorProjection.latitudeToTileY((double)boundingBox.minLatitude, (byte)zoomLevel);
        int initialCapacity = (tileRight - tileLeft + 1) * (tileBottom - tileTop + 1);
        ArrayList<TilePosition> tilePositions = new ArrayList<TilePosition>(initialCapacity);
        for (int tileY = tileTop; tileY <= tileBottom; ++tileY) {
            for (int tileX = tileLeft; tileX <= tileRight; ++tileX) {
                double pixelX = (double)MercatorProjection.tileToPixel((long)tileX, (int)tileSize) - topLeftPoint.x;
                double pixelY = (double)MercatorProjection.tileToPixel((long)tileY, (int)tileSize) - topLeftPoint.y;
                tilePositions.add(new TilePosition(new Tile(tileX, tileY, zoomLevel, tileSize), new Point(pixelX, pixelY)));
            }
        }
        return tilePositions;
    }

    public static Tile getUpperLeft(BoundingBox boundingBox, byte zoomLevel, int tileSize) {
        int tileLeft = MercatorProjection.longitudeToTileX((double)boundingBox.minLongitude, (byte)zoomLevel);
        int tileTop = MercatorProjection.latitudeToTileY((double)boundingBox.maxLatitude, (byte)zoomLevel);
        return new Tile(tileLeft, tileTop, zoomLevel, tileSize);
    }

    public static Tile getLowerRight(BoundingBox boundingBox, byte zoomLevel, int tileSize) {
        int tileRight = MercatorProjection.longitudeToTileX((double)boundingBox.maxLongitude, (byte)zoomLevel);
        int tileBottom = MercatorProjection.latitudeToTileY((double)boundingBox.minLatitude, (byte)zoomLevel);
        return new Tile(tileRight, tileBottom, zoomLevel, tileSize);
    }

    public static Set<Tile> getTiles(Tile upperLeft, Tile lowerRight) {
        HashSet<Tile> tiles = new HashSet<Tile>();
        for (int tileY = upperLeft.tileY; tileY <= lowerRight.tileY; ++tileY) {
            for (int tileX = upperLeft.tileX; tileX <= lowerRight.tileX; ++tileX) {
                tiles.add(new Tile(tileX, tileY, upperLeft.zoomLevel, upperLeft.tileSize));
            }
        }
        return tiles;
    }

    public static Set<Tile> getTiles(BoundingBox boundingBox, byte zoomLevel, int tileSize) {
        int tileLeft = MercatorProjection.longitudeToTileX((double)boundingBox.minLongitude, (byte)zoomLevel);
        int tileTop = MercatorProjection.latitudeToTileY((double)boundingBox.maxLatitude, (byte)zoomLevel);
        int tileRight = MercatorProjection.longitudeToTileX((double)boundingBox.maxLongitude, (byte)zoomLevel);
        int tileBottom = MercatorProjection.latitudeToTileY((double)boundingBox.minLatitude, (byte)zoomLevel);
        HashSet<Tile> tiles = new HashSet<Tile>();
        for (int tileY = tileTop; tileY <= tileBottom; ++tileY) {
            for (int tileX = tileLeft; tileX <= tileRight; ++tileX) {
                tiles.add(new Tile(tileX, tileY, zoomLevel, tileSize));
            }
        }
        return tiles;
    }

    public static List<MapElementContainer> collisionFreeOrdered(List<MapElementContainer> input) {
        Collections.sort(input, Collections.reverseOrder());
        LinkedList<MapElementContainer> output = new LinkedList<MapElementContainer>();
        for (MapElementContainer item : input) {
            boolean hasSpace = true;
            for (MapElementContainer outputElement : output) {
                if (!outputElement.clashesWith(item)) continue;
                hasSpace = false;
                break;
            }
            if (!hasSpace) continue;
            output.add(item);
        }
        return output;
    }

    private LayerUtil() {
        throw new IllegalStateException();
    }
}

