/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme.rule;

import java.util.Stack;
import java.util.logging.Logger;
import org.mapsforge.map.rendertheme.rule.AnyMatcher;
import org.mapsforge.map.rendertheme.rule.AttributeMatcher;
import org.mapsforge.map.rendertheme.rule.ClosedMatcher;
import org.mapsforge.map.rendertheme.rule.ElementMatcher;
import org.mapsforge.map.rendertheme.rule.KeyMatcher;
import org.mapsforge.map.rendertheme.rule.NegativeMatcher;
import org.mapsforge.map.rendertheme.rule.PositiveRule;
import org.mapsforge.map.rendertheme.rule.Rule;
import org.mapsforge.map.rendertheme.rule.ValueMatcher;

final class RuleOptimizer {
    private static final Logger LOGGER = Logger.getLogger(RuleOptimizer.class.getName());

    static AttributeMatcher optimize(AttributeMatcher attributeMatcher, Stack<Rule> ruleStack) {
        if (attributeMatcher instanceof AnyMatcher || attributeMatcher instanceof NegativeMatcher) {
            return attributeMatcher;
        }
        if (attributeMatcher instanceof KeyMatcher) {
            return RuleOptimizer.optimizeKeyMatcher(attributeMatcher, ruleStack);
        }
        if (attributeMatcher instanceof ValueMatcher) {
            return RuleOptimizer.optimizeValueMatcher(attributeMatcher, ruleStack);
        }
        throw new IllegalArgumentException("unknown AttributeMatcher: " + attributeMatcher);
    }

    static ClosedMatcher optimize(ClosedMatcher closedMatcher, Stack<Rule> ruleStack) {
        if (closedMatcher instanceof AnyMatcher) {
            return closedMatcher;
        }
        int n = ruleStack.size();
        for (int i = 0; i < n; ++i) {
            if (((Rule)ruleStack.get((int)i)).closedMatcher.isCoveredBy(closedMatcher)) {
                return AnyMatcher.INSTANCE;
            }
            if (closedMatcher.isCoveredBy(((Rule)ruleStack.get((int)i)).closedMatcher)) continue;
            LOGGER.warning("unreachable rule (closed)");
        }
        return closedMatcher;
    }

    static ElementMatcher optimize(ElementMatcher elementMatcher, Stack<Rule> ruleStack) {
        if (elementMatcher instanceof AnyMatcher) {
            return elementMatcher;
        }
        int n = ruleStack.size();
        for (int i = 0; i < n; ++i) {
            Rule rule = (Rule)ruleStack.get(i);
            if (rule.elementMatcher.isCoveredBy(elementMatcher)) {
                return AnyMatcher.INSTANCE;
            }
            if (elementMatcher.isCoveredBy(rule.elementMatcher)) continue;
            LOGGER.warning("unreachable rule (e)");
        }
        return elementMatcher;
    }

    private static AttributeMatcher optimizeKeyMatcher(AttributeMatcher attributeMatcher, Stack<Rule> ruleStack) {
        int n = ruleStack.size();
        for (int i = 0; i < n; ++i) {
            if (!(ruleStack.get(i) instanceof PositiveRule)) continue;
            PositiveRule positiveRule = (PositiveRule)ruleStack.get(i);
            if (!positiveRule.keyMatcher.isCoveredBy(attributeMatcher)) continue;
            return AnyMatcher.INSTANCE;
        }
        return attributeMatcher;
    }

    private static AttributeMatcher optimizeValueMatcher(AttributeMatcher attributeMatcher, Stack<Rule> ruleStack) {
        int n = ruleStack.size();
        for (int i = 0; i < n; ++i) {
            if (!(ruleStack.get(i) instanceof PositiveRule)) continue;
            PositiveRule positiveRule = (PositiveRule)ruleStack.get(i);
            if (!positiveRule.valueMatcher.isCoveredBy(attributeMatcher)) continue;
            return AnyMatcher.INSTANCE;
        }
        return attributeMatcher;
    }

    private RuleOptimizer() {
        throw new IllegalStateException();
    }
}

