/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.logging.Logger;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.ResourceBitmap;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.rendertheme.ThemeCallback;
import org.mapsforge.map.rendertheme.XmlThemeResourceProvider;
import org.mapsforge.map.rendertheme.renderinstruction.RenderInstruction;
import org.xmlpull.v1.XmlPullParserException;

public final class XmlUtils {
    private static final Logger LOGGER = Logger.getLogger(XmlUtils.class.getName());
    private static final String PREFIX_ASSETS = "assets:";
    public static final String PREFIX_FILE = "file:";
    private static final String PREFIX_JAR = "jar:";
    private static final String PREFIX_JAR_V1 = "jar:/org/mapsforge/android/maps/rendertheme";
    private static final String UNSUPPORTED_COLOR_FORMAT = "unsupported color format: ";

    public static void checkMandatoryAttribute(String elementName, String attributeName, Object attributeValue) throws XmlPullParserException {
        if (attributeValue == null) {
            throw new XmlPullParserException("missing attribute '" + attributeName + "' for element: " + elementName);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static ResourceBitmap createBitmap(GraphicFactory graphicFactory, DisplayModel displayModel, String relativePathPrefix, String src, XmlThemeResourceProvider resourceProvider, int width, int height, int percent) throws IOException {
        if (src == null || src.length() == 0) {
            return null;
        }
        inputStream = XmlUtils.createInputStream(graphicFactory, relativePathPrefix, src, resourceProvider);
        absoluteName = XmlUtils.getAbsoluteName(relativePathPrefix, src);
        sb = new StringBuilder().append(absoluteName).append(width).append(height).append(percent);
        if (resourceProvider != null) {
            sb.append(resourceProvider.getClass().getName());
        }
        hash = sb.toString().hashCode();
        if (src.toLowerCase(Locale.ENGLISH).endsWith(".svg")) {
            try {
                var12_12 = graphicFactory.renderSvg(inputStream, displayModel.getScaleFactor(), width, height, percent, hash);
                return var12_12;
            }
            catch (IOException e) {
                throw new IOException("SVG render failed " + src, e);
            }
        }
        ** try [egrp 3[TRYBLOCK] [1 : 164->186)] { 
lbl-1000:
        // 1 sources

        {
            e = graphicFactory.createResourceBitmap(inputStream, displayModel.getScaleFactor(), width, height, percent, hash);
            return e;
        }
lbl20:
        // 1 sources

        catch (IOException e) {
            throw new IOException("Reading bitmap file failed " + src, e);
        }
        finally {
            inputStream.close();
        }
    }

    public static XmlPullParserException createXmlPullParserException(String element, String name, String value, int attributeIndex) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("unknown attribute (");
        stringBuilder.append(attributeIndex);
        stringBuilder.append(") in element '");
        stringBuilder.append(element);
        stringBuilder.append("': ");
        stringBuilder.append(name);
        stringBuilder.append('=');
        stringBuilder.append(value);
        return new XmlPullParserException(stringBuilder.toString());
    }

    public static int getColor(GraphicFactory graphicFactory, String colorString) {
        return XmlUtils.getColor(graphicFactory, colorString, null, null);
    }

    public static int getColor(GraphicFactory graphicFactory, String colorString, ThemeCallback themeCallback, RenderInstruction origin) {
        if (colorString.isEmpty() || colorString.charAt(0) != '#') {
            throw new IllegalArgumentException(UNSUPPORTED_COLOR_FORMAT + colorString);
        }
        if (colorString.length() == 7) {
            return XmlUtils.getColor(graphicFactory, colorString, 255, 1, themeCallback, origin);
        }
        if (colorString.length() == 9) {
            return XmlUtils.getColor(graphicFactory, colorString, Integer.parseInt(colorString.substring(1, 3), 16), 3, themeCallback, origin);
        }
        throw new IllegalArgumentException(UNSUPPORTED_COLOR_FORMAT + colorString);
    }

    public static byte parseNonNegativeByte(String name, String value) throws XmlPullParserException {
        byte parsedByte = Byte.parseByte(value);
        XmlUtils.checkForNegativeValue(name, parsedByte);
        return parsedByte;
    }

    public static float parseNonNegativeFloat(String name, String value) throws XmlPullParserException {
        float parsedFloat = Float.parseFloat(value);
        XmlUtils.checkForNegativeValue(name, parsedFloat);
        return parsedFloat;
    }

    public static int parseNonNegativeInteger(String name, String value) throws XmlPullParserException {
        int parsedInt = Integer.parseInt(value);
        XmlUtils.checkForNegativeValue(name, parsedInt);
        return parsedInt;
    }

    private static void checkForNegativeValue(String name, float value) throws XmlPullParserException {
        if (value < 0.0f) {
            throw new XmlPullParserException("Attribute '" + name + "' must not be negative: " + value);
        }
    }

    private static InputStream createInputStream(GraphicFactory graphicFactory, String relativePathPrefix, String src, XmlThemeResourceProvider resourceProvider) throws IOException {
        InputStream inputStream;
        if (resourceProvider != null) {
            try {
                inputStream = resourceProvider.createInputStream(relativePathPrefix, src);
                if (inputStream != null) {
                    return inputStream;
                }
            }
            catch (IOException ioe) {
                LOGGER.fine("Exception trying to access resource: " + src + " using custom provider: " + ioe);
            }
        }
        if (src.startsWith(PREFIX_ASSETS)) {
            src = src.substring(PREFIX_ASSETS.length());
            inputStream = XmlUtils.inputStreamFromAssets(graphicFactory, relativePathPrefix, src);
        } else if (src.startsWith(PREFIX_FILE)) {
            src = src.substring(PREFIX_FILE.length());
            inputStream = XmlUtils.inputStreamFromFile(relativePathPrefix, src);
        } else if (src.startsWith(PREFIX_JAR) || src.startsWith(PREFIX_JAR_V1)) {
            if (src.startsWith(PREFIX_JAR)) {
                src = src.substring(PREFIX_JAR.length());
            } else if (src.startsWith(PREFIX_JAR_V1)) {
                src = src.substring(PREFIX_JAR_V1.length());
            }
            inputStream = XmlUtils.inputStreamFromJar(relativePathPrefix, src);
        } else {
            inputStream = XmlUtils.inputStreamFromFile(relativePathPrefix, src);
            if (inputStream == null) {
                inputStream = XmlUtils.inputStreamFromAssets(graphicFactory, relativePathPrefix, src);
            }
            if (inputStream == null) {
                inputStream = XmlUtils.inputStreamFromJar(relativePathPrefix, src);
            }
        }
        if (inputStream == null && (inputStream = XmlUtils.inputStreamFromJar("/assets/", src)) != null) {
            LOGGER.info("internal resource: " + src);
        }
        if (inputStream != null) {
            return inputStream;
        }
        LOGGER.severe("invalid resource: " + src);
        throw new FileNotFoundException("invalid resource: " + src);
    }

    private static InputStream inputStreamFromAssets(GraphicFactory graphicFactory, String relativePathPrefix, String src) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = graphicFactory.platformSpecificSources(relativePathPrefix, src);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (inputStream != null) {
            return inputStream;
        }
        return null;
    }

    private static InputStream inputStreamFromFile(String relativePathPrefix, String src) throws IOException {
        File file = XmlUtils.getFile(relativePathPrefix, src);
        if (!file.exists()) {
            if (src.length() > 0 && src.charAt(0) == File.separatorChar) {
                file = XmlUtils.getFile(relativePathPrefix, src.substring(1));
            }
            if (!file.exists()) {
                file = null;
            }
        } else if (!file.isFile() || !file.canRead()) {
            file = null;
        }
        if (file != null) {
            return new FileInputStream(file);
        }
        return null;
    }

    private static InputStream inputStreamFromJar(String relativePathPrefix, String src) throws IOException {
        String absoluteName = XmlUtils.getAbsoluteName(relativePathPrefix, src);
        return XmlUtils.class.getResourceAsStream(absoluteName);
    }

    private static String getAbsoluteName(String relativePathPrefix, String name) {
        if (name.charAt(0) == File.separatorChar) {
            return name;
        }
        return relativePathPrefix + name;
    }

    private static int getColor(GraphicFactory graphicFactory, String colorString, int alpha, int rgbStartIndex, ThemeCallback themeCallback, RenderInstruction origin) {
        int red = Integer.parseInt(colorString.substring(rgbStartIndex, rgbStartIndex + 2), 16);
        int green = Integer.parseInt(colorString.substring(rgbStartIndex + 2, rgbStartIndex + 4), 16);
        int blue = Integer.parseInt(colorString.substring(rgbStartIndex + 4, rgbStartIndex + 6), 16);
        int color = graphicFactory.createColor(alpha, red, green, blue);
        if (themeCallback != null) {
            color = themeCallback.getColor(origin, color);
        }
        return color;
    }

    private static File getFile(String parentPath, String pathName) {
        if (pathName.charAt(0) == File.separatorChar) {
            return new File(pathName);
        }
        return new File(parentPath, pathName);
    }

    private XmlUtils() {
        throw new IllegalStateException();
    }
}

