/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.renderer;

import java.util.List;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Display;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.mapelements.MapElementContainer;
import org.mapsforge.core.mapelements.SymbolContainer;
import org.mapsforge.core.mapelements.WayTextContainer;
import org.mapsforge.core.model.LineSegment;
import org.mapsforge.core.model.LineString;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Rectangle;
import org.mapsforge.core.model.Tile;
import org.mapsforge.map.layer.renderer.RendererUtils;

final class WayDecorator {
    private static final double MAX_LABEL_CORNER_ANGLE = 45.0;

    static void renderSymbol(Bitmap symbolBitmap, Display display, int priority, float dy, Rectangle boundary, boolean repeatSymbol, float repeatGap, float repeatStart, boolean rotate, Point[][] coordinates, List<MapElementContainer> currentItems) {
        int skipPixels = (int)repeatStart;
        Point[] c = dy == 0.0f ? coordinates[0] : RendererUtils.parallelPath(coordinates[0], dy);
        double previousX = c[0].x;
        double previousY = c[0].y;
        float theta = 0.0f;
        for (int i = 1; i < c.length; ++i) {
            double currentX = c[i].x;
            double currentY = c[i].y;
            double diffX = currentX - previousX;
            double diffY = currentY - previousY;
            double segmentLengthInPixel = Math.sqrt(diffX * diffX + diffY * diffY);
            float segmentLengthRemaining = (float)segmentLengthInPixel;
            while (segmentLengthRemaining - (float)skipPixels > repeatStart) {
                float segmentSkipPercentage = (float)skipPixels / segmentLengthRemaining;
                previousX += diffX * (double)segmentSkipPercentage;
                previousY += diffY * (double)segmentSkipPercentage;
                if (rotate) {
                    theta = (float)Math.atan2(currentY - previousY, currentX - previousX);
                }
                Point point = new Point(previousX, previousY);
                currentItems.add((MapElementContainer)new SymbolContainer(point, display, priority, boundary, symbolBitmap, theta));
                if (!repeatSymbol) {
                    return;
                }
                diffX = currentX - previousX;
                diffY = currentY - previousY;
                segmentLengthRemaining -= (float)skipPixels;
                skipPixels = (int)repeatGap;
            }
            if ((float)(skipPixels = (int)((float)skipPixels - segmentLengthRemaining)) < repeatStart) {
                skipPixels = (int)repeatStart;
            }
            previousX = currentX;
            previousY = currentY;
        }
    }

    static void renderText(GraphicFactory graphicFactory, Tile upperLeft, Tile lowerRight, String text, Display display, int priority, float dy, Paint fill, Paint stroke, boolean repeat, float repeatGap, float repeatStart, boolean rotate, Point[][] coordinates, List<MapElementContainer> currentLabels) {
        if (coordinates.length == 0) {
            return;
        }
        Point[] c = dy == 0.0f ? coordinates[0] : RendererUtils.parallelPath(coordinates[0], dy);
        if (c.length < 2) {
            return;
        }
        LineString path = new LineString();
        for (int i = 1; i < c.length; ++i) {
            LineSegment segment = new LineSegment(c[i - 1], c[i]);
            path.segments.add(segment);
        }
        int textWidth = stroke == null ? fill.getTextWidth(text) : stroke.getTextWidth(text);
        int textHeight = stroke == null ? fill.getTextHeight(text) : stroke.getTextHeight(text);
        double pathLength = path.length();
        float pos = repeatStart;
        while ((double)(pos + (float)textWidth) < pathLength) {
            LineString linePart = path.extractPart((double)pos, (double)(pos + (float)textWidth));
            boolean tooSharp = false;
            for (int i = 1; i < linePart.segments.size(); ++i) {
                double cornerAngle = ((LineSegment)linePart.segments.get(i - 1)).angleTo((LineSegment)linePart.segments.get(i));
                if (!(Math.abs(cornerAngle) > 45.0)) continue;
                tooSharp = true;
                break;
            }
            if (!tooSharp) {
                currentLabels.add((MapElementContainer)new WayTextContainer(graphicFactory, linePart, display, priority, text, fill, stroke, (double)textHeight));
            }
            pos += repeatGap + (float)textWidth;
        }
    }

    private WayDecorator() {
        throw new IllegalStateException();
    }
}

