/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.renderer;

import org.mapsforge.core.model.Point;

final class GeometryUtils {
    static Point calculateCenterOfBoundingBox(Point[] coordinates) {
        double pointXMin = coordinates[0].x;
        double pointXMax = coordinates[0].x;
        double pointYMin = coordinates[0].y;
        double pointYMax = coordinates[0].y;
        for (Point immutablePoint : coordinates) {
            if (immutablePoint.x < pointXMin) {
                pointXMin = immutablePoint.x;
            } else if (immutablePoint.x > pointXMax) {
                pointXMax = immutablePoint.x;
            }
            if (immutablePoint.y < pointYMin) {
                pointYMin = immutablePoint.y;
                continue;
            }
            if (!(immutablePoint.y > pointYMax)) continue;
            pointYMax = immutablePoint.y;
        }
        return new Point((pointXMin + pointXMax) / 2.0, (pointYMax + pointYMin) / 2.0);
    }

    private GeometryUtils() {
        throw new IllegalStateException();
    }
}

