/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.queue;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.mapsforge.map.layer.queue.Job;
import org.mapsforge.map.layer.queue.QueueItem;
import org.mapsforge.map.layer.queue.QueueItemComparator;
import org.mapsforge.map.layer.queue.QueueItemScheduler;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.model.IMapViewPosition;

public class JobQueue<T extends Job> {
    private static final int QUEUE_CAPACITY = 128;
    private final List<T> assignedJobs = new LinkedList<T>();
    private final DisplayModel displayModel;
    private boolean isInterrupted;
    private final IMapViewPosition mapViewPosition;
    private final List<QueueItem<T>> queueItems = new LinkedList<QueueItem<T>>();
    private boolean scheduleNeeded;

    public JobQueue(IMapViewPosition mapViewPosition, DisplayModel displayModel) {
        this.mapViewPosition = mapViewPosition;
        this.displayModel = displayModel;
    }

    public synchronized void add(T job) {
        QueueItem<T> queueItem;
        if (!this.assignedJobs.contains(job) && !this.queueItems.contains(queueItem = new QueueItem<T>(job))) {
            this.queueItems.add(queueItem);
            this.scheduleNeeded = true;
            this.notifyWorkers();
        }
    }

    public synchronized T get() throws InterruptedException {
        return this.get(Integer.MAX_VALUE);
    }

    public synchronized T get(int maxAssigned) throws InterruptedException {
        while (this.queueItems.isEmpty() || this.assignedJobs.size() >= maxAssigned) {
            this.wait(200L);
            if (!this.isInterrupted) continue;
            this.isInterrupted = false;
            return null;
        }
        if (this.scheduleNeeded) {
            this.scheduleNeeded = false;
            this.schedule(this.displayModel.getTileSize());
        }
        Object job = this.queueItems.remove((int)0).object;
        this.assignedJobs.add(job);
        return job;
    }

    public synchronized void interrupt() {
        this.isInterrupted = true;
        this.notifyWorkers();
    }

    public synchronized void notifyWorkers() {
        this.notifyAll();
    }

    public synchronized void remove(T job) {
        this.assignedJobs.remove(job);
        this.notifyWorkers();
    }

    private void schedule(int tileSize) {
        QueueItemScheduler.schedule(this.queueItems, this.mapViewPosition.getMapPosition(), tileSize);
        Collections.sort(this.queueItems, QueueItemComparator.INSTANCE);
        this.trimToSize();
    }

    public synchronized int size() {
        return this.queueItems.size();
    }

    private void trimToSize() {
        int queueSize = this.queueItems.size();
        while (queueSize > 128) {
            this.queueItems.remove(--queueSize);
        }
    }
}

