/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.overlay;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.graphics.Path;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.util.LatLongUtils;
import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.map.layer.Layer;
import org.mapsforge.map.util.MapViewProjection;

public class Polyline
extends Layer {
    private static final byte STROKE_MIN_ZOOM = 12;
    private BoundingBox boundingBox;
    private final GraphicFactory graphicFactory;
    private final boolean keepAligned;
    private final List<LatLong> latLongs = new CopyOnWriteArrayList<LatLong>();
    private Paint paintStroke;
    private double strokeIncrease = 1.0;

    public Polyline(Paint paintStroke, GraphicFactory graphicFactory) {
        this(paintStroke, graphicFactory, false);
    }

    public Polyline(Paint paintStroke, GraphicFactory graphicFactory, boolean keepAligned) {
        this.keepAligned = keepAligned;
        this.paintStroke = paintStroke;
        this.graphicFactory = graphicFactory;
    }

    public synchronized void addPoint(LatLong point) {
        this.latLongs.add(point);
        this.updatePoints();
    }

    public synchronized void addPoints(List<LatLong> points) {
        this.latLongs.addAll(points);
        this.updatePoints();
    }

    public synchronized void clear() {
        this.latLongs.clear();
        this.updatePoints();
    }

    public synchronized boolean contains(Point tapXY, MapViewProjection mapViewProjection) {
        double distance = Math.max(10.0f * this.displayModel.getScaleFactor(), this.paintStroke.getStrokeWidth() / 2.0f);
        Point point2 = null;
        for (int i = 0; i < this.latLongs.size() - 1; ++i) {
            Point point1 = i == 0 ? mapViewProjection.toPixels(this.latLongs.get(i)) : point2;
            point2 = mapViewProjection.toPixels(this.latLongs.get(i + 1));
            if (!(LatLongUtils.distanceSegmentPoint((double)point1.x, (double)point1.y, (double)point2.x, (double)point2.y, (double)tapXY.x, (double)tapXY.y) <= distance)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void draw(BoundingBox boundingBox, byte zoomLevel, Canvas canvas, Point topLeftPoint) {
        if (this.latLongs.isEmpty() || this.paintStroke == null) {
            return;
        }
        if (this.boundingBox != null && !this.boundingBox.intersects(boundingBox)) {
            return;
        }
        Iterator<LatLong> iterator = this.latLongs.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        LatLong latLong = iterator.next();
        long mapSize = MercatorProjection.getMapSize((byte)zoomLevel, (int)this.displayModel.getTileSize());
        float x = (float)(MercatorProjection.longitudeToPixelX((double)latLong.longitude, (long)mapSize) - topLeftPoint.x);
        float y = (float)(MercatorProjection.latitudeToPixelY((double)latLong.latitude, (long)mapSize) - topLeftPoint.y);
        Path path = this.graphicFactory.createPath();
        path.moveTo(x, y);
        while (iterator.hasNext()) {
            latLong = iterator.next();
            x = (float)(MercatorProjection.longitudeToPixelX((double)latLong.longitude, (long)mapSize) - topLeftPoint.x);
            y = (float)(MercatorProjection.latitudeToPixelY((double)latLong.latitude, (long)mapSize) - topLeftPoint.y);
            path.lineTo(x, y);
        }
        if (this.keepAligned) {
            this.paintStroke.setBitmapShaderShift(topLeftPoint);
        }
        float strokeWidth = this.paintStroke.getStrokeWidth();
        if (this.strokeIncrease > 1.0) {
            float scale = (float)Math.pow(this.strokeIncrease, Math.max(zoomLevel - 12, 0));
            this.paintStroke.setStrokeWidth(strokeWidth * scale);
        }
        canvas.drawPath(path, this.paintStroke);
        this.paintStroke.setStrokeWidth(strokeWidth);
    }

    public List<LatLong> getLatLongs() {
        return this.latLongs;
    }

    public synchronized Paint getPaintStroke() {
        return this.paintStroke;
    }

    public synchronized double getStrokeIncrease() {
        return this.strokeIncrease;
    }

    public boolean isKeepAligned() {
        return this.keepAligned;
    }

    public synchronized void setPaintStroke(Paint paintStroke) {
        this.paintStroke = paintStroke;
    }

    public synchronized void setPoints(List<LatLong> points) {
        this.latLongs.clear();
        this.latLongs.addAll(points);
        this.updatePoints();
    }

    public synchronized void setStrokeIncrease(double strokeIncrease) {
        this.strokeIncrease = strokeIncrease;
    }

    private void updatePoints() {
        this.boundingBox = this.latLongs.isEmpty() ? null : new BoundingBox(this.latLongs);
    }
}

