/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.labels;

import java.util.ArrayList;
import java.util.List;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.mapelements.MapElementContainer;
import org.mapsforge.core.model.Tile;
import org.mapsforge.map.datastore.MapDataStore;
import org.mapsforge.map.datastore.MapReadResult;
import org.mapsforge.map.datastore.PointOfInterest;
import org.mapsforge.map.datastore.Way;
import org.mapsforge.map.layer.labels.LabelStore;
import org.mapsforge.map.layer.renderer.CanvasRasterer;
import org.mapsforge.map.layer.renderer.PolylineContainer;
import org.mapsforge.map.layer.renderer.RendererJob;
import org.mapsforge.map.layer.renderer.StandardRenderer;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.rendertheme.RenderContext;
import org.mapsforge.map.rendertheme.rule.RenderTheme;
import org.mapsforge.map.rendertheme.rule.RenderThemeFuture;

public class MapDataStoreLabelStore
implements LabelStore {
    final float textScale;
    final RenderThemeFuture renderThemeFuture;
    final StandardRenderer standardRenderer;
    final DisplayModel displayModel;

    public MapDataStoreLabelStore(MapDataStore mapDataStore, RenderThemeFuture renderThemeFuture, float textScale, DisplayModel displayModel, GraphicFactory graphicFactory) {
        this.textScale = textScale;
        this.renderThemeFuture = renderThemeFuture;
        this.standardRenderer = new StandardRenderer(mapDataStore, graphicFactory, true);
        this.displayModel = displayModel;
    }

    @Override
    public void clear() {
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public synchronized List<MapElementContainer> getVisibleItems(Tile upperLeft, Tile lowerRight) {
        try {
            RendererJob rendererJob = new RendererJob(upperLeft, this.standardRenderer.mapDataStore, this.renderThemeFuture, this.displayModel, this.textScale, true, true);
            RenderContext renderContext = new RenderContext(rendererJob, new CanvasRasterer(this.standardRenderer.graphicFactory));
            MapReadResult mapReadResult = this.standardRenderer.mapDataStore.readLabels(upperLeft, lowerRight);
            if (mapReadResult == null) {
                return new ArrayList<MapElementContainer>();
            }
            for (PointOfInterest pointOfInterest : mapReadResult.pointOfInterests) {
                renderContext.setDrawingLayers(pointOfInterest.layer);
                ((RenderTheme)renderContext.rendererJob.renderThemeFuture.get()).matchNode(this.standardRenderer, renderContext, pointOfInterest);
            }
            for (Way way : mapReadResult.ways) {
                PolylineContainer polylineContainer = new PolylineContainer(way, upperLeft, lowerRight);
                renderContext.setDrawingLayers(polylineContainer.getLayer());
                if (polylineContainer.isClosedWay()) {
                    renderContext.renderTheme.matchClosedWay(this.standardRenderer, renderContext, polylineContainer);
                    continue;
                }
                renderContext.renderTheme.matchLinearWay(this.standardRenderer, renderContext, polylineContainer);
            }
            return renderContext.labels;
        }
        catch (Exception e) {
            return new ArrayList<MapElementContainer>();
        }
    }
}

