/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.labels;

import java.util.Collections;
import java.util.List;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Matrix;
import org.mapsforge.core.mapelements.MapElementContainer;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Tile;
import org.mapsforge.map.layer.Layer;
import org.mapsforge.map.layer.labels.LabelStore;
import org.mapsforge.map.util.LayerUtil;

public class LabelLayer
extends Layer {
    protected final LabelStore labelStore;
    protected final Matrix matrix;
    protected List<MapElementContainer> elementsToDraw;
    protected Tile upperLeft;
    protected Tile lowerRight;
    protected int lastLabelStoreVersion;

    public LabelLayer(GraphicFactory graphicFactory, LabelStore labelStore) {
        this.labelStore = labelStore;
        this.matrix = graphicFactory.createMatrix();
        this.lastLabelStoreVersion = -1;
    }

    @Override
    public void draw(BoundingBox boundingBox, byte zoomLevel, Canvas canvas, Point topLeftPoint) {
        Tile newUpperLeft = LayerUtil.getUpperLeft(boundingBox, zoomLevel, this.displayModel.getTileSize());
        Tile newLowerRight = LayerUtil.getLowerRight(boundingBox, zoomLevel, this.displayModel.getTileSize());
        if (!newUpperLeft.equals((Object)this.upperLeft) || !newLowerRight.equals((Object)this.lowerRight) || this.lastLabelStoreVersion != this.labelStore.getVersion()) {
            this.upperLeft = newUpperLeft;
            this.lowerRight = newLowerRight;
            this.lastLabelStoreVersion = this.labelStore.getVersion();
            List<MapElementContainer> visibleItems = this.labelStore.getVisibleItems(this.upperLeft, this.lowerRight);
            this.elementsToDraw = LayerUtil.collisionFreeOrdered(visibleItems);
            Collections.sort(this.elementsToDraw);
        }
        this.draw(canvas, topLeftPoint);
    }

    protected void draw(Canvas canvas, Point topLeftPoint) {
        for (MapElementContainer item : this.elementsToDraw) {
            item.draw(canvas, topLeftPoint, this.matrix, this.displayModel.getFilter());
        }
    }
}

