/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.hills;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class SyncLazyFuture<X>
implements Future<X> {
    private static final ExecutionException STARTED = new DummyExecutionException("started");
    private static final ExecutionException CANCELLED = new DummyExecutionException("cancelled");
    private static final ExecutionException DONE = new DummyExecutionException("done");
    private volatile ExecutionException state = null;
    private volatile X result;
    private volatile Thread thread;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Thread t;
        if (this.state == CANCELLED) {
            return true;
        }
        if (this.state == DONE) {
            return false;
        }
        if (mayInterruptIfRunning && (t = this.thread) != null && this.state == STARTED) {
            this.state = CANCELLED;
            t.interrupt();
            return true;
        }
        boolean ret = this.state == null;
        this.state = CANCELLED;
        return ret;
    }

    @Override
    public boolean isCancelled() {
        return this.state == CANCELLED;
    }

    @Override
    public boolean isDone() {
        return this.state != null && this.state != STARTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public X get() throws InterruptedException, ExecutionException {
        SyncLazyFuture syncLazyFuture = this;
        synchronized (syncLazyFuture) {
            if (this.state == null) {
                this.state = STARTED;
                this.internalCalc();
            }
        }
        this.throwIfException();
        return this.result;
    }

    private void throwIfException() throws ExecutionException {
        ExecutionException executionException = this.state;
        if (executionException != null && !(executionException instanceof DummyExecutionException)) {
            throw executionException;
        }
    }

    @Override
    public X get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.wait();
        return this.get();
    }

    private void internalCalc() throws ExecutionException, InterruptedException {
        this.state = STARTED;
        try {
            this.thread = Thread.currentThread();
            this.result = this.calculate();
            this.state = DONE;
        }
        catch (RuntimeException e) {
            this.state = new ExecutionException(e);
        }
        catch (ExecutionException e) {
            this.state = e;
        }
        finally {
            this.thread = null;
        }
    }

    protected abstract X calculate() throws ExecutionException, InterruptedException;

    public SyncLazyFuture<X> withRunningThread() {
        if (this.state != null) {
            return this;
        }
        Thread thread = new Thread(this.getClass().getName() + ".withRunningThread"){

            @Override
            public void run() {
                try {
                    SyncLazyFuture.this.internalCalc();
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
        };
        thread.start();
        return this;
    }

    private static class DummyExecutionException
    extends ExecutionException {
        DummyExecutionException(String name) {
            super(name, null);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }

        @Override
        public String toString() {
            return "[state marker " + this.getMessage() + "]";
        }
    }
}

