/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer;

import java.util.HashSet;
import java.util.List;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.Matrix;
import org.mapsforge.core.graphics.TileBitmap;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Tile;
import org.mapsforge.core.util.Parameters;
import org.mapsforge.map.layer.Layer;
import org.mapsforge.map.layer.TilePosition;
import org.mapsforge.map.layer.cache.TileCache;
import org.mapsforge.map.layer.queue.Job;
import org.mapsforge.map.layer.queue.JobQueue;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.model.IMapViewPosition;
import org.mapsforge.map.util.LayerUtil;

public abstract class TileLayer<T extends Job>
extends Layer {
    private float alpha = 1.0f;
    protected final boolean hasJobQueue;
    protected final boolean isTransparent;
    protected JobQueue<T> jobQueue;
    protected final TileCache tileCache;
    private final IMapViewPosition mapViewPosition;
    private final Matrix matrix;
    private Parameters.ParentTilesRendering parentTilesRendering = Parameters.PARENT_TILES_RENDERING;

    public TileLayer(TileCache tileCache, IMapViewPosition mapViewPosition, Matrix matrix, boolean isTransparent) {
        this(tileCache, mapViewPosition, matrix, isTransparent, true);
    }

    public TileLayer(TileCache tileCache, IMapViewPosition mapViewPosition, Matrix matrix, boolean isTransparent, boolean hasJobQueue) {
        if (tileCache == null) {
            throw new IllegalArgumentException("tileCache must not be null");
        }
        if (mapViewPosition == null) {
            throw new IllegalArgumentException("mapViewPosition must not be null");
        }
        this.hasJobQueue = hasJobQueue;
        this.tileCache = tileCache;
        this.mapViewPosition = mapViewPosition;
        this.matrix = matrix;
        this.isTransparent = isTransparent;
    }

    @Override
    public void draw(BoundingBox boundingBox, byte zoomLevel, Canvas canvas, Point topLeftPoint) {
        List<TilePosition> tilePositions = LayerUtil.getTilePositions(boundingBox, zoomLevel, topLeftPoint, this.displayModel.getTileSize());
        canvas.resetClip();
        if (!this.isTransparent) {
            canvas.fillColor(this.displayModel.getBackgroundColor());
        }
        HashSet<Job> jobs = new HashSet<Job>();
        for (TilePosition tilePosition : tilePositions) {
            jobs.add((Job)this.createJob(tilePosition.tile));
        }
        this.tileCache.setWorkingSet(jobs);
        for (int i = tilePositions.size() - 1; i >= 0; --i) {
            TilePosition tilePosition;
            tilePosition = tilePositions.get(i);
            Point point = tilePosition.point;
            Tile tile = tilePosition.tile;
            T job = this.createJob(tile);
            TileBitmap bitmap = this.tileCache.getImmediately((Job)job);
            if (bitmap == null) {
                if (this.hasJobQueue && !this.tileCache.containsKey((Job)job)) {
                    this.jobQueue.add(job);
                }
                if (this.parentTilesRendering == Parameters.ParentTilesRendering.OFF) continue;
                this.drawParentTileBitmap(canvas, point, tile);
                continue;
            }
            if (this.isTileStale(tile, bitmap) && this.hasJobQueue && !this.tileCache.containsKey((Job)job)) {
                this.jobQueue.add(job);
            }
            this.retrieveLabelsOnly(job);
            canvas.drawBitmap((Bitmap)bitmap, (int)Math.round(point.x), (int)Math.round(point.y), this.alpha, this.displayModel.getFilter());
            bitmap.decrementRefCount();
        }
        if (this.hasJobQueue) {
            this.jobQueue.notifyWorkers();
        }
    }

    @Override
    public synchronized void setDisplayModel(DisplayModel displayModel) {
        super.setDisplayModel(displayModel);
        this.jobQueue = displayModel != null && this.hasJobQueue ? new JobQueue(this.mapViewPosition, this.displayModel) : null;
    }

    protected abstract T createJob(Tile var1);

    protected abstract boolean isTileStale(Tile var1, TileBitmap var2);

    protected void retrieveLabelsOnly(T job) {
    }

    private void drawParentTileBitmap(Canvas canvas, Point point, Tile tile) {
        TileBitmap bitmap;
        Tile cachedParentTile = this.getCachedParentTile(tile, 4);
        if (cachedParentTile != null && (bitmap = this.tileCache.getImmediately((Job)this.createJob(cachedParentTile))) != null) {
            int tileSize = this.displayModel.getTileSize();
            long translateX = tile.getShiftX(cachedParentTile) * tileSize;
            long translateY = tile.getShiftY(cachedParentTile) * tileSize;
            byte zoomLevelDiff = (byte)(tile.zoomLevel - cachedParentTile.zoomLevel);
            float scaleFactor = (float)Math.pow(2.0, zoomLevelDiff);
            int x = (int)Math.round(point.x);
            int y = (int)Math.round(point.y);
            if (this.parentTilesRendering == Parameters.ParentTilesRendering.SPEED) {
                boolean antiAlias = canvas.isAntiAlias();
                boolean filterBitmap = canvas.isFilterBitmap();
                canvas.setAntiAlias(false);
                canvas.setFilterBitmap(false);
                canvas.drawBitmap((Bitmap)bitmap, (int)((float)translateX / scaleFactor), (int)((float)translateY / scaleFactor), (int)((float)(translateX + (long)tileSize) / scaleFactor), (int)((float)(translateY + (long)tileSize) / scaleFactor), x, y, x + tileSize, y + tileSize, this.alpha, this.displayModel.getFilter());
                canvas.setAntiAlias(antiAlias);
                canvas.setFilterBitmap(filterBitmap);
            } else {
                this.matrix.reset();
                this.matrix.translate((float)((long)x - translateX), (float)((long)y - translateY));
                this.matrix.scale(scaleFactor, scaleFactor);
                canvas.setClip(x, y, this.displayModel.getTileSize(), this.displayModel.getTileSize());
                canvas.drawBitmap((Bitmap)bitmap, this.matrix, this.alpha, this.displayModel.getFilter());
                canvas.resetClip();
            }
            bitmap.decrementRefCount();
        }
    }

    public float getAlpha() {
        return this.alpha;
    }

    private Tile getCachedParentTile(Tile tile, int level) {
        if (level == 0) {
            return null;
        }
        Tile parentTile = tile.getParent();
        if (parentTile == null) {
            return null;
        }
        if (this.tileCache.containsKey((Job)this.createJob(parentTile))) {
            return parentTile;
        }
        return this.getCachedParentTile(parentTile, level - 1);
    }

    public TileCache getTileCache() {
        return this.tileCache;
    }

    public void setAlpha(float alpha) {
        this.alpha = Math.max(0.0f, Math.min(1.0f, alpha));
    }

    public void setParentTilesRendering(Parameters.ParentTilesRendering parentTilesRendering) {
        this.parentTilesRendering = parentTilesRendering;
    }
}

