/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.concurrent.CopyOnWriteArrayList;
import org.mapsforge.map.layer.Layer;
import org.mapsforge.map.layer.Redrawer;
import org.mapsforge.map.model.DisplayModel;

public class Layers
implements Iterable<Layer>,
RandomAccess {
    private final DisplayModel displayModel;
    private final Map<Integer, Integer> groupIndex;
    private final List<Integer> groupList;
    private final List<Layer> layersList;
    private final Redrawer redrawer;

    private static void checkIsNull(Collection<Layer> layers) {
        if (layers == null) {
            throw new IllegalArgumentException("layers must not be null");
        }
        for (Layer layer : layers) {
            Layers.checkIsNull(layer);
        }
    }

    private static void checkIsNull(Layer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("layer must not be null");
        }
    }

    Layers(Redrawer redrawer, DisplayModel displayModel) {
        this.redrawer = redrawer;
        this.displayModel = displayModel;
        this.groupIndex = new HashMap<Integer, Integer>();
        this.groupList = new ArrayList<Integer>();
        this.layersList = new CopyOnWriteArrayList<Layer>();
    }

    public synchronized void add(int index, Layer layer) {
        this.add(index, layer, true);
    }

    public synchronized void add(int index, Layer layer, boolean redraw) {
        Layers.checkIsNull(layer);
        layer.setDisplayModel(this.displayModel);
        this.layersList.add(index, layer);
        layer.assign(this.redrawer);
        if (redraw) {
            this.redrawer.redrawLayers();
        }
    }

    public synchronized void add(Layer layer) {
        this.add(layer, true);
    }

    public synchronized void add(Layer layer, boolean redraw) {
        Layers.checkIsNull(layer);
        layer.setDisplayModel(this.displayModel);
        this.layersList.add(layer);
        layer.assign(this.redrawer);
        if (redraw) {
            this.redrawer.redrawLayers();
        }
    }

    public synchronized void add(Layer layer, int group) {
        this.add(layer, group, true);
    }

    public synchronized void add(Layer layer, int group, boolean redraw) {
        int index = this.groupList.indexOf(group);
        if (index < 0) {
            throw new IllegalArgumentException("unknown layer group");
        }
        if (++index == this.groupList.size()) {
            this.add(layer, redraw);
        } else {
            this.add(this.groupIndex.get(this.groupList.get(index)), layer, redraw);
            for (int i = index; i < this.groupList.size(); ++i) {
                group = this.groupList.get(i);
                this.groupIndex.put(group, this.groupIndex.get(group) + 1);
            }
        }
    }

    public synchronized boolean addAll(Collection<Layer> layers) {
        return this.addAll(layers, true);
    }

    public synchronized boolean addAll(Collection<Layer> layers, boolean redraw) {
        Layers.checkIsNull(layers);
        for (Layer layer : layers) {
            layer.setDisplayModel(this.displayModel);
        }
        if (this.layersList.addAll(layers)) {
            for (Layer layer : layers) {
                layer.assign(this.redrawer);
            }
            if (redraw) {
                this.redrawer.redrawLayers();
            }
            return true;
        }
        return false;
    }

    public synchronized boolean addAll(int index, Collection<Layer> layers) {
        return this.addAll(index, layers, true);
    }

    public synchronized boolean addAll(int index, Collection<Layer> layers, boolean redraw) {
        Layers.checkIsNull(layers);
        if (this.layersList.addAll(index, layers)) {
            for (Layer layer : layers) {
                layer.setDisplayModel(this.displayModel);
                layer.assign(this.redrawer);
            }
            if (redraw) {
                this.redrawer.redrawLayers();
            }
            return true;
        }
        return false;
    }

    public synchronized boolean addAll(Collection<Layer> layers, int group) {
        return this.addAll(layers, group, true);
    }

    public synchronized boolean addAll(Collection<Layer> layers, int group, boolean redraw) {
        int index = this.groupList.indexOf(group);
        if (index < 0) {
            throw new IllegalArgumentException("unknown layer group");
        }
        if (++index == this.groupList.size()) {
            return this.addAll(layers, redraw);
        }
        if (this.addAll(this.groupIndex.get(this.groupList.get(index)), layers, redraw)) {
            for (int i = index; i < this.groupList.size(); ++i) {
                group = this.groupList.get(i);
                this.groupIndex.put(group, this.groupIndex.get(group) + layers.size());
            }
            return true;
        }
        return false;
    }

    public synchronized void addGroup(int group) {
        if (this.groupList.contains(group)) {
            throw new IllegalArgumentException("group added twice");
        }
        this.groupList.add(group);
        this.groupIndex.put(group, this.layersList.size());
    }

    public synchronized void clear() {
        this.clear(true);
    }

    public synchronized void clear(boolean redraw) {
        for (Layer layer : this.layersList) {
            layer.unassign();
        }
        this.layersList.clear();
        if (redraw) {
            this.redrawer.redrawLayers();
        }
    }

    public synchronized boolean contains(Layer layer) {
        Layers.checkIsNull(layer);
        return this.layersList.contains(layer);
    }

    public synchronized Layer get(int index) {
        return this.layersList.get(index);
    }

    public synchronized int indexOf(Layer layer) {
        Layers.checkIsNull(layer);
        return this.layersList.indexOf(layer);
    }

    public synchronized boolean isEmpty() {
        return this.layersList.isEmpty();
    }

    @Override
    public synchronized Iterator<Layer> iterator() {
        return this.layersList.iterator();
    }

    public synchronized Layer remove(int index) {
        return this.remove(index, true);
    }

    public synchronized Layer remove(int index, boolean redraw) {
        Layer layer = this.layersList.remove(index);
        layer.unassign();
        for (Integer group : this.groupIndex.keySet()) {
            int pointer = this.groupIndex.get(group);
            if (pointer <= index) continue;
            this.groupIndex.put(group, pointer - 1);
        }
        if (redraw) {
            this.redrawer.redrawLayers();
        }
        return layer;
    }

    public synchronized boolean remove(Layer layer) {
        return this.remove(layer, true);
    }

    public synchronized boolean remove(Layer layer, boolean redraw) {
        Layers.checkIsNull(layer);
        int index = this.layersList.indexOf(layer);
        if (this.layersList.remove(layer)) {
            layer.unassign();
            for (Integer group : this.groupIndex.keySet()) {
                int pointer = this.groupIndex.get(group);
                if (pointer <= index) continue;
                this.groupIndex.put(group, pointer - 1);
            }
            if (redraw) {
                this.redrawer.redrawLayers();
            }
            return true;
        }
        return false;
    }

    public synchronized boolean removeAll(Collection<Layer> layers) {
        return this.removeAll(layers, true);
    }

    public synchronized boolean removeAll(Collection<Layer> layers, boolean redraw) {
        Layers.checkIsNull(layers);
        int[] indexes = new int[layers.size()];
        int i = 0;
        for (Layer layer : layers) {
            indexes[i++] = this.layersList.indexOf(layer);
        }
        if (this.layersList.removeAll(layers)) {
            for (Layer layer : layers) {
                layer.unassign();
            }
            for (Object index : (Object)indexes) {
                for (Integer group : this.groupIndex.keySet()) {
                    int pointer = this.groupIndex.get(group);
                    if (pointer <= index) continue;
                    this.groupIndex.put(group, pointer - 1);
                }
            }
            if (redraw) {
                this.redrawer.redrawLayers();
            }
            return true;
        }
        return false;
    }

    public synchronized int size() {
        return this.layersList.size();
    }
}

