/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import org.mapsforge.map.rendertheme.XmlUtils;
import org.mapsforge.map.rendertheme.rule.AnyMatcher;
import org.mapsforge.map.rendertheme.rule.AttributeMatcher;
import org.mapsforge.map.rendertheme.rule.Closed;
import org.mapsforge.map.rendertheme.rule.ClosedMatcher;
import org.mapsforge.map.rendertheme.rule.ClosedWayMatcher;
import org.mapsforge.map.rendertheme.rule.Element;
import org.mapsforge.map.rendertheme.rule.ElementMatcher;
import org.mapsforge.map.rendertheme.rule.ElementNodeMatcher;
import org.mapsforge.map.rendertheme.rule.ElementWayMatcher;
import org.mapsforge.map.rendertheme.rule.KeyMatcher;
import org.mapsforge.map.rendertheme.rule.LinearWayMatcher;
import org.mapsforge.map.rendertheme.rule.NegativeMatcher;
import org.mapsforge.map.rendertheme.rule.NegativeRule;
import org.mapsforge.map.rendertheme.rule.PositiveRule;
import org.mapsforge.map.rendertheme.rule.Rule;
import org.mapsforge.map.rendertheme.rule.RuleOptimizer;
import org.mapsforge.map.rendertheme.rule.ValueMatcher;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RuleBuilder {
    private static final String CAT = "cat";
    private static final String CLOSED = "closed";
    private static final String E = "e";
    private static final String K = "k";
    private static final Pattern SPLIT_PATTERN = Pattern.compile("\\|");
    private static final String STRING_NEGATION = "~";
    private static final String STRING_WILDCARD = "*";
    private static final String V = "v";
    private static final String ZOOM_MAX = "zoom-max";
    private static final String ZOOM_MIN = "zoom-min";
    String cat;
    ClosedMatcher closedMatcher;
    ElementMatcher elementMatcher;
    byte zoomMax;
    byte zoomMin;
    private Closed closed;
    private Element element;
    private List<String> keyList;
    private String keys;
    private final Stack<Rule> ruleStack;
    private List<String> valueList;
    private String values;

    private static ClosedMatcher getClosedMatcher(Closed closed) {
        switch (closed) {
            case YES: {
                return ClosedWayMatcher.INSTANCE;
            }
            case NO: {
                return LinearWayMatcher.INSTANCE;
            }
            case ANY: {
                return AnyMatcher.INSTANCE;
            }
        }
        throw new IllegalArgumentException("unknown closed value: " + (Object)((Object)closed));
    }

    private static ElementMatcher getElementMatcher(Element element) {
        switch (element) {
            case NODE: {
                return ElementNodeMatcher.INSTANCE;
            }
            case WAY: {
                return ElementWayMatcher.INSTANCE;
            }
            case ANY: {
                return AnyMatcher.INSTANCE;
            }
        }
        throw new IllegalArgumentException("unknown element value: " + (Object)((Object)element));
    }

    private static AttributeMatcher getKeyMatcher(List<String> keyList) {
        if (STRING_WILDCARD.equals(keyList.get(0))) {
            return AnyMatcher.INSTANCE;
        }
        AttributeMatcher attributeMatcher = Rule.MATCHERS_CACHE_KEY.get(keyList);
        if (attributeMatcher == null) {
            attributeMatcher = new KeyMatcher(keyList);
            Rule.MATCHERS_CACHE_KEY.put(keyList, attributeMatcher);
        }
        return attributeMatcher;
    }

    private static AttributeMatcher getValueMatcher(List<String> valueList) {
        if (STRING_WILDCARD.equals(valueList.get(0))) {
            return AnyMatcher.INSTANCE;
        }
        AttributeMatcher attributeMatcher = Rule.MATCHERS_CACHE_VALUE.get(valueList);
        if (attributeMatcher == null) {
            attributeMatcher = new ValueMatcher(valueList);
            Rule.MATCHERS_CACHE_VALUE.put(valueList, attributeMatcher);
        }
        return attributeMatcher;
    }

    public RuleBuilder(String elementName, XmlPullParser pullParser, Stack<Rule> ruleStack) throws XmlPullParserException {
        this.ruleStack = ruleStack;
        this.closed = Closed.ANY;
        this.zoomMin = 0;
        this.zoomMax = (byte)127;
        this.extractValues(elementName, pullParser);
    }

    public Rule build() {
        if (this.valueList.remove(STRING_NEGATION)) {
            NegativeMatcher attributeMatcher = new NegativeMatcher(this.keyList, this.valueList);
            return new NegativeRule(this, attributeMatcher);
        }
        AttributeMatcher keyMatcher = RuleBuilder.getKeyMatcher(this.keyList);
        AttributeMatcher valueMatcher = RuleBuilder.getValueMatcher(this.valueList);
        keyMatcher = RuleOptimizer.optimize(keyMatcher, this.ruleStack);
        valueMatcher = RuleOptimizer.optimize(valueMatcher, this.ruleStack);
        return new PositiveRule(this, keyMatcher, valueMatcher);
    }

    private void extractValues(String elementName, XmlPullParser pullParser) throws XmlPullParserException {
        for (int i = 0; i < pullParser.getAttributeCount(); ++i) {
            String name = pullParser.getAttributeName(i);
            String value = pullParser.getAttributeValue(i);
            if (E.equals(name)) {
                this.element = Element.fromString(value);
                continue;
            }
            if (K.equals(name)) {
                this.keys = value;
                continue;
            }
            if (V.equals(name)) {
                this.values = value;
                continue;
            }
            if (CAT.equals(name)) {
                this.cat = value;
                continue;
            }
            if (CLOSED.equals(name)) {
                this.closed = Closed.fromString(value);
                continue;
            }
            if (ZOOM_MIN.equals(name)) {
                this.zoomMin = XmlUtils.parseNonNegativeByte(name, value);
                continue;
            }
            if (ZOOM_MAX.equals(name)) {
                this.zoomMax = XmlUtils.parseNonNegativeByte(name, value);
                continue;
            }
            throw XmlUtils.createXmlPullParserException(elementName, name, value, i);
        }
        this.validate(elementName);
        this.keyList = new ArrayList<String>(Arrays.asList(SPLIT_PATTERN.split(this.keys)));
        this.valueList = new ArrayList<String>(Arrays.asList(SPLIT_PATTERN.split(this.values)));
        this.elementMatcher = RuleBuilder.getElementMatcher(this.element);
        this.closedMatcher = RuleBuilder.getClosedMatcher(this.closed);
        this.elementMatcher = RuleOptimizer.optimize(this.elementMatcher, this.ruleStack);
        this.closedMatcher = RuleOptimizer.optimize(this.closedMatcher, this.ruleStack);
    }

    private void validate(String elementName) throws XmlPullParserException {
        XmlUtils.checkMandatoryAttribute(elementName, E, (Object)this.element);
        XmlUtils.checkMandatoryAttribute(elementName, K, this.keys);
        XmlUtils.checkMandatoryAttribute(elementName, V, this.values);
        if (this.zoomMin > this.zoomMax) {
            throw new XmlPullParserException("'zoom-min' > 'zoom-max': " + this.zoomMin + ' ' + this.zoomMax);
        }
    }
}

