/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme.renderinstruction;

import java.util.HashMap;
import java.util.Map;
import org.mapsforge.core.graphics.Align;
import org.mapsforge.core.graphics.Color;
import org.mapsforge.core.graphics.Display;
import org.mapsforge.core.graphics.FontFamily;
import org.mapsforge.core.graphics.FontStyle;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.graphics.Style;
import org.mapsforge.map.datastore.PointOfInterest;
import org.mapsforge.map.layer.renderer.PolylineContainer;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.rendertheme.RenderCallback;
import org.mapsforge.map.rendertheme.RenderContext;
import org.mapsforge.map.rendertheme.XmlUtils;
import org.mapsforge.map.rendertheme.renderinstruction.RenderInstruction;
import org.mapsforge.map.rendertheme.renderinstruction.TextKey;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PathText
extends RenderInstruction {
    private static final float REPEAT_GAP_DEFAULT = 100.0f;
    private static final float REPEAT_START_DEFAULT = 10.0f;
    private Display display;
    private float dy;
    private final Map<Byte, Float> dyScaled;
    private final Paint fill;
    private final Map<Byte, Paint> fills;
    private float fontSize;
    private int priority;
    private RenderInstruction.Scale scale = RenderInstruction.Scale.STROKE;
    private final Paint stroke;
    private final Map<Byte, Paint> strokes;
    private boolean repeat;
    private float repeatGap;
    private float repeatStart;
    private boolean rotate;
    private TextKey textKey;

    public PathText(GraphicFactory graphicFactory, DisplayModel displayModel, String elementName, XmlPullParser pullParser) throws XmlPullParserException {
        super(graphicFactory, displayModel);
        this.fill = graphicFactory.createPaint();
        this.fill.setColor(Color.BLACK);
        this.fill.setStyle(Style.FILL);
        this.fill.setTextAlign(Align.CENTER);
        this.fills = new HashMap<Byte, Paint>();
        this.rotate = true;
        this.repeat = true;
        this.stroke = graphicFactory.createPaint();
        this.stroke.setColor(Color.BLACK);
        this.stroke.setStyle(Style.STROKE);
        this.stroke.setTextAlign(Align.CENTER);
        this.strokes = new HashMap<Byte, Paint>();
        this.dyScaled = new HashMap<Byte, Float>();
        this.display = Display.IFSPACE;
        this.extractValues(graphicFactory, displayModel, elementName, pullParser);
    }

    @Override
    public void destroy() {
    }

    private void extractValues(GraphicFactory graphicFactory, DisplayModel displayModel, String elementName, XmlPullParser pullParser) throws XmlPullParserException {
        this.repeatGap = 100.0f * displayModel.getScaleFactor();
        this.repeatStart = 10.0f * displayModel.getScaleFactor();
        FontFamily fontFamily = FontFamily.DEFAULT;
        FontStyle fontStyle = FontStyle.NORMAL;
        for (int i = 0; i < pullParser.getAttributeCount(); ++i) {
            String name = pullParser.getAttributeName(i);
            String value = pullParser.getAttributeValue(i);
            if ("k".equals(name)) {
                this.textKey = TextKey.getInstance(value);
                continue;
            }
            if ("cat".equals(name)) {
                this.category = value;
                continue;
            }
            if ("display".equals(name)) {
                this.display = Display.fromString((String)value);
                continue;
            }
            if ("dy".equals(name)) {
                this.dy = Float.parseFloat(value) * displayModel.getScaleFactor();
                continue;
            }
            if ("fill".equals(name)) {
                this.fill.setColor(XmlUtils.getColor(graphicFactory, value, displayModel.getThemeCallback(), this));
                continue;
            }
            if ("font-family".equals(name)) {
                fontFamily = FontFamily.fromString((String)value);
                continue;
            }
            if ("font-size".equals(name)) {
                this.fontSize = XmlUtils.parseNonNegativeFloat(name, value) * displayModel.getScaleFactor();
                continue;
            }
            if ("font-style".equals(name)) {
                fontStyle = FontStyle.fromString((String)value);
                continue;
            }
            if ("repeat".equals(name)) {
                this.repeat = Boolean.parseBoolean(value);
                continue;
            }
            if ("repeat-gap".equals(name)) {
                this.repeatGap = Float.parseFloat(value) * displayModel.getScaleFactor();
                continue;
            }
            if ("repeat-start".equals(name)) {
                this.repeatStart = Float.parseFloat(value) * displayModel.getScaleFactor();
                continue;
            }
            if ("rotate".equals(name)) {
                this.rotate = Boolean.parseBoolean(value);
                continue;
            }
            if ("priority".equals(name)) {
                this.priority = Integer.parseInt(value);
                continue;
            }
            if ("scale".equals(name)) {
                this.scale = this.scaleFromValue(value);
                continue;
            }
            if ("stroke".equals(name)) {
                this.stroke.setColor(XmlUtils.getColor(graphicFactory, value, displayModel.getThemeCallback(), this));
                continue;
            }
            if ("stroke-width".equals(name)) {
                this.stroke.setStrokeWidth(XmlUtils.parseNonNegativeFloat(name, value) * displayModel.getScaleFactor());
                continue;
            }
            throw XmlUtils.createXmlPullParserException(elementName, name, value, i);
        }
        this.fill.setTypeface(fontFamily, fontStyle);
        this.stroke.setTypeface(fontFamily, fontStyle);
        XmlUtils.checkMandatoryAttribute(elementName, "k", this.textKey);
    }

    private Paint getFillPaint(byte zoomLevel) {
        Paint paint = this.fills.get(zoomLevel);
        if (paint == null) {
            paint = this.fill;
        }
        return paint;
    }

    private Paint getStrokePaint(byte zoomLevel) {
        Paint paint = this.strokes.get(zoomLevel);
        if (paint == null) {
            paint = this.stroke;
        }
        return paint;
    }

    @Override
    public void renderNode(RenderCallback renderCallback, RenderContext renderContext, PointOfInterest poi) {
    }

    @Override
    public void renderWay(RenderCallback renderCallback, RenderContext renderContext, PolylineContainer way) {
        if (Display.NEVER == this.display) {
            return;
        }
        String caption = this.textKey.getValue(way.getTags());
        if (caption == null) {
            return;
        }
        Float dyScale = this.dyScaled.get(renderContext.rendererJob.tile.zoomLevel);
        if (dyScale == null) {
            dyScale = Float.valueOf(this.dy);
        }
        renderCallback.renderWayText(renderContext, this.display, this.priority, caption, dyScale.floatValue(), this.getFillPaint(renderContext.rendererJob.tile.zoomLevel), this.getStrokePaint(renderContext.rendererJob.tile.zoomLevel), this.repeat, this.repeatGap, this.repeatStart, this.rotate, way);
    }

    @Override
    public void scaleStrokeWidth(float scaleFactor, byte zoomLevel) {
        if (this.scale == RenderInstruction.Scale.NONE) {
            scaleFactor = 1.0f;
        }
        this.dyScaled.put(zoomLevel, Float.valueOf(this.dy * scaleFactor));
    }

    @Override
    public void scaleTextSize(float scaleFactor, byte zoomLevel) {
        Paint zlPaint = this.graphicFactory.createPaint(this.fill);
        zlPaint.setTextSize(this.fontSize * scaleFactor);
        this.fills.put(zoomLevel, zlPaint);
        Paint zlStroke = this.graphicFactory.createPaint(this.stroke);
        zlStroke.setTextSize(this.fontSize * scaleFactor);
        this.strokes.put(zoomLevel, zlStroke);
    }
}

