/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme.renderinstruction;

import java.util.HashMap;
import java.util.Map;
import org.mapsforge.core.graphics.Align;
import org.mapsforge.core.graphics.Color;
import org.mapsforge.core.graphics.Display;
import org.mapsforge.core.graphics.FontFamily;
import org.mapsforge.core.graphics.FontStyle;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.graphics.Position;
import org.mapsforge.core.graphics.Style;
import org.mapsforge.core.model.Rectangle;
import org.mapsforge.map.datastore.PointOfInterest;
import org.mapsforge.map.layer.renderer.PolylineContainer;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.rendertheme.RenderCallback;
import org.mapsforge.map.rendertheme.RenderContext;
import org.mapsforge.map.rendertheme.XmlUtils;
import org.mapsforge.map.rendertheme.renderinstruction.RenderInstruction;
import org.mapsforge.map.rendertheme.renderinstruction.Symbol;
import org.mapsforge.map.rendertheme.renderinstruction.TextKey;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class Caption
extends RenderInstruction {
    public static final float DEFAULT_GAP = 5.0f;
    private Rectangle boundary;
    private Display display;
    private float dy;
    private final Map<Byte, Float> dyScaled;
    private final Paint fill;
    private final Map<Byte, Paint> fills;
    private float fontSize;
    private final float gap;
    private final int maxTextWidth;
    private Position position;
    private int priority;
    private final Paint stroke;
    private final Map<Byte, Paint> strokes;
    private String symbolId;
    private TextKey textKey;

    public Caption(GraphicFactory graphicFactory, DisplayModel displayModel, String elementName, XmlPullParser pullParser, Map<String, Symbol> symbols) throws XmlPullParserException {
        super(graphicFactory, displayModel);
        Symbol symbol;
        this.fill = graphicFactory.createPaint();
        this.fill.setColor(Color.BLACK);
        this.fill.setStyle(Style.FILL);
        this.fills = new HashMap<Byte, Paint>();
        this.stroke = graphicFactory.createPaint();
        this.stroke.setColor(Color.BLACK);
        this.stroke.setStyle(Style.STROKE);
        this.strokes = new HashMap<Byte, Paint>();
        this.dyScaled = new HashMap<Byte, Float>();
        this.display = Display.IFSPACE;
        this.gap = 5.0f * displayModel.getScaleFactor();
        this.extractValues(graphicFactory, displayModel, elementName, pullParser);
        if (this.symbolId != null && (symbol = symbols.get(this.symbolId)) != null) {
            this.boundary = symbol.getBoundary();
        }
        if (this.position == null) {
            this.position = this.boundary == null ? Position.CENTER : Position.BELOW;
        }
        switch (this.position) {
            case CENTER: 
            case BELOW: 
            case ABOVE: {
                this.stroke.setTextAlign(Align.CENTER);
                this.fill.setTextAlign(Align.CENTER);
                break;
            }
            case BELOW_LEFT: 
            case ABOVE_LEFT: 
            case LEFT: {
                this.stroke.setTextAlign(Align.RIGHT);
                this.fill.setTextAlign(Align.RIGHT);
                break;
            }
            case BELOW_RIGHT: 
            case ABOVE_RIGHT: 
            case RIGHT: {
                this.stroke.setTextAlign(Align.LEFT);
                this.fill.setTextAlign(Align.LEFT);
                break;
            }
            default: {
                throw new IllegalArgumentException("Position invalid");
            }
        }
        this.maxTextWidth = displayModel.getMaxTextWidth();
    }

    private float computeHorizontalOffset() {
        if (this.position.isOnRightSide()) {
            return (float)(this.boundary.right + (double)this.gap);
        }
        if (this.position.isOnLeftSide()) {
            return (float)(this.boundary.left - (double)this.gap);
        }
        return (float)((this.boundary.right + this.boundary.left) / 2.0);
    }

    private float computeVerticalOffset(byte zoomLevel) {
        float verticalOffset = this.dyScaled.get(zoomLevel).floatValue();
        verticalOffset = this.position.isOnUpperSide() ? (float)((double)verticalOffset + (this.boundary.top - (double)this.gap)) : (this.position.isOnLowerSide() ? (float)((double)verticalOffset + (this.boundary.bottom + (double)this.gap)) : (float)((double)verticalOffset + (this.boundary.top + this.boundary.bottom) / 2.0));
        return verticalOffset;
    }

    @Override
    public void destroy() {
    }

    private void extractValues(GraphicFactory graphicFactory, DisplayModel displayModel, String elementName, XmlPullParser pullParser) throws XmlPullParserException {
        FontFamily fontFamily = FontFamily.DEFAULT;
        FontStyle fontStyle = FontStyle.NORMAL;
        for (int i = 0; i < pullParser.getAttributeCount(); ++i) {
            String name = pullParser.getAttributeName(i);
            String value = pullParser.getAttributeValue(i);
            if ("k".equals(name)) {
                this.textKey = TextKey.getInstance(value);
                continue;
            }
            if ("cat".equals(name)) {
                this.category = value;
                continue;
            }
            if ("display".equals(name)) {
                this.display = Display.fromString((String)value);
                continue;
            }
            if ("dy".equals(name)) {
                this.dy = Float.parseFloat(value) * displayModel.getScaleFactor();
                continue;
            }
            if ("fill".equals(name)) {
                this.fill.setColor(XmlUtils.getColor(graphicFactory, value, displayModel.getThemeCallback(), this));
                continue;
            }
            if ("font-family".equals(name)) {
                fontFamily = FontFamily.fromString((String)value);
                continue;
            }
            if ("font-size".equals(name)) {
                this.fontSize = XmlUtils.parseNonNegativeFloat(name, value) * displayModel.getScaleFactor();
                continue;
            }
            if ("font-style".equals(name)) {
                fontStyle = FontStyle.fromString((String)value);
                continue;
            }
            if ("position".equals(name)) {
                this.position = Position.fromString((String)value);
                continue;
            }
            if ("priority".equals(name)) {
                this.priority = Integer.parseInt(value);
                continue;
            }
            if ("stroke".equals(name)) {
                this.stroke.setColor(XmlUtils.getColor(graphicFactory, value, displayModel.getThemeCallback(), this));
                continue;
            }
            if ("stroke-width".equals(name)) {
                this.stroke.setStrokeWidth(XmlUtils.parseNonNegativeFloat(name, value) * displayModel.getScaleFactor());
                continue;
            }
            if ("symbol-id".equals(name)) {
                this.symbolId = value;
                continue;
            }
            throw XmlUtils.createXmlPullParserException(elementName, name, value, i);
        }
        this.fill.setTypeface(fontFamily, fontStyle);
        this.stroke.setTypeface(fontFamily, fontStyle);
        XmlUtils.checkMandatoryAttribute(elementName, "k", this.textKey);
    }

    private Paint getFillPaint(byte zoomLevel) {
        Paint paint = this.fills.get(zoomLevel);
        if (paint == null) {
            paint = this.fill;
        }
        return paint;
    }

    private Paint getStrokePaint(byte zoomLevel) {
        Paint paint = this.strokes.get(zoomLevel);
        if (paint == null) {
            paint = this.stroke;
        }
        return paint;
    }

    @Override
    public void renderNode(RenderCallback renderCallback, RenderContext renderContext, PointOfInterest poi) {
        if (Display.NEVER == this.display) {
            return;
        }
        String caption = this.textKey.getValue(poi.tags);
        if (caption == null) {
            return;
        }
        float horizontalOffset = 0.0f;
        Float verticalOffset = this.dyScaled.get(renderContext.rendererJob.tile.zoomLevel);
        if (verticalOffset == null) {
            verticalOffset = Float.valueOf(this.dy);
        }
        if (this.boundary != null) {
            horizontalOffset = this.computeHorizontalOffset();
            verticalOffset = Float.valueOf(this.computeVerticalOffset(renderContext.rendererJob.tile.zoomLevel));
        }
        renderCallback.renderPointOfInterestCaption(renderContext, this.display, this.priority, caption, horizontalOffset, verticalOffset.floatValue(), this.getFillPaint(renderContext.rendererJob.tile.zoomLevel), this.getStrokePaint(renderContext.rendererJob.tile.zoomLevel), this.position, this.maxTextWidth, poi);
    }

    @Override
    public void renderWay(RenderCallback renderCallback, RenderContext renderContext, PolylineContainer way) {
        if (Display.NEVER == this.display) {
            return;
        }
        String caption = this.textKey.getValue(way.getTags());
        if (caption == null) {
            return;
        }
        float horizontalOffset = 0.0f;
        Float verticalOffset = this.dyScaled.get(renderContext.rendererJob.tile.zoomLevel);
        if (verticalOffset == null) {
            verticalOffset = Float.valueOf(this.dy);
        }
        if (this.boundary != null) {
            horizontalOffset = this.computeHorizontalOffset();
            verticalOffset = Float.valueOf(this.computeVerticalOffset(renderContext.rendererJob.tile.zoomLevel));
        }
        renderCallback.renderAreaCaption(renderContext, this.display, this.priority, caption, horizontalOffset, verticalOffset.floatValue(), this.getFillPaint(renderContext.rendererJob.tile.zoomLevel), this.getStrokePaint(renderContext.rendererJob.tile.zoomLevel), this.position, this.maxTextWidth, way);
    }

    @Override
    public void scaleStrokeWidth(float scaleFactor, byte zoomLevel) {
    }

    @Override
    public void scaleTextSize(float scaleFactor, byte zoomLevel) {
        Paint f = this.graphicFactory.createPaint(this.fill);
        f.setTextSize(this.fontSize * scaleFactor);
        this.fills.put(zoomLevel, f);
        Paint s = this.graphicFactory.createPaint(this.stroke);
        s.setTextSize(this.fontSize * scaleFactor);
        this.strokes.put(zoomLevel, s);
        this.dyScaled.put(zoomLevel, Float.valueOf(this.dy * scaleFactor));
    }
}

