/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.renderer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mapsforge.core.mapelements.MapElementContainer;
import org.mapsforge.core.model.Tile;

public class TileDependencies {
    Map<Tile, Map<Tile, Set<MapElementContainer>>> overlapData = new HashMap<Tile, Map<Tile, Set<MapElementContainer>>>();
    Set<Tile> tilesInProgress = new HashSet<Tile>();

    TileDependencies() {
    }

    void addOverlappingElement(Tile from, Tile to, MapElementContainer element) {
        if (!this.overlapData.containsKey(from)) {
            this.overlapData.put(from, new HashMap());
        }
        if (!this.overlapData.get(from).containsKey(to)) {
            this.overlapData.get(from).put(to, new HashSet());
        }
        this.overlapData.get(from).get(to).add(element);
    }

    Set<MapElementContainer> getOverlappingElements(Tile from, Tile to) {
        if (this.overlapData.containsKey(from) && this.overlapData.get(from).containsKey(to)) {
            return this.overlapData.get(from).get(to);
        }
        return new HashSet<MapElementContainer>(0);
    }

    void removeTileData(Tile from) {
        this.overlapData.remove(from);
    }

    void removeTileData(Tile from, Tile to) {
        if (this.overlapData.containsKey(from)) {
            this.overlapData.get(from).remove(to);
        }
    }

    synchronized boolean isTileInProgress(Tile tile) {
        return this.tilesInProgress.contains(tile);
    }

    synchronized void addTileInProgress(Tile tileInProgress) {
        this.tilesInProgress.add(tileInProgress);
    }

    synchronized void removeTileInProgress(Tile tileFinished) {
        this.tilesInProgress.remove(tileFinished);
    }
}

