/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.queue;

import java.util.Collection;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.MapPosition;
import org.mapsforge.core.model.Tile;
import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.map.layer.queue.Job;
import org.mapsforge.map.layer.queue.QueueItem;

final class QueueItemScheduler {
    static final double PENALTY_PER_ZOOM_LEVEL = 10.0;

    static <T extends Job> void schedule(Collection<QueueItem<T>> queueItems, MapPosition mapPosition, int tileSize) {
        for (QueueItem<T> queueItem : queueItems) {
            queueItem.setPriority(QueueItemScheduler.calculatePriority(((Job)queueItem.object).tile, mapPosition, tileSize));
        }
    }

    private static double calculatePriority(Tile tile, MapPosition mapPosition, int tileSize) {
        double tileLatitude = MercatorProjection.tileYToLatitude((long)tile.tileY, (byte)tile.zoomLevel);
        double tileLongitude = MercatorProjection.tileXToLongitude((long)tile.tileX, (byte)tile.zoomLevel);
        int halfTileSize = tileSize / 2;
        long mapSize = MercatorProjection.getMapSize((byte)mapPosition.zoomLevel, (int)tileSize);
        double tilePixelX = MercatorProjection.longitudeToPixelX((double)tileLongitude, (long)mapSize) + (double)halfTileSize;
        double tilePixelY = MercatorProjection.latitudeToPixelY((double)tileLatitude, (long)mapSize) + (double)halfTileSize;
        LatLong latLong = mapPosition.latLong;
        double mapPixelX = MercatorProjection.longitudeToPixelX((double)latLong.longitude, (long)mapSize);
        double mapPixelY = MercatorProjection.latitudeToPixelY((double)latLong.latitude, (long)mapSize);
        double diffPixel = Math.hypot(tilePixelX - mapPixelX, tilePixelY - mapPixelY);
        int diffZoom = Math.abs(tile.zoomLevel - mapPosition.zoomLevel);
        return diffPixel + 10.0 * (double)tileSize * (double)diffZoom;
    }

    private QueueItemScheduler() {
        throw new IllegalStateException();
    }
}

