/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.hills;

import java.io.File;
import java.util.concurrent.ExecutionException;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.HillshadingBitmap;
import org.mapsforge.map.layer.hills.HgtCache;
import org.mapsforge.map.layer.hills.ShadeTileSource;
import org.mapsforge.map.layer.hills.ShadingAlgorithm;

public class MemoryCachingHgtReaderTileSource
implements ShadeTileSource {
    private final GraphicFactory graphicsFactory;
    private HgtCache currentCache;
    private int mainCacheSize = 4;
    private int neighborCacheSize = 4;
    private boolean enableInterpolationOverlap = true;
    private File demFolder;
    private ShadingAlgorithm algorithm;
    private boolean configurationChangePending = true;

    public MemoryCachingHgtReaderTileSource(File demFolder, ShadingAlgorithm algorithm, GraphicFactory graphicsFactory) {
        this(graphicsFactory);
        this.demFolder = demFolder;
        this.algorithm = algorithm;
    }

    public MemoryCachingHgtReaderTileSource(GraphicFactory graphicsFactory) {
        this.graphicsFactory = graphicsFactory;
    }

    @Override
    public void applyConfiguration(boolean allowParallel) {
        HgtCache before = this.currentCache;
        HgtCache latest = this.latestCache();
        if (allowParallel && latest != null && latest != before) {
            latest.indexOnThread();
        }
    }

    private HgtCache latestCache() {
        HgtCache ret = this.currentCache;
        if (ret != null && !this.configurationChangePending) {
            return ret;
        }
        if (this.demFolder == null || this.algorithm == null) {
            this.currentCache = null;
            return null;
        }
        if (ret == null || this.enableInterpolationOverlap != this.currentCache.interpolatorOverlap || this.mainCacheSize != this.currentCache.mainCacheSize || this.neighborCacheSize != this.currentCache.neighborCacheSize || !this.demFolder.equals(this.currentCache.demFolder) || !this.algorithm.equals(this.currentCache.algorithm)) {
            this.currentCache = ret = new HgtCache(this.demFolder, this.enableInterpolationOverlap, this.graphicsFactory, this.algorithm, this.mainCacheSize, this.neighborCacheSize);
        }
        return ret;
    }

    @Override
    public void prepareOnThread() {
        if (this.currentCache != null) {
            this.currentCache.indexOnThread();
        }
    }

    @Override
    public HillshadingBitmap getHillshadingBitmap(int latitudeOfSouthWestCorner, int longituedOfSouthWestCorner, double pxPerLat, double pxPerLng) throws ExecutionException, InterruptedException {
        if (this.latestCache() == null) {
            return null;
        }
        return this.currentCache.getHillshadingBitmap(latitudeOfSouthWestCorner, longituedOfSouthWestCorner, pxPerLat, pxPerLng);
    }

    @Override
    public void setShadingAlgorithm(ShadingAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public void setDemFolder(File demFolder) {
        this.demFolder = demFolder;
    }

    public void setMainCacheSize(int mainCacheSize) {
        this.mainCacheSize = mainCacheSize;
    }

    public void setNeighborCacheSize(int neighborCacheSize) {
        this.neighborCacheSize = neighborCacheSize;
    }

    public void setEnableInterpolationOverlap(boolean enableInterpolationOverlap) {
        this.enableInterpolationOverlap = enableInterpolationOverlap;
    }

    public int getMainCacheSize() {
        return this.mainCacheSize;
    }

    public int getNeighborCacheSize() {
        return this.neighborCacheSize;
    }

    public boolean isEnableInterpolationOverlap() {
        return this.enableInterpolationOverlap;
    }

    public File getDemFolder() {
        return this.demFolder;
    }

    public ShadingAlgorithm getAlgorithm() {
        return this.algorithm;
    }
}

