/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.hills;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public abstract class LatchedLazyFuture<X>
implements Future<X> {
    private static final ExecutionException STARTED = new DummyExecutionException("started");
    private static final ExecutionException CANCELLED = new DummyExecutionException("cancelled");
    private static final ExecutionException DONE = new DummyExecutionException("done");
    private final AtomicReference<ExecutionException> state = new AtomicReference<Object>(null);
    private final CountDownLatch latch = new CountDownLatch(1);
    private volatile X result;
    private volatile Thread thread;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Thread t;
        if (this.state.get() == CANCELLED) {
            return true;
        }
        if (this.state.get() == DONE) {
            return false;
        }
        if (mayInterruptIfRunning && (t = this.thread) != null && this.state.compareAndSet(STARTED, CANCELLED)) {
            t.interrupt();
            return true;
        }
        return this.state.compareAndSet(null, CANCELLED);
    }

    @Override
    public boolean isCancelled() {
        return this.state.get() == CANCELLED;
    }

    @Override
    public boolean isDone() {
        ExecutionException state = this.state.get();
        return state != null && state != STARTED;
    }

    @Override
    public X get() throws InterruptedException, ExecutionException {
        if (this.state.compareAndSet(null, STARTED)) {
            this.internalCalc();
        } else {
            this.latch.await();
        }
        this.throwIfException();
        return this.result;
    }

    private void throwIfException() throws ExecutionException {
        ExecutionException executionException = this.state.get();
        if (executionException != null && !(executionException instanceof DummyExecutionException)) {
            throw executionException;
        }
    }

    @Override
    public X get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.state.compareAndSet(null, STARTED)) {
            this.internalCalc();
        } else {
            this.latch.await(timeout, unit);
        }
        this.throwIfException();
        return this.result;
    }

    private void internalCalc() throws ExecutionException, InterruptedException {
        this.thread = Thread.currentThread();
        try {
            this.result = this.calculate();
            this.state.compareAndSet(STARTED, DONE);
        }
        catch (RuntimeException e) {
            this.state.compareAndSet(STARTED, new ExecutionException(e));
        }
        catch (ExecutionException e) {
            this.state.compareAndSet(STARTED, e);
        }
        finally {
            this.thread = null;
            this.latch.countDown();
        }
    }

    protected abstract X calculate() throws ExecutionException, InterruptedException;

    public LatchedLazyFuture<X> withRunningThread() {
        if (this.state.get() == DONE) {
            return this;
        }
        if (this.state.compareAndSet(null, STARTED)) {
            Thread thread = new Thread(this.getClass().getName() + ".withRunningThread"){

                @Override
                public void run() {
                    try {
                        LatchedLazyFuture.this.internalCalc();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            };
            thread.start();
            return this;
        }
        return this;
    }

    private static class DummyExecutionException
    extends ExecutionException {
        DummyExecutionException(String name) {
            super(name, null);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }

        @Override
        public String toString() {
            return "[state marker " + this.getMessage() + "]";
        }
    }
}

