/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.hills;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.map.layer.hills.AbsShadingAlgorithmDefaults;
import org.mapsforge.map.layer.hills.HgtCache;

public class DiffuseLightShadingAlgorithm
extends AbsShadingAlgorithmDefaults {
    private static final Logger LOGGER = Logger.getLogger(DiffuseLightShadingAlgorithm.class.getName());
    private static final double halfPi = 1.5707963267948966;
    private final float heightAngle;
    private final double ast2;
    private final double neutral;
    private double a;

    public DiffuseLightShadingAlgorithm() {
        this(50.0f);
    }

    public DiffuseLightShadingAlgorithm(float heightAngle) {
        this.heightAngle = heightAngle;
        this.a = DiffuseLightShadingAlgorithm.heightAngleToRelativeHeight(heightAngle);
        this.ast2 = Math.sqrt(2.0 + this.a * this.a);
        this.neutral = this.calculateRaw(0.0, 0.0);
    }

    static double heightAngleToRelativeHeight(float heightAngle) {
        double radians = (double)heightAngle / 180.0 * Math.PI;
        return Math.tan(radians) * Math.sqrt(2.0);
    }

    private static short readNext(ByteBuffer din, short fallback) throws IOException {
        short read = din.getShort();
        if (read == Short.MIN_VALUE) {
            return fallback;
        }
        return read;
    }

    public double getLightHeight() {
        return this.a;
    }

    @Override
    public int getAxisLenght(HgtCache.HgtFileInfo source) {
        long size = source.getSize();
        long elements = size / 2L;
        int rowLen = (int)Math.ceil(Math.sqrt(elements));
        if ((long)(rowLen * rowLen * 2) != size) {
            return 0;
        }
        return rowLen - 1;
    }

    @Override
    protected byte[] convert(ByteBuffer din, int axisLength, int rowLen, int padding, HgtCache.HgtFileInfo fileInfo) throws IOException {
        short[] ringbuffer = new short[rowLen];
        byte[] bytes = new byte[(axisLength + 2 * padding) * (axisLength + 2 * padding)];
        int outidx = (axisLength + 2 * padding) * padding + padding;
        int rbcur = 0;
        short last = 0;
        for (int col = 0; col < rowLen; ++col) {
            last = DiffuseLightShadingAlgorithm.readNext(din, last);
            ringbuffer[rbcur++] = last;
        }
        double southPerPixel = MercatorProjection.calculateGroundResolution((double)fileInfo.southLat(), (long)(axisLength * 170));
        double northPerPixel = MercatorProjection.calculateGroundResolution((double)fileInfo.northLat(), (long)(axisLength * 170));
        double southPerPixelByLine = southPerPixel / (double)(2 * axisLength);
        double northPerPixelByLine = northPerPixel / (double)(2 * axisLength);
        for (int line = 1; line <= axisLength; ++line) {
            if (rbcur >= rowLen) {
                rbcur = 0;
            }
            short nw = ringbuffer[rbcur];
            short sw = DiffuseLightShadingAlgorithm.readNext(din, nw);
            ringbuffer[rbcur++] = sw;
            double halfmetersPerPixel = southPerPixelByLine * (double)line + northPerPixelByLine * (double)(axisLength - line);
            for (int col = 1; col <= axisLength; ++col) {
                short ne = ringbuffer[rbcur];
                short se = DiffuseLightShadingAlgorithm.readNext(din, ne);
                ringbuffer[rbcur++] = se;
                int noso = -(se - ne + (sw - nw));
                int eawe = -(ne - nw + (se - sw));
                int zeroIsFlat = this.calculate((double)noso / halfmetersPerPixel, (double)eawe / halfmetersPerPixel);
                int intVal = Math.min(255, Math.max(0, zeroIsFlat + 127));
                int shade = intVal & 0xFF;
                bytes[outidx++] = (byte)shade;
                nw = ne;
                sw = se;
            }
            outidx += 2 * padding;
        }
        return bytes;
    }

    int calculate(double n, double e) {
        double raw = this.calculateRaw(n, e);
        double v = raw - this.neutral;
        if (v < 0.0) {
            return (int)Math.round(128.0 * (v / this.neutral));
        }
        if (v > 0.0) {
            return (int)Math.round(127.0 * (v / (1.0 - this.neutral)));
        }
        return 0;
    }

    double calculateRaw(double n, double e) {
        double normPlaneDist = (e + n + this.a) / (this.ast2 * Math.sqrt(n * n + e * e + 1.0));
        double lightness = Math.max(0.0, normPlaneDist);
        return lightness;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiffuseLightShadingAlgorithm that = (DiffuseLightShadingAlgorithm)o;
        return Double.compare(that.a, this.a) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.a);
        return (int)(temp ^ temp >>> 32);
    }

    public String toString() {
        return "DiffuseLightShadingAlgorithm{heightAngle=" + this.heightAngle + '}';
    }
}

